package RepeatAnnotationData;
require Exporter;
@EXPORT_OK = qw( %repeatDB %lineHash %preProcData );
%EXPORT_TAGS = ( all => [ @EXPORT_OK ] );
@ISA         = qw(Exporter);

BEGIN {

  %repeatDB = (

          'hat-n68_dr' => {
                            'conlength' => '2959',
                            'subtype' => 'hAT-Ac',
                            'equiv' => [
                                         {
                                           'name' => 'DNA2-1_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '1.37',
                                                           'score' => '33',
                                                           'eqstart' => 3153,
                                                           'eqend' => 3225,
                                                           'start' => 2889,
                                                           'end' => 2961
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'piggyBac-N5_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '1.32',
                                                           'score' => '38',
                                                           'eqstart' => 1176,
                                                           'eqend' => 1251,
                                                           'start' => 2878,
                                                           'end' => 2953
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '40',
                                                           'eqstart' => 1179,
                                                           'eqend' => 1252,
                                                           'start' => 2881,
                                                           'end' => 2954
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'HATN12_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '5.88',
                                                           'score' => '54',
                                                           'eqstart' => 512,
                                                           'eqend' => 579,
                                                           'start' => 1,
                                                           'end' => 68
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-8-29_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '1.20',
                                                           'score' => '37',
                                                           'eqstart' => 831,
                                                           'eqend' => 914,
                                                           'start' => 2877,
                                                           'end' => 2959
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '34',
                                                           'eqstart' => 836,
                                                           'eqend' => 914,
                                                           'start' => 2882,
                                                           'end' => 2959
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-X-5_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '43',
                                                           'eqstart' => 1053,
                                                           'eqend' => 1131,
                                                           'start' => 2881,
                                                           'end' => 2959
                                                         },
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '39',
                                                           'eqstart' => 995,
                                                           'eqend' => 1072,
                                                           'start' => 2882,
                                                           'end' => 2959
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'ACROBAT1',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '1.25',
                                                           'score' => '42',
                                                           'eqstart' => 786,
                                                           'eqend' => 865,
                                                           'start' => 2880,
                                                           'end' => 2959
                                                         },
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '39',
                                                           'eqstart' => 780,
                                                           'eqend' => 857,
                                                           'start' => 2882,
                                                           'end' => 2959
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N36C_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '7.39',
                                                           'score' => '118',
                                                           'eqstart' => 4,
                                                           'eqend' => 180,
                                                           'start' => 117,
                                                           'end' => 292
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N55_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '7.02',
                                                           'score' => '40',
                                                           'eqstart' => 1783,
                                                           'eqend' => 1839,
                                                           'start' => 460,
                                                           'end' => 516
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '10.77',
                                                           'score' => '39',
                                                           'eqstart' => 1101,
                                                           'eqend' => 1165,
                                                           'start' => 1067,
                                                           'end' => 1131
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '4.65',
                                                           'score' => '31',
                                                           'eqstart' => 1016,
                                                           'eqend' => 1059,
                                                           'start' => 1165,
                                                           'end' => 1207
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-8-24_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '33',
                                                           'eqstart' => 74,
                                                           'eqend' => 151,
                                                           'start' => 2882,
                                                           'end' => 2958
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '34',
                                                           'eqstart' => 72,
                                                           'eqend' => 151,
                                                           'start' => 2883,
                                                           'end' => 2961
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-2-32_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '1.22',
                                                           'score' => '41',
                                                           'eqstart' => 5495,
                                                           'eqend' => 5576,
                                                           'start' => 2878,
                                                           'end' => 2959
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '39',
                                                           'eqstart' => 5499,
                                                           'eqend' => 5576,
                                                           'start' => 2882,
                                                           'end' => 2959
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-2-3_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '30',
                                                           'eqstart' => 625,
                                                           'eqend' => 684,
                                                           'start' => 2883,
                                                           'end' => 2942
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '30',
                                                           'eqstart' => 625,
                                                           'eqend' => 684,
                                                           'start' => 2899,
                                                           'end' => 2958
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'EnSpm-N1_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '1.27',
                                                           'score' => '38',
                                                           'eqstart' => 2006,
                                                           'eqend' => 2084,
                                                           'start' => 2876,
                                                           'end' => 2954
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '37',
                                                           'eqstart' => 2011,
                                                           'eqend' => 2084,
                                                           'start' => 2887,
                                                           'end' => 2960
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'HATN16_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '34',
                                                           'eqstart' => 783,
                                                           'eqend' => 844,
                                                           'start' => 2881,
                                                           'end' => 2942
                                                         },
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '31',
                                                           'eqstart' => 783,
                                                           'eqend' => 843,
                                                           'start' => 2883,
                                                           'end' => 2943
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'Kolobok-1_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '37',
                                                           'eqstart' => 2854,
                                                           'eqend' => 2928,
                                                           'start' => 2882,
                                                           'end' => 2956
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '40',
                                                           'eqstart' => 2849,
                                                           'eqend' => 2928,
                                                           'start' => 2885,
                                                           'end' => 2964
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N36_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '6.56',
                                                           'score' => '128',
                                                           'eqstart' => 4,
                                                           'eqend' => 187,
                                                           'start' => 117,
                                                           'end' => 299
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N21_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '37',
                                                           'eqstart' => 1667,
                                                           'eqend' => 1734,
                                                           'start' => 2880,
                                                           'end' => 2947
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '37',
                                                           'eqstart' => 1669,
                                                           'eqend' => 1735,
                                                           'start' => 2881,
                                                           'end' => 2947
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'Mariner-N3_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '39',
                                                           'eqstart' => 2204,
                                                           'eqend' => 2281,
                                                           'start' => 2882,
                                                           'end' => 2959
                                                         },
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '39',
                                                           'eqstart' => 2204,
                                                           'eqend' => 2281,
                                                           'start' => 2882,
                                                           'end' => 2959
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '31',
                                                           'eqstart' => 4699,
                                                           'eqend' => 4759,
                                                           'start' => 2900,
                                                           'end' => 2960
                                                         },
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '31',
                                                           'eqstart' => 4700,
                                                           'eqend' => 4761,
                                                           'start' => 2900,
                                                           'end' => 2961
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-TA-4_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '1.79',
                                                           'score' => '49',
                                                           'eqstart' => 7761,
                                                           'eqend' => 7816,
                                                           'start' => 2058,
                                                           'end' => 2113
                                                         },
                                                         {
                                                           'div' => '1.54',
                                                           'score' => '30',
                                                           'eqstart' => 1478,
                                                           'eqend' => 1542,
                                                           'start' => 2896,
                                                           'end' => 2960
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '31',
                                                           'eqstart' => 1478,
                                                           'eqend' => 1538,
                                                           'start' => 2899,
                                                           'end' => 2959
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-2-12_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '1.39',
                                                           'score' => '36',
                                                           'eqstart' => 774,
                                                           'eqend' => 845,
                                                           'start' => 2881,
                                                           'end' => 2952
                                                         },
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '33',
                                                           'eqstart' => 2463,
                                                           'eqend' => 2528,
                                                           'start' => 2882,
                                                           'end' => 2947
                                                         },
                                                         {
                                                           'div' => '1.41',
                                                           'score' => '33',
                                                           'eqstart' => 774,
                                                           'eqend' => 844,
                                                           'start' => 2883,
                                                           'end' => 2953
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '33',
                                                           'eqstart' => 2463,
                                                           'eqend' => 2528,
                                                           'start' => 2894,
                                                           'end' => 2959
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-X-12_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '47',
                                                           'eqstart' => 14183,
                                                           'eqend' => 14237,
                                                           'start' => 2316,
                                                           'end' => 2370
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N70_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '1.37',
                                                           'score' => '34',
                                                           'eqstart' => 540,
                                                           'eqend' => 612,
                                                           'start' => 2882,
                                                           'end' => 2954
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '1.35',
                                                           'score' => '34',
                                                           'eqstart' => 539,
                                                           'eqend' => 612,
                                                           'start' => 2887,
                                                           'end' => 2960
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-1-2_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '1.22',
                                                           'score' => '41',
                                                           'eqstart' => 315,
                                                           'eqend' => 396,
                                                           'start' => 2878,
                                                           'end' => 2959
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '33',
                                                           'eqstart' => 557,
                                                           'eqend' => 615,
                                                           'start' => 2881,
                                                           'end' => 2939
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '39',
                                                           'eqstart' => 319,
                                                           'eqend' => 396,
                                                           'start' => 2882,
                                                           'end' => 2959
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'Dada-tL_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '30',
                                                           'eqstart' => '4729',
                                                           'eqend' => '4788',
                                                           'start' => '2883',
                                                           'end' => '2942'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '30',
                                                           'eqstart' => '4729',
                                                           'eqend' => '4788',
                                                           'start' => '2899',
                                                           'end' => '2958'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-2-24_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '45',
                                                           'eqstart' => 738,
                                                           'eqend' => 821,
                                                           'start' => 2876,
                                                           'end' => 2959
                                                         },
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '39',
                                                           'eqstart' => 547,
                                                           'eqend' => 624,
                                                           'start' => 2882,
                                                           'end' => 2959
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N36B_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '7.65',
                                                           'score' => '120',
                                                           'eqstart' => 4,
                                                           'eqend' => 187,
                                                           'start' => 117,
                                                           'end' => 299
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'EnSpm-6N1_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '39',
                                                           'eqstart' => 948,
                                                           'eqend' => 1026,
                                                           'start' => 2882,
                                                           'end' => 2960
                                                         },
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '40',
                                                           'eqstart' => 949,
                                                           'eqend' => 1028,
                                                           'start' => 2882,
                                                           'end' => 2961
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '30',
                                                           'eqstart' => 1474,
                                                           'eqend' => 1533,
                                                           'start' => 2900,
                                                           'end' => 2959
                                                         },
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '31',
                                                           'eqstart' => 1474,
                                                           'eqend' => 1534,
                                                           'start' => 2900,
                                                           'end' => 2960
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'Dada-U6_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '1.30',
                                                           'score' => '39',
                                                           'eqstart' => '7116',
                                                           'eqend' => '7192',
                                                           'start' => '2878',
                                                           'end' => '2954'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '42',
                                                           'eqstart' => '799',
                                                           'eqend' => '875',
                                                           'start' => '2881',
                                                           'end' => '2957'
                                                         },
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '42',
                                                           'eqstart' => '798',
                                                           'eqend' => '874',
                                                           'start' => '2881',
                                                           'end' => '2957'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '37',
                                                           'eqstart' => '7119',
                                                           'eqend' => '7192',
                                                           'start' => '2885',
                                                           'end' => '2958'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'EnSpm-5_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '30',
                                                           'eqstart' => 2782,
                                                           'eqend' => 2840,
                                                           'start' => 2882,
                                                           'end' => 2940
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '30',
                                                           'eqstart' => 2781,
                                                           'eqend' => 2840,
                                                           'start' => 2901,
                                                           'end' => 2960
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'EnSpm-N2_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '39',
                                                           'eqstart' => 2924,
                                                           'eqend' => 3001,
                                                           'start' => 2882,
                                                           'end' => 2959
                                                         },
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '39',
                                                           'eqstart' => 2988,
                                                           'eqend' => 3066,
                                                           'start' => 2882,
                                                           'end' => 2960
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'Dada-tA_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '1.20',
                                                           'score' => '37',
                                                           'eqstart' => '8200',
                                                           'eqend' => '8283',
                                                           'start' => '2878',
                                                           'end' => '2960'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '34',
                                                           'eqstart' => '8204',
                                                           'eqend' => '8282',
                                                           'start' => '2882',
                                                           'end' => '2959'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N39_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '34',
                                                           'eqstart' => 251,
                                                           'eqend' => 329,
                                                           'start' => 2882,
                                                           'end' => 2959
                                                         },
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '34',
                                                           'eqstart' => 251,
                                                           'eqend' => 329,
                                                           'start' => 2882,
                                                           'end' => 2959
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-2-24B_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '1.20',
                                                           'score' => '42',
                                                           'eqstart' => 1342,
                                                           'eqend' => 1424,
                                                           'start' => 2877,
                                                           'end' => 2959
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '39',
                                                           'eqstart' => 1347,
                                                           'eqend' => 1424,
                                                           'start' => 2882,
                                                           'end' => 2959
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'dna-2-31_dr' => {
                             'conlength' => '852',
                             'subtype' => 'TcMar-ISRm11',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'ucon21' => {
                        'conlength' => '330',
                        'subtype' => undef,
                        'equiv' => [],
                        'type' => 'DNA'
                      },
          'mariner-6_ami' => {
                               'conlength' => '2479',
                               'subtype' => 'TcMar-Tc2',
                               'equiv' => [
                                            {
                                              'name' => 'Mariner-6B_AMi',
                                              'ranges' => [
                                                            {
                                                              'div' => '5.75',
                                                              'score' => '64',
                                                              'eqstart' => '153',
                                                              'eqend' => '239',
                                                              'start' => '202',
                                                              'end' => '288'
                                                            },
                                                            {
                                                              'div' => '0.00',
                                                              'score' => '58',
                                                              'eqstart' => '282',
                                                              'eqend' => '341',
                                                              'start' => '475',
                                                              'end' => '534'
                                                            },
                                                            {
                                                              'div' => '3.25',
                                                              'score' => '1108',
                                                              'eqstart' => '387',
                                                              'eqend' => '1646',
                                                              'start' => '653',
                                                              'end' => '1912'
                                                            },
                                                            {
                                                              'div' => '5.11',
                                                              'score' => '81',
                                                              'eqstart' => '1645',
                                                              'eqend' => '1777',
                                                              'start' => '1947',
                                                              'end' => '2083'
                                                            }
                                                          ]
                                            }
                                          ],
                               'type' => 'DNA'
                             },
          'enspm-n1_sb' => {
                             'conlength' => '602',
                             'subtype' => 'CMC-EnSpm',
                             'equiv' => [
                                          {
                                            'name' => 'EnSpm-N4_SBi',
                                            'ranges' => [
                                                          {
                                                            'div' => '12.38',
                                                            'score' => '96',
                                                            'eqstart' => 1411,
                                                            'eqend' => 1611,
                                                            'start' => 427,
                                                            'end' => 628
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'EnSpm-N11_SBi',
                                            'ranges' => [
                                                          {
                                                            'div' => '9.09',
                                                            'score' => '39',
                                                            'eqstart' => 946,
                                                            'eqend' => 1011,
                                                            'start' => 392,
                                                            'end' => 457
                                                          },
                                                          {
                                                            'div' => '8.23',
                                                            'score' => '140',
                                                            'eqstart' => 806,
                                                            'eqend' => 1037,
                                                            'start' => 401,
                                                            'end' => 631
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'EnSpm8_SB',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.42',
                                                            'score' => '68',
                                                            'eqstart' => 1238,
                                                            'eqend' => 1390,
                                                            'start' => 637,
                                                            'end' => 789
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'EnSpm4_SB',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.22',
                                                            'score' => '33',
                                                            'eqstart' => 11398,
                                                            'eqend' => 11493,
                                                            'start' => 189,
                                                            'end' => 286
                                                          },
                                                          {
                                                            'div' => '11.30',
                                                            'score' => '86',
                                                            'eqstart' => 11480,
                                                            'eqend' => 11657,
                                                            'start' => 890,
                                                            'end' => 1066
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'hat6-n2_nv' => {
                            'conlength' => '190',
                            'subtype' => 'hAT-Blackjack',
                            'equiv' => [
                                         {
                                           'name' => 'hAT6-N3_NV',
                                           'ranges' => [
                                                         {
                                                           'div' => '4.35',
                                                           'score' => '34',
                                                           'eqstart' => 1,
                                                           'eqend' => 46,
                                                           'start' => 1,
                                                           'end' => 46
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'enspm-21_hma' => {
                              'conlength' => '4532',
                              'subtype' => 'CMC-EnSpm',
                              'equiv' => [
                                           {
                                             'name' => 'EnSpm-5_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '36',
                                                             'eqstart' => '3611',
                                                             'eqend' => '3681',
                                                             'start' => '4458',
                                                             'end' => '4528'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '36',
                                                             'eqstart' => '3611',
                                                             'eqend' => '3681',
                                                             'start' => '4461',
                                                             'end' => '4531'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Mariner-19_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '38',
                                                             'eqstart' => '1030',
                                                             'eqend' => '1105',
                                                             'start' => '4457',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '1029',
                                                             'eqend' => '1103',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'P-27_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '5187',
                                                             'eqend' => '5288',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'div' => '5.88',
                                                             'score' => '50',
                                                             'eqstart' => '5105',
                                                             'eqend' => '5206',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Transib-2_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '6.54',
                                                             'score' => '50',
                                                             'eqstart' => '609',
                                                             'eqend' => '715',
                                                             'start' => '4453',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '614',
                                                             'eqend' => '715',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'DNA-8-1_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '6.12',
                                                             'score' => '44',
                                                             'eqstart' => '1624',
                                                             'eqend' => '1721',
                                                             'start' => '4456',
                                                             'end' => '4553'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.25',
                                                             'score' => '43',
                                                             'eqstart' => '1626',
                                                             'eqend' => '1721',
                                                             'start' => '4458',
                                                             'end' => '4553'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Academ-1_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '33',
                                                             'eqstart' => '731',
                                                             'eqend' => '795',
                                                             'start' => '4456',
                                                             'end' => '4520'
                                                           },
                                                           {
                                                             'div' => '2.41',
                                                             'score' => '41',
                                                             'eqstart' => '731',
                                                             'eqend' => '812',
                                                             'start' => '4465',
                                                             'end' => '4547'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'EnSpm-9_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '1.23',
                                                             'score' => '35',
                                                             'eqstart' => '2995',
                                                             'eqend' => '3075',
                                                             'start' => '4452',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '2980',
                                                             'eqend' => '3054',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'hATm-54_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '7.48',
                                                             'score' => '45',
                                                             'eqstart' => '499',
                                                             'eqend' => '605',
                                                             'start' => '4453',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.80',
                                                             'score' => '47',
                                                             'eqstart' => '510',
                                                             'eqend' => '612',
                                                             'start' => '4457',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'P-34_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '6.32',
                                                             'score' => '42',
                                                             'eqstart' => '3001',
                                                             'eqend' => '3095',
                                                             'start' => '4458',
                                                             'end' => '4552'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.32',
                                                             'score' => '43',
                                                             'eqstart' => '3001',
                                                             'eqend' => '3095',
                                                             'start' => '4459',
                                                             'end' => '4553'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'hATw-3_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '673',
                                                             'eqend' => '747',
                                                             'start' => '4457',
                                                             'end' => '4531'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '674',
                                                             'eqend' => '747',
                                                             'start' => '4458',
                                                             'end' => '4531'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Mariner-33_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '7.02',
                                                             'score' => '45',
                                                             'eqstart' => '734',
                                                             'eqend' => '848',
                                                             'start' => '4446',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.60',
                                                             'score' => '49',
                                                             'eqstart' => '783',
                                                             'eqend' => '888',
                                                             'start' => '4454',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Harbinger2-2_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '255',
                                                             'eqend' => '356',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '255',
                                                             'eqend' => '356',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Ginger1-5_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '38',
                                                             'eqstart' => '4479',
                                                             'eqend' => '4555',
                                                             'start' => '4456',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '4464',
                                                             'eqend' => '4538',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Mariner-31_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '6.80',
                                                             'score' => '47',
                                                             'eqstart' => '858',
                                                             'eqend' => '960',
                                                             'start' => '4457',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '859',
                                                             'eqend' => '960',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Sola2-1_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '41',
                                                             'eqstart' => '1335',
                                                             'eqend' => '1417',
                                                             'start' => '4450',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '38',
                                                             'eqstart' => '831',
                                                             'eqend' => '906',
                                                             'start' => '4457',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '828',
                                                             'eqend' => '902',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '1344',
                                                             'eqend' => '1418',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'EnSpm-8_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '3194',
                                                             'eqend' => '3268',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '3195',
                                                             'eqend' => '3269',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Chapaev-6_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '6.80',
                                                             'score' => '47',
                                                             'eqstart' => '4410',
                                                             'eqend' => '4512',
                                                             'start' => '4457',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '4411',
                                                             'eqend' => '4512',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'hATm-12_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '35',
                                                             'eqstart' => '869',
                                                             'eqend' => '938',
                                                             'start' => '4455',
                                                             'end' => '4524'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '34',
                                                             'eqstart' => '869',
                                                             'eqend' => '935',
                                                             'start' => '4459',
                                                             'end' => '4525'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Mariner-36_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '7.00',
                                                             'score' => '46',
                                                             'eqstart' => '898',
                                                             'eqend' => '997',
                                                             'start' => '4459',
                                                             'end' => '4558'
                                                           },
                                                           {
                                                             'div' => '7.00',
                                                             'score' => '46',
                                                             'eqstart' => '898',
                                                             'eqend' => '997',
                                                             'start' => '4459',
                                                             'end' => '4558'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Transib-3_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '6.80',
                                                             'score' => '47',
                                                             'eqstart' => '591',
                                                             'eqend' => '693',
                                                             'start' => '4457',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '592',
                                                             'eqend' => '693',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'EnSpm-7_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '1.23',
                                                             'score' => '36',
                                                             'eqstart' => '3181',
                                                             'eqend' => '3261',
                                                             'start' => '4452',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '1.32',
                                                             'score' => '34',
                                                             'eqstart' => '3171',
                                                             'eqend' => '3246',
                                                             'start' => '4457',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '3567',
                                                             'eqend' => '3668',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '3978',
                                                             'eqend' => '4052',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '503',
                                                             'eqend' => '577',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '4.26',
                                                             'score' => '48',
                                                             'eqstart' => '3657',
                                                             'eqend' => '3750',
                                                             'start' => '4458',
                                                             'end' => '4551'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '42',
                                                             'eqstart' => '3985',
                                                             'eqend' => '4061',
                                                             'start' => '4458',
                                                             'end' => '4534'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.38',
                                                             'score' => '46',
                                                             'eqstart' => '499',
                                                             'eqend' => '592',
                                                             'start' => '4464',
                                                             'end' => '4557'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'hATm-47_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '41',
                                                             'eqstart' => '3505',
                                                             'eqend' => '3580',
                                                             'start' => '4458',
                                                             'end' => '4533'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '3507',
                                                             'eqend' => '3581',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'hAT-80_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '801',
                                                             'eqend' => '875',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '802',
                                                             'eqend' => '876',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'EnSpm-22_HMa',
                                             'ranges' => [
                                                           {
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '2059',
                                                             'eqend' => '2160',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'div' => '6.25',
                                                             'score' => '43',
                                                             'eqstart' => '2530',
                                                             'eqend' => '2625',
                                                             'start' => '4458',
                                                             'end' => '4553'
                                                           },
                                                           {
                                                             'div' => '5.21',
                                                             'score' => '46',
                                                             'eqstart' => '5691',
                                                             'eqend' => '5786',
                                                             'start' => '4458',
                                                             'end' => '4553'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '4.30',
                                                             'score' => '47',
                                                             'eqstart' => '2046',
                                                             'eqend' => '2138',
                                                             'start' => '4458',
                                                             'end' => '4550'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.25',
                                                             'score' => '43',
                                                             'eqstart' => '2530',
                                                             'eqend' => '2625',
                                                             'start' => '4458',
                                                             'end' => '4553'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '5647',
                                                             'eqend' => '5748',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'hAT-54_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '4682',
                                                             'eqend' => '4756',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '4681',
                                                             'eqend' => '4755',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Chapaev-20_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '6.80',
                                                             'score' => '47',
                                                             'eqstart' => '218',
                                                             'eqend' => '320',
                                                             'start' => '4457',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '219',
                                                             'eqend' => '320',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Chapaev-7_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '38',
                                                             'eqstart' => '1758',
                                                             'eqend' => '1833',
                                                             'start' => '4456',
                                                             'end' => '4531'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '1760',
                                                             'eqend' => '1833',
                                                             'start' => '4458',
                                                             'end' => '4531'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'EnSpm-2_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '7.62',
                                                             'score' => '50',
                                                             'eqstart' => '5074',
                                                             'eqend' => '5178',
                                                             'start' => '4458',
                                                             'end' => '4562'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.25',
                                                             'score' => '43',
                                                             'eqstart' => '5074',
                                                             'eqend' => '5169',
                                                             'start' => '4458',
                                                             'end' => '4553'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'EnSpm-10_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '1.30',
                                                             'score' => '35',
                                                             'eqstart' => '861',
                                                             'eqend' => '937',
                                                             'start' => '4456',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '38',
                                                             'eqstart' => '3949',
                                                             'eqend' => '4024',
                                                             'start' => '4457',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '3951',
                                                             'eqend' => '4025',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '1.33',
                                                             'score' => '34',
                                                             'eqstart' => '860',
                                                             'eqend' => '934',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'P-26_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '33',
                                                             'eqstart' => '525',
                                                             'eqend' => '589',
                                                             'start' => '4458',
                                                             'end' => '4522'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '33',
                                                             'eqstart' => '525',
                                                             'eqend' => '589',
                                                             'start' => '4467',
                                                             'end' => '4531'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'P-2_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '384',
                                                             'eqend' => '458',
                                                             'start' => '4457',
                                                             'end' => '4531'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '385',
                                                             'eqend' => '458',
                                                             'start' => '4458',
                                                             'end' => '4531'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'hATm-19_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '3101',
                                                             'eqend' => '3184',
                                                             'start' => '4448',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '3100',
                                                             'eqend' => '3174',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Transib-6_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '5.88',
                                                             'score' => '50',
                                                             'eqstart' => '870',
                                                             'eqend' => '971',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '862',
                                                             'eqend' => '963',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'EnSpm-15_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '6706',
                                                             'eqend' => '6807',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'div' => '5.88',
                                                             'score' => '50',
                                                             'eqstart' => '6730',
                                                             'eqend' => '6831',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'hATm-40_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '1.39',
                                                             'score' => '33',
                                                             'eqstart' => '1317',
                                                             'eqend' => '1388',
                                                             'start' => '4456',
                                                             'end' => '4527'
                                                           },
                                                           {
                                                             'div' => '1.41',
                                                             'score' => '33',
                                                             'eqstart' => '1316',
                                                             'eqend' => '1386',
                                                             'start' => '4457',
                                                             'end' => '4527'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Chapaev-3_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '38',
                                                             'eqstart' => '4897',
                                                             'eqend' => '4972',
                                                             'start' => '4457',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.73',
                                                             'score' => '51',
                                                             'eqstart' => '4446',
                                                             'eqend' => '4549',
                                                             'start' => '4458',
                                                             'end' => '4561'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '4899',
                                                             'eqend' => '4973',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '4448',
                                                             'eqend' => '4549',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Transib-10_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '5.88',
                                                             'score' => '50',
                                                             'eqstart' => '950',
                                                             'eqend' => '1051',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '944',
                                                             'eqend' => '1045',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'EnSpm-16_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.25',
                                                             'score' => '43',
                                                             'eqstart' => '5375',
                                                             'eqend' => '5470',
                                                             'start' => '4458',
                                                             'end' => '4553'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '45',
                                                             'eqstart' => '5397',
                                                             'eqend' => '5474',
                                                             'start' => '4458',
                                                             'end' => '4535'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Chapaev-3A_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '7.77',
                                                             'score' => '47',
                                                             'eqstart' => '3926',
                                                             'eqend' => '4028',
                                                             'start' => '4458',
                                                             'end' => '4560'
                                                           },
                                                           {
                                                             'div' => '5.15',
                                                             'score' => '50',
                                                             'eqstart' => '3935',
                                                             'eqend' => '4031',
                                                             'start' => '4458',
                                                             'end' => '4554'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.93',
                                                             'score' => '49',
                                                             'eqstart' => '3339',
                                                             'eqend' => '3439',
                                                             'start' => '4460',
                                                             'end' => '4560'
                                                           },
                                                           {
                                                             'div' => '6.93',
                                                             'score' => '49',
                                                             'eqstart' => '3340',
                                                             'eqend' => '3440',
                                                             'start' => '4460',
                                                             'end' => '4560'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'hAT-27_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '31',
                                                             'eqstart' => '682',
                                                             'eqend' => '743',
                                                             'start' => '4459',
                                                             'end' => '4520'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '31',
                                                             'eqstart' => '682',
                                                             'eqend' => '743',
                                                             'start' => '4471',
                                                             'end' => '4532'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'hAT-47_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.73',
                                                             'score' => '48',
                                                             'eqstart' => '136',
                                                             'eqend' => '239',
                                                             'start' => '4456',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '72',
                                                             'eqend' => '173',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'EnSpm-14_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '5.88',
                                                             'score' => '50',
                                                             'eqstart' => '4518',
                                                             'eqend' => '4619',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '4508',
                                                             'eqend' => '4609',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Mariner-30_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '6.60',
                                                             'score' => '49',
                                                             'eqstart' => '805',
                                                             'eqend' => '910',
                                                             'start' => '4454',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '809',
                                                             'eqend' => '910',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Ginger1-10_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '6.25',
                                                             'score' => '32',
                                                             'eqstart' => '3489',
                                                             'eqend' => '3599',
                                                             'start' => '4447',
                                                             'end' => '4558'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.73',
                                                             'score' => '48',
                                                             'eqstart' => '4795',
                                                             'eqend' => '4898',
                                                             'start' => '4456',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'div' => '6.00',
                                                             'score' => '49',
                                                             'eqstart' => '3352',
                                                             'eqend' => '3451',
                                                             'start' => '4458',
                                                             'end' => '4557'
                                                           },
                                                           {
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '4777',
                                                             'eqend' => '4878',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '3312',
                                                             'eqend' => '3413',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '5.88',
                                                             'score' => '36',
                                                             'eqstart' => '3497',
                                                             'eqend' => '3598',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'EnSpm-1_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '1194',
                                                             'eqend' => '1295',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'div' => '6.67',
                                                             'score' => '53',
                                                             'eqstart' => '3126',
                                                             'eqend' => '3230',
                                                             'start' => '4458',
                                                             'end' => '4562'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '1194',
                                                             'eqend' => '1295',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.67',
                                                             'score' => '53',
                                                             'eqstart' => '3121',
                                                             'eqend' => '3225',
                                                             'start' => '4458',
                                                             'end' => '4562'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'P-30_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '7.84',
                                                             'score' => '44',
                                                             'eqstart' => '3377',
                                                             'eqend' => '3478',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'div' => '6.25',
                                                             'score' => '43',
                                                             'eqstart' => '4468',
                                                             'eqend' => '4563',
                                                             'start' => '4458',
                                                             'end' => '4553'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '1.12',
                                                             'score' => '54',
                                                             'eqstart' => '4453',
                                                             'eqend' => '4541',
                                                             'start' => '4458',
                                                             'end' => '4546'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.12',
                                                             'score' => '48',
                                                             'eqstart' => '3381',
                                                             'eqend' => '3478',
                                                             'start' => '4462',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Chapaev-8_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '1.25',
                                                             'score' => '35',
                                                             'eqstart' => '7747',
                                                             'eqend' => '7826',
                                                             'start' => '4453',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.80',
                                                             'score' => '47',
                                                             'eqstart' => '3214',
                                                             'eqend' => '3316',
                                                             'start' => '4456',
                                                             'end' => '4558'
                                                           },
                                                           {
                                                             'div' => '7.69',
                                                             'score' => '45',
                                                             'eqstart' => '3203',
                                                             'eqend' => '3306',
                                                             'start' => '4456',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '7188',
                                                             'eqend' => '7262',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '7753',
                                                             'eqend' => '7827',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '8.74',
                                                             'score' => '44',
                                                             'eqstart' => '6523',
                                                             'eqend' => '6625',
                                                             'start' => '4458',
                                                             'end' => '4560'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '7189',
                                                             'eqend' => '7263',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '7.00',
                                                             'score' => '46',
                                                             'eqstart' => '6525',
                                                             'eqend' => '6624',
                                                             'start' => '4460',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'EnSpm-4_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '31',
                                                             'eqstart' => '5072',
                                                             'eqend' => '5133',
                                                             'start' => '4457',
                                                             'end' => '4518'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '31',
                                                             'eqstart' => '5073',
                                                             'eqend' => '5133',
                                                             'start' => '4471',
                                                             'end' => '4531'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Mariner-29_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '1.33',
                                                             'score' => '34',
                                                             'eqstart' => '1549',
                                                             'eqend' => '1623',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '5.88',
                                                             'score' => '48',
                                                             'eqstart' => '1136',
                                                             'eqend' => '1237',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '7.77',
                                                             'score' => '47',
                                                             'eqstart' => '1129',
                                                             'eqend' => '1231',
                                                             'start' => '4460',
                                                             'end' => '4562'
                                                           },
                                                           {
                                                             'div' => '6.19',
                                                             'score' => '42',
                                                             'eqstart' => '1548',
                                                             'eqend' => '1645',
                                                             'start' => '4462',
                                                             'end' => '4558'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'MuDr-3_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.73',
                                                             'score' => '51',
                                                             'eqstart' => '4285',
                                                             'eqend' => '4388',
                                                             'start' => '4458',
                                                             'end' => '4561'
                                                           },
                                                           {
                                                             'div' => '4.21',
                                                             'score' => '48',
                                                             'eqstart' => '4545',
                                                             'eqend' => '4639',
                                                             'start' => '4458',
                                                             'end' => '4552'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'EnSpm-17_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '6.73',
                                                             'score' => '51',
                                                             'eqstart' => '3119',
                                                             'eqend' => '3222',
                                                             'start' => '4458',
                                                             'end' => '4561'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '3107',
                                                             'eqend' => '3208',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'EnSpm-19_HMa',
                                             'ranges' => [
                                                           {
                                                             'div' => '1.23',
                                                             'score' => '35',
                                                             'eqstart' => '764',
                                                             'eqend' => '844',
                                                             'start' => '4452',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '769',
                                                             'eqend' => '843',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Ginger1-6_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.73',
                                                             'score' => '48',
                                                             'eqstart' => '612',
                                                             'eqend' => '715',
                                                             'start' => '4456',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '38',
                                                             'eqstart' => '369',
                                                             'eqend' => '444',
                                                             'start' => '4457',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '562',
                                                             'eqend' => '663',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '371',
                                                             'eqend' => '445',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Transib-1_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.25',
                                                             'score' => '43',
                                                             'eqstart' => '1583',
                                                             'eqend' => '1678',
                                                             'start' => '4458',
                                                             'end' => '4553'
                                                           },
                                                           {
                                                             'div' => '6.25',
                                                             'score' => '43',
                                                             'eqstart' => '1583',
                                                             'eqend' => '1678',
                                                             'start' => '4458',
                                                             'end' => '4553'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'P-29_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '6.60',
                                                             'score' => '49',
                                                             'eqstart' => '3352',
                                                             'eqend' => '3457',
                                                             'start' => '4454',
                                                             'end' => '4559'
                                                           },
                                                           {
                                                             'div' => '6.86',
                                                             'score' => '47',
                                                             'eqstart' => '3344',
                                                             'eqend' => '3445',
                                                             'start' => '4458',
                                                             'end' => '4559'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Chapaev-3B_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '1.23',
                                                             'score' => '35',
                                                             'eqstart' => '2939',
                                                             'eqend' => '3019',
                                                             'start' => '4452',
                                                             'end' => '4532'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '37',
                                                             'eqstart' => '2934',
                                                             'eqend' => '3008',
                                                             'start' => '4458',
                                                             'end' => '4532'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'hAT-51_HM',
                                             'ranges' => [
                                                           {
                                                             'compl' => 1,
                                                             'div' => '5.83',
                                                             'score' => '48',
                                                             'eqstart' => '3437',
                                                             'eqend' => '3540',
                                                             'start' => '4458',
                                                             'end' => '4560'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '41',
                                                             'eqstart' => '3489',
                                                             'eqend' => '3564',
                                                             'start' => '4458',
                                                             'end' => '4533'
                                                           }
                                                         ]
                                           }
                                         ],
                              'type' => 'DNA'
                            },
          'hat-894_ami' => {
                             'conlength' => '184',
                             'subtype' => 'hAT-Blackjack',
                             'equiv' => [
                                          {
                                            'name' => 'hAT-N22_AMi',
                                            'ranges' => [
                                                          {
                                                            'div' => '6.49',
                                                            'score' => '51',
                                                            'eqstart' => '25',
                                                            'eqend' => '101',
                                                            'start' => '14',
                                                            'end' => '90'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '1.39',
                                                            'score' => '55',
                                                            'eqstart' => '25',
                                                            'eqend' => '101',
                                                            'start' => '100',
                                                            'end' => '171'
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'dna8-9_cb' => {
                           'conlength' => '696',
                           'subtype' => undef,
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'tc1-10_xt' => {
                           'conlength' => '1606',
                           'subtype' => 'TcMar-Tc1',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'parisa_dk' => {
                           'conlength' => '1730',
                           'subtype' => 'TcMar-Tc1',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'wuwu' => {
                      'conlength' => '113',
                      'subtype' => 'MULE-MuDR',
                      'equiv' => [],
                      'type' => 'DNA'
                    },
          'arnold3' => {
                         'conlength' => '13784',
                         'subtype' => 'MULE-MuDR',
                         'equiv' => [
                                      {
                                        'name' => 'Arnold1',
                                        'ranges' => [
                                                      {
                                                        'div' => '6.86',
                                                        'score' => '1175',
                                                        'eqstart' => 29,
                                                        'eqend' => 2728,
                                                        'start' => 15,
                                                        'end' => 2727
                                                      },
                                                      {
                                                        'div' => '2.43',
                                                        'score' => '233',
                                                        'eqstart' => 711,
                                                        'eqend' => 999,
                                                        'start' => 615,
                                                        'end' => 902
                                                      },
                                                      {
                                                        'div' => '1.02',
                                                        'score' => '169',
                                                        'eqstart' => 803,
                                                        'eqend' => 999,
                                                        'start' => 623,
                                                        'end' => 818
                                                      },
                                                      {
                                                        'div' => '11.59',
                                                        'score' => '33',
                                                        'eqstart' => 11445,
                                                        'eqend' => 11581,
                                                        'start' => 636,
                                                        'end' => 773
                                                      },
                                                      {
                                                        'div' => '8.86',
                                                        'score' => '40',
                                                        'eqstart' => 14638,
                                                        'eqend' => 14715,
                                                        'start' => 659,
                                                        'end' => 737
                                                      },
                                                      {
                                                        'div' => '6.85',
                                                        'score' => '30',
                                                        'eqstart' => 14797,
                                                        'eqend' => 14868,
                                                        'start' => 661,
                                                        'end' => 733
                                                      },
                                                      {
                                                        'div' => '12.73',
                                                        'score' => '37',
                                                        'eqstart' => 14325,
                                                        'eqend' => 14690,
                                                        'start' => 671,
                                                        'end' => 1047
                                                      },
                                                      {
                                                        'div' => '2.05',
                                                        'score' => '687',
                                                        'eqstart' => 639,
                                                        'eqend' => 1465,
                                                        'start' => 707,
                                                        'end' => 1537
                                                      },
                                                      {
                                                        'div' => '12.12',
                                                        'score' => '31',
                                                        'eqstart' => '14215',
                                                        'eqend' => '14532',
                                                        'start' => 718,
                                                        'end' => '1047'
                                                      },
                                                      {
                                                        'div' => '12.77',
                                                        'score' => '33',
                                                        'eqstart' => 11397,
                                                        'eqend' => 11583,
                                                        'start' => 756,
                                                        'end' => 943
                                                      },
                                                      {
                                                        'div' => '2.86',
                                                        'score' => '204',
                                                        'eqstart' => 639,
                                                        'eqend' => 914,
                                                        'start' => 791,
                                                        'end' => 1070
                                                      },
                                                      {
                                                        'div' => '12.23',
                                                        'score' => '35',
                                                        'eqstart' => 11397,
                                                        'eqend' => 11583,
                                                        'start' => 840,
                                                        'end' => 1027
                                                      },
                                                      {
                                                        'div' => '9.09',
                                                        'score' => '30',
                                                        'eqstart' => 14651,
                                                        'eqend' => 14715,
                                                        'start' => 840,
                                                        'end' => 905
                                                      },
                                                      {
                                                        'div' => '2.15',
                                                        'score' => '138',
                                                        'eqstart' => 649,
                                                        'eqend' => 830,
                                                        'start' => 885,
                                                        'end' => 1070
                                                      },
                                                      {
                                                        'div' => '11.20',
                                                        'score' => '33',
                                                        'eqstart' => '14325',
                                                        'eqend' => '14449',
                                                        'start' => 923,
                                                        'end' => '1047'
                                                      },
                                                      {
                                                        'div' => '12.71',
                                                        'score' => '38',
                                                        'eqstart' => 11397,
                                                        'eqend' => 11513,
                                                        'start' => 924,
                                                        'end' => 1041
                                                      },
                                                      {
                                                        'div' => '1.96',
                                                        'score' => '70',
                                                        'eqstart' => 649,
                                                        'eqend' => 746,
                                                        'start' => 969,
                                                        'end' => 1070
                                                      },
                                                      {
                                                        'div' => '4.11',
                                                        'score' => '50',
                                                        'eqstart' => 1715,
                                                        'eqend' => 1787,
                                                        'start' => 1556,
                                                        'end' => 1628
                                                      },
                                                      {
                                                        'div' => '7.91',
                                                        'score' => '107',
                                                        'eqstart' => 1446,
                                                        'eqend' => 1622,
                                                        'start' => 1605,
                                                        'end' => 1781
                                                      },
                                                      {
                                                        'div' => '2.19',
                                                        'score' => '647',
                                                        'eqstart' => 2732,
                                                        'eqend' => 3507,
                                                        'start' => 3642,
                                                        'end' => 4418
                                                      },
                                                      {
                                                        'div' => '9.95',
                                                        'score' => '87',
                                                        'eqstart' => 3160,
                                                        'eqend' => 3360,
                                                        'start' => 3843,
                                                        'end' => 4043
                                                      },
                                                      {
                                                        'div' => '9.95',
                                                        'score' => '82',
                                                        'eqstart' => 2932,
                                                        'eqend' => 3132,
                                                        'start' => 4071,
                                                        'end' => 4271
                                                      },
                                                      {
                                                        'div' => '12.61',
                                                        'score' => '59',
                                                        'eqstart' => 11397,
                                                        'eqend' => 11633,
                                                        'start' => 4182,
                                                        'end' => 4419
                                                      },
                                                      {
                                                        'div' => '6.78',
                                                        'score' => '33',
                                                        'eqstart' => 14217,
                                                        'eqend' => 14275,
                                                        'start' => 4231,
                                                        'end' => 4289
                                                      },
                                                      {
                                                        'div' => '7.69',
                                                        'score' => '56',
                                                        'eqstart' => 14724,
                                                        'eqend' => 14827,
                                                        'start' => 4266,
                                                        'end' => 4369
                                                      },
                                                      {
                                                        'div' => '2.61',
                                                        'score' => '1081',
                                                        'eqstart' => 3501,
                                                        'eqend' => 4805,
                                                        'start' => 4485,
                                                        'end' => 5789
                                                      },
                                                      {
                                                        'div' => '4.52',
                                                        'score' => '368',
                                                        'eqstart' => 4581,
                                                        'eqend' => 5108,
                                                        'start' => 5338,
                                                        'end' => 5868
                                                      },
                                                      {
                                                        'div' => '9.78',
                                                        'score' => '95',
                                                        'eqstart' => 4808,
                                                        'eqend' => 5029,
                                                        'start' => 5338,
                                                        'end' => 5562
                                                      },
                                                      {
                                                        'div' => '5.58',
                                                        'score' => '155',
                                                        'eqstart' => 4347,
                                                        'eqend' => 4578,
                                                        'start' => 5557,
                                                        'end' => 5789
                                                      },
                                                      {
                                                        'div' => '1.81',
                                                        'score' => '2091',
                                                        'eqstart' => 6229,
                                                        'eqend' => 8667,
                                                        'start' => 5866,
                                                        'end' => 8299
                                                      },
                                                      {
                                                        'div' => '2.27',
                                                        'score' => '31',
                                                        'eqstart' => '7735',
                                                        'eqend' => '7779',
                                                        'start' => 7422,
                                                        'end' => '7465'
                                                      },
                                                      {
                                                        'div' => '2.27',
                                                        'score' => '39',
                                                        'eqstart' => 10628,
                                                        'eqend' => 10671,
                                                        'start' => 8298,
                                                        'end' => 8341
                                                      },
                                                      {
                                                        'div' => '4.07',
                                                        'score' => '211',
                                                        'eqstart' => 8457,
                                                        'eqend' => 8726,
                                                        'start' => 8351,
                                                        'end' => 8620
                                                      },
                                                      {
                                                        'div' => '2.56',
                                                        'score' => '30',
                                                        'eqstart' => 8739,
                                                        'eqend' => 8777,
                                                        'start' => 8509,
                                                        'end' => 8547
                                                      },
                                                      {
                                                        'div' => '11.01',
                                                        'score' => '48',
                                                        'eqstart' => 10238,
                                                        'eqend' => 10347,
                                                        'start' => 8512,
                                                        'end' => 8620
                                                      },
                                                      {
                                                        'div' => '2.62',
                                                        'score' => '176',
                                                        'eqstart' => 10381,
                                                        'eqend' => 10670,
                                                        'start' => 8625,
                                                        'end' => 8891
                                                      },
                                                      {
                                                        'div' => '2.49',
                                                        'score' => '244',
                                                        'eqstart' => 8457,
                                                        'eqend' => 8777,
                                                        'start' => 8902,
                                                        'end' => 9222
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '34',
                                                        'eqstart' => 8739,
                                                        'eqend' => 8775,
                                                        'start' => 9061,
                                                        'end' => 9097
                                                      },
                                                      {
                                                        'div' => '11.40',
                                                        'score' => '51',
                                                        'eqstart' => 10238,
                                                        'eqend' => 10352,
                                                        'start' => 9064,
                                                        'end' => 9177
                                                      },
                                                      {
                                                        'div' => '10.08',
                                                        'score' => '55',
                                                        'eqstart' => 8615,
                                                        'eqend' => 8733,
                                                        'start' => 9185,
                                                        'end' => 9303
                                                      },
                                                      {
                                                        'div' => '2.24',
                                                        'score' => '4608',
                                                        'eqstart' => 10238,
                                                        'eqend' => 15815,
                                                        'start' => 9188,
                                                        'end' => 14724
                                                      },
                                                      {
                                                        'div' => '11.61',
                                                        'score' => '30',
                                                        'eqstart' => 688,
                                                        'eqend' => 796,
                                                        'start' => 10317,
                                                        'end' => 10428
                                                      },
                                                      {
                                                        'div' => '12.50',
                                                        'score' => '38',
                                                        'eqstart' => 852,
                                                        'eqend' => 964,
                                                        'start' => 10317,
                                                        'end' => 10428
                                                      },
                                                      {
                                                        'div' => '10.27',
                                                        'score' => '57',
                                                        'eqstart' => '3316',
                                                        'eqend' => '3460',
                                                        'start' => 10361,
                                                        'end' => '10506'
                                                      },
                                                      {
                                                        'div' => '3.45',
                                                        'score' => '31',
                                                        'eqstart' => 3404,
                                                        'eqend' => 3461,
                                                        'start' => 10365,
                                                        'end' => 10422
                                                      },
                                                      {
                                                        'div' => '8.45',
                                                        'score' => '41',
                                                        'eqstart' => 14217,
                                                        'eqend' => 14287,
                                                        'start' => 10365,
                                                        'end' => 10435
                                                      },
                                                      {
                                                        'div' => '10.10',
                                                        'score' => '47',
                                                        'eqstart' => 14368,
                                                        'eqend' => 14466,
                                                        'start' => 13129,
                                                        'end' => 13227
                                                      },
                                                      {
                                                        'div' => '12.64',
                                                        'score' => '73',
                                                        'eqstart' => 14456,
                                                        'eqend' => 14715,
                                                        'start' => 13133,
                                                        'end' => 13393
                                                      },
                                                      {
                                                        'div' => '11.01',
                                                        'score' => '52',
                                                        'eqstart' => '650',
                                                        'eqend' => '985',
                                                        'start' => 13134,
                                                        'end' => '13460'
                                                      },
                                                      {
                                                        'div' => '11.72',
                                                        'score' => '47',
                                                        'eqstart' => '730',
                                                        'eqend' => '980',
                                                        'start' => 13134,
                                                        'end' => '13372'
                                                      },
                                                      {
                                                        'div' => '8.74',
                                                        'score' => '43',
                                                        'eqstart' => '814',
                                                        'eqend' => '917',
                                                        'start' => 13134,
                                                        'end' => '13236'
                                                      },
                                                      {
                                                        'div' => '8.47',
                                                        'score' => '31',
                                                        'eqstart' => 3320,
                                                        'eqend' => 3378,
                                                        'start' => 13136,
                                                        'end' => 13194
                                                      },
                                                      {
                                                        'div' => '9.68',
                                                        'score' => '43',
                                                        'eqstart' => 11445,
                                                        'eqend' => 11537,
                                                        'start' => 13136,
                                                        'end' => 13228
                                                      },
                                                      {
                                                        'div' => '11.72',
                                                        'score' => '52',
                                                        'eqstart' => 14797,
                                                        'eqend' => 14941,
                                                        'start' => 13160,
                                                        'end' => 13304
                                                      },
                                                      {
                                                        'div' => '12.59',
                                                        'score' => '41',
                                                        'eqstart' => '11365',
                                                        'eqend' => '11507',
                                                        'start' => 13213,
                                                        'end' => '13355'
                                                      },
                                                      {
                                                        'div' => '10.26',
                                                        'score' => '45',
                                                        'eqstart' => '687',
                                                        'eqend' => '917',
                                                        'start' => 13243,
                                                        'end' => '13476'
                                                      },
                                                      {
                                                        'div' => '4.84',
                                                        'score' => '41',
                                                        'eqstart' => '14807',
                                                        'eqend' => '14867',
                                                        'start' => 13243,
                                                        'end' => '13304'
                                                      },
                                                      {
                                                        'div' => '8.60',
                                                        'score' => '37',
                                                        'eqstart' => 14210,
                                                        'eqend' => 14386,
                                                        'start' => 13286,
                                                        'end' => 13471
                                                      },
                                                      {
                                                        'div' => '12.06',
                                                        'score' => '48',
                                                        'eqstart' => 14325,
                                                        'eqend' => 14466,
                                                        'start' => 13327,
                                                        'end' => 13467
                                                      },
                                                      {
                                                        'div' => '11.48',
                                                        'score' => '81',
                                                        'eqstart' => 14214,
                                                        'eqend' => 14459,
                                                        'start' => 13374,
                                                        'end' => 13617
                                                      },
                                                      {
                                                        'div' => '7.79',
                                                        'score' => '42',
                                                        'eqstart' => '14802',
                                                        'eqend' => '14878',
                                                        'start' => 13406,
                                                        'end' => '13482'
                                                      },
                                                      {
                                                        'div' => '12.86',
                                                        'score' => '35',
                                                        'eqstart' => 764,
                                                        'eqend' => 985,
                                                        'start' => 13564,
                                                        'end' => 13773
                                                      },
                                                      {
                                                        'div' => '10.64',
                                                        'score' => '31',
                                                        'eqstart' => 14494,
                                                        'eqend' => 14587,
                                                        'start' => 13568,
                                                        'end' => 13661
                                                      },
                                                      {
                                                        'div' => '12.03',
                                                        'score' => '44',
                                                        'eqstart' => 11368,
                                                        'eqend' => 11499,
                                                        'start' => 13612,
                                                        'end' => 13744
                                                      },
                                                      {
                                                        'div' => '5.77',
                                                        'score' => '69',
                                                        'eqstart' => 3355,
                                                        'eqend' => 3458,
                                                        'start' => 13641,
                                                        'end' => 13744
                                                      },
                                                      {
                                                        'div' => '8.65',
                                                        'score' => '52',
                                                        'eqstart' => 11480,
                                                        'eqend' => 11583,
                                                        'start' => 13641,
                                                        'end' => 13744
                                                      },
                                                      {
                                                        'div' => '11.72',
                                                        'score' => '46',
                                                        'eqstart' => 14241,
                                                        'eqend' => 14386,
                                                        'start' => 13714,
                                                        'end' => 13858
                                                      },
                                                      {
                                                        'div' => '7.79',
                                                        'score' => '37',
                                                        'eqstart' => '14488',
                                                        'eqend' => '14565',
                                                        'start' => 13719,
                                                        'end' => '13795'
                                                      },
                                                      {
                                                        'div' => '4.92',
                                                        'score' => '40',
                                                        'eqstart' => '14325',
                                                        'eqend' => '14386',
                                                        'start' => 13724,
                                                        'end' => '13784'
                                                      },
                                                      {
                                                        'div' => '8.43',
                                                        'score' => '36',
                                                        'eqstart' => 15447,
                                                        'eqend' => 15529,
                                                        'start' => 14474,
                                                        'end' => 14556
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Arnold4',
                                        'ranges' => [
                                                      {
                                                        'div' => '2.34',
                                                        'score' => '901',
                                                        'eqstart' => 1,
                                                        'eqend' => 1071,
                                                        'start' => 1,
                                                        'end' => 1070
                                                      },
                                                      {
                                                        'div' => '2.19',
                                                        'score' => '780',
                                                        'eqstart' => 708,
                                                        'eqend' => 1622,
                                                        'start' => 623,
                                                        'end' => 1537
                                                      },
                                                      {
                                                        'div' => '2.47',
                                                        'score' => '295',
                                                        'eqstart' => 792,
                                                        'eqend' => 1155,
                                                        'start' => 623,
                                                        'end' => 986
                                                      },
                                                      {
                                                        'div' => '2.50',
                                                        'score' => '230',
                                                        'eqstart' => 876,
                                                        'eqend' => 1155,
                                                        'start' => 623,
                                                        'end' => 902
                                                      },
                                                      {
                                                        'div' => '2.04',
                                                        'score' => '168',
                                                        'eqstart' => 960,
                                                        'eqend' => 1155,
                                                        'start' => 623,
                                                        'end' => 818
                                                      },
                                                      {
                                                        'div' => '1.79',
                                                        'score' => '97',
                                                        'eqstart' => 1044,
                                                        'eqend' => 1155,
                                                        'start' => 623,
                                                        'end' => 734
                                                      },
                                                      {
                                                        'div' => '11.24',
                                                        'score' => '51',
                                                        'eqstart' => '6888',
                                                        'eqend' => '7230',
                                                        'start' => 634,
                                                        'end' => '989'
                                                      },
                                                      {
                                                        'div' => '8.86',
                                                        'score' => '40',
                                                        'eqstart' => 7309,
                                                        'eqend' => 7386,
                                                        'start' => 659,
                                                        'end' => 737
                                                      },
                                                      {
                                                        'div' => '12.73',
                                                        'score' => '46',
                                                        'eqstart' => 6997,
                                                        'eqend' => 7361,
                                                        'start' => 671,
                                                        'end' => 1047
                                                      },
                                                      {
                                                        'div' => '2.75',
                                                        'score' => '289',
                                                        'eqstart' => 624,
                                                        'eqend' => 987,
                                                        'start' => 707,
                                                        'end' => 1070
                                                      },
                                                      {
                                                        'div' => '10.91',
                                                        'score' => '53',
                                                        'eqstart' => 6888,
                                                        'eqend' => 7204,
                                                        'start' => 718,
                                                        'end' => 1047
                                                      },
                                                      {
                                                        'div' => '3.21',
                                                        'score' => '215',
                                                        'eqstart' => 624,
                                                        'eqend' => 903,
                                                        'start' => 791,
                                                        'end' => 1070
                                                      },
                                                      {
                                                        'div' => '10.16',
                                                        'score' => '42',
                                                        'eqstart' => 6888,
                                                        'eqend' => 7121,
                                                        'start' => 802,
                                                        'end' => 1047
                                                      },
                                                      {
                                                        'div' => '3.57',
                                                        'score' => '147',
                                                        'eqstart' => 624,
                                                        'eqend' => 819,
                                                        'start' => 875,
                                                        'end' => 1070
                                                      },
                                                      {
                                                        'div' => '9.62',
                                                        'score' => '39',
                                                        'eqstart' => '6888',
                                                        'eqend' => '6990',
                                                        'start' => 886,
                                                        'end' => '989'
                                                      },
                                                      {
                                                        'div' => '3.57',
                                                        'score' => '85',
                                                        'eqstart' => 624,
                                                        'eqend' => 735,
                                                        'start' => 959,
                                                        'end' => 1070
                                                      },
                                                      {
                                                        'div' => '1.10',
                                                        'score' => '190',
                                                        'eqstart' => 1713,
                                                        'eqend' => 1976,
                                                        'start' => 1514,
                                                        'end' => 1786
                                                      },
                                                      {
                                                        'div' => '1.37',
                                                        'score' => '52',
                                                        'eqstart' => 1757,
                                                        'eqend' => 1830,
                                                        'start' => 1514,
                                                        'end' => 1586
                                                      },
                                                      {
                                                        'div' => '1.64',
                                                        'score' => '44',
                                                        'eqstart' => 2062,
                                                        'eqend' => 2123,
                                                        'start' => 1524,
                                                        'end' => 1584
                                                      },
                                                      {
                                                        'div' => '1.75',
                                                        'score' => '39',
                                                        'eqstart' => 1921,
                                                        'eqend' => 1978,
                                                        'start' => 1530,
                                                        'end' => 1586
                                                      },
                                                      {
                                                        'div' => '1.61',
                                                        'score' => '50',
                                                        'eqstart' => 2062,
                                                        'eqend' => 2123,
                                                        'start' => 1567,
                                                        'end' => 1628
                                                      },
                                                      {
                                                        'div' => '2.21',
                                                        'score' => '3620',
                                                        'eqstart' => 1921,
                                                        'eqend' => 6124,
                                                        'start' => 1573,
                                                        'end' => 5789
                                                      },
                                                      {
                                                        'div' => '6.99',
                                                        'score' => '120',
                                                        'eqstart' => 1599,
                                                        'eqend' => 1784,
                                                        'start' => 1601,
                                                        'end' => 1786
                                                      },
                                                      {
                                                        'div' => '2.70',
                                                        'score' => '54',
                                                        'eqstart' => 1755,
                                                        'eqend' => 1828,
                                                        'start' => 1713,
                                                        'end' => 1786
                                                      },
                                                      {
                                                        'div' => '10.45',
                                                        'score' => '89',
                                                        'eqstart' => 4407,
                                                        'eqend' => 4606,
                                                        'start' => 3843,
                                                        'end' => 4043
                                                      },
                                                      {
                                                        'div' => '9.95',
                                                        'score' => '84',
                                                        'eqstart' => 4179,
                                                        'eqend' => 4379,
                                                        'start' => 4071,
                                                        'end' => 4271
                                                      },
                                                      {
                                                        'div' => '6.78',
                                                        'score' => '33',
                                                        'eqstart' => 6890,
                                                        'eqend' => 6948,
                                                        'start' => 4231,
                                                        'end' => 4289
                                                      },
                                                      {
                                                        'div' => '6.73',
                                                        'score' => '61',
                                                        'eqstart' => 7395,
                                                        'eqend' => 7498,
                                                        'start' => 4266,
                                                        'end' => 4369
                                                      },
                                                      {
                                                        'div' => '4.08',
                                                        'score' => '391',
                                                        'eqstart' => 5892,
                                                        'eqend' => 6429,
                                                        'start' => 5330,
                                                        'end' => 5868
                                                      },
                                                      {
                                                        'div' => '10.30',
                                                        'score' => '104',
                                                        'eqstart' => 6119,
                                                        'eqend' => 6350,
                                                        'start' => 5330,
                                                        'end' => 5562
                                                      },
                                                      {
                                                        'div' => '6.87',
                                                        'score' => '148',
                                                        'eqstart' => 5665,
                                                        'eqend' => 5897,
                                                        'start' => 5557,
                                                        'end' => 5789
                                                      },
                                                      {
                                                        'div' => '12.59',
                                                        'score' => '39',
                                                        'eqstart' => 6967,
                                                        'eqend' => 7109,
                                                        'start' => 10285,
                                                        'end' => 10427
                                                      },
                                                      {
                                                        'div' => '12.50',
                                                        'score' => '38',
                                                        'eqstart' => 841,
                                                        'eqend' => 953,
                                                        'start' => 10317,
                                                        'end' => 10428
                                                      },
                                                      {
                                                        'div' => '10.82',
                                                        'score' => '54',
                                                        'eqstart' => '4562',
                                                        'eqend' => '4755',
                                                        'start' => 10361,
                                                        'end' => '10554'
                                                      },
                                                      {
                                                        'div' => '3.45',
                                                        'score' => '31',
                                                        'eqstart' => 4651,
                                                        'eqend' => 4708,
                                                        'start' => 10365,
                                                        'end' => 10422
                                                      },
                                                      {
                                                        'div' => '8.70',
                                                        'score' => '39',
                                                        'eqstart' => 6890,
                                                        'eqend' => 6958,
                                                        'start' => 10365,
                                                        'end' => 10433
                                                      },
                                                      {
                                                        'div' => '9.52',
                                                        'score' => '36',
                                                        'eqstart' => 7395,
                                                        'eqend' => 7498,
                                                        'start' => 10400,
                                                        'end' => 10504
                                                      },
                                                      {
                                                        'div' => '2.52',
                                                        'score' => '1333',
                                                        'eqstart' => 6686,
                                                        'eqend' => 8454,
                                                        'start' => 12932,
                                                        'end' => 14719
                                                      },
                                                      {
                                                        'div' => '8.33',
                                                        'score' => '61',
                                                        'eqstart' => 7040,
                                                        'eqend' => 7147,
                                                        'start' => 13129,
                                                        'end' => 13236
                                                      },
                                                      {
                                                        'div' => '12.64',
                                                        'score' => '82',
                                                        'eqstart' => '7128',
                                                        'eqend' => '7386',
                                                        'start' => 13133,
                                                        'end' => '13393'
                                                      },
                                                      {
                                                        'div' => '12.50',
                                                        'score' => '62',
                                                        'eqstart' => '635',
                                                        'eqend' => '1155',
                                                        'start' => 13134,
                                                        'end' => 13629
                                                      },
                                                      {
                                                        'div' => '11.66',
                                                        'score' => '57',
                                                        'eqstart' => '719',
                                                        'eqend' => '1074',
                                                        'start' => 13134,
                                                        'end' => 13476
                                                      },
                                                      {
                                                        'div' => '11.30',
                                                        'score' => '50',
                                                        'eqstart' => 887,
                                                        'eqend' => 1137,
                                                        'start' => 13134,
                                                        'end' => 13372
                                                      },
                                                      {
                                                        'div' => '8.47',
                                                        'score' => '31',
                                                        'eqstart' => 4566,
                                                        'eqend' => 4624,
                                                        'start' => 13136,
                                                        'end' => 13194
                                                      },
                                                      {
                                                        'div' => '11.45',
                                                        'score' => '59',
                                                        'eqstart' => '811',
                                                        'eqend' => '1154',
                                                        'start' => 13141,
                                                        'end' => '13472'
                                                      },
                                                      {
                                                        'div' => '11.42',
                                                        'score' => '60',
                                                        'eqstart' => 6997,
                                                        'eqend' => 7225,
                                                        'start' => 13170,
                                                        'end' => 13388
                                                      },
                                                      {
                                                        'div' => '7.53',
                                                        'score' => '50',
                                                        'eqstart' => 6883,
                                                        'eqend' => 7058,
                                                        'start' => 13286,
                                                        'end' => 13471
                                                      },
                                                      {
                                                        'div' => '11.20',
                                                        'score' => '98',
                                                        'eqstart' => 6887,
                                                        'eqend' => 7147,
                                                        'start' => 13374,
                                                        'end' => 13632
                                                      },
                                                      {
                                                        'div' => '10.75',
                                                        'score' => '30',
                                                        'eqstart' => 7322,
                                                        'eqend' => 7415,
                                                        'start' => 13412,
                                                        'end' => 13504
                                                      },
                                                      {
                                                        'div' => '12.16',
                                                        'score' => '30',
                                                        'eqstart' => 669,
                                                        'eqend' => 902,
                                                        'start' => 13564,
                                                        'end' => 13785
                                                      },
                                                      {
                                                        'div' => '11.70',
                                                        'score' => '30',
                                                        'eqstart' => 7166,
                                                        'eqend' => 7258,
                                                        'start' => 13568,
                                                        'end' => 13661
                                                      },
                                                      {
                                                        'div' => '5.77',
                                                        'score' => '64',
                                                        'eqstart' => 4601,
                                                        'eqend' => 4705,
                                                        'start' => 13641,
                                                        'end' => 13744
                                                      },
                                                      {
                                                        'div' => '11.72',
                                                        'score' => '53',
                                                        'eqstart' => 6914,
                                                        'eqend' => 7058,
                                                        'start' => 13714,
                                                        'end' => 13858
                                                      },
                                                      {
                                                        'div' => '11.71',
                                                        'score' => '42',
                                                        'eqstart' => 7160,
                                                        'eqend' => 7269,
                                                        'start' => 13719,
                                                        'end' => 13829
                                                      },
                                                      {
                                                        'div' => '4.92',
                                                        'score' => '40',
                                                        'eqstart' => '6997',
                                                        'eqend' => '7058',
                                                        'start' => 13724,
                                                        'end' => '13784'
                                                      },
                                                      {
                                                        'div' => '12.79',
                                                        'score' => '40',
                                                        'eqstart' => 8170,
                                                        'eqend' => 8255,
                                                        'start' => 14370,
                                                        'end' => 14455
                                                      },
                                                      {
                                                        'div' => '8.43',
                                                        'score' => '32',
                                                        'eqstart' => 8099,
                                                        'eqend' => 8181,
                                                        'start' => 14474,
                                                        'end' => 14556
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'ArnoldY1',
                                        'ranges' => [
                                                      {
                                                        'div' => '9.47',
                                                        'score' => '63',
                                                        'eqstart' => 990,
                                                        'eqend' => 1405,
                                                        'start' => 615,
                                                        'end' => 1047
                                                      },
                                                      {
                                                        'div' => '8.68',
                                                        'score' => '54',
                                                        'eqstart' => 1149,
                                                        'eqend' => 1405,
                                                        'start' => 615,
                                                        'end' => 879
                                                      },
                                                      {
                                                        'div' => '9.81',
                                                        'score' => '54',
                                                        'eqstart' => '893',
                                                        'eqend' => '1249',
                                                        'start' => 671,
                                                        'end' => 1047
                                                      },
                                                      {
                                                        'div' => '9.82',
                                                        'score' => '70',
                                                        'eqstart' => 966,
                                                        'eqend' => 1331,
                                                        'start' => 671,
                                                        'end' => 1057
                                                      },
                                                      {
                                                        'div' => '9.23',
                                                        'score' => '53',
                                                        'eqstart' => 1281,
                                                        'eqend' => 1410,
                                                        'start' => 671,
                                                        'end' => 800
                                                      },
                                                      {
                                                        'div' => '9.93',
                                                        'score' => '65',
                                                        'eqstart' => 1126,
                                                        'eqend' => 1405,
                                                        'start' => 672,
                                                        'end' => 963
                                                      },
                                                      {
                                                        'div' => '9.90',
                                                        'score' => '39',
                                                        'eqstart' => 893,
                                                        'eqend' => 1175,
                                                        'start' => 755,
                                                        'end' => 1057
                                                      },
                                                      {
                                                        'div' => '10.37',
                                                        'score' => '40',
                                                        'eqstart' => 966,
                                                        'eqend' => 1101,
                                                        'start' => 923,
                                                        'end' => 1057
                                                      },
                                                      {
                                                        'div' => '12.41',
                                                        'score' => '40',
                                                        'eqstart' => 1255,
                                                        'eqend' => 1399,
                                                        'start' => 10289,
                                                        'end' => 10433
                                                      },
                                                      {
                                                        'div' => '11.11',
                                                        'score' => '36',
                                                        'eqstart' => 967,
                                                        'eqend' => 1075,
                                                        'start' => 10317,
                                                        'end' => 10424
                                                      },
                                                      {
                                                        'div' => '7.87',
                                                        'score' => '139',
                                                        'eqstart' => 1009,
                                                        'eqend' => 1342,
                                                        'start' => 13129,
                                                        'end' => 13471
                                                      },
                                                      {
                                                        'div' => '7.25',
                                                        'score' => '148',
                                                        'eqstart' => 1168,
                                                        'eqend' => 1428,
                                                        'start' => 13129,
                                                        'end' => 13390
                                                      },
                                                      {
                                                        'div' => '4.85',
                                                        'score' => '69',
                                                        'eqstart' => 1324,
                                                        'eqend' => 1426,
                                                        'start' => 13129,
                                                        'end' => 13231
                                                      },
                                                      {
                                                        'div' => '8.28',
                                                        'score' => '122',
                                                        'eqstart' => 893,
                                                        'eqend' => 1186,
                                                        'start' => 13170,
                                                        'end' => 13471
                                                      },
                                                      {
                                                        'div' => '10.70',
                                                        'score' => '107',
                                                        'eqstart' => 966,
                                                        'eqend' => 1426,
                                                        'start' => 13170,
                                                        'end' => 13627
                                                      },
                                                      {
                                                        'div' => '8.03',
                                                        'score' => '53',
                                                        'eqstart' => 1281,
                                                        'eqend' => 1428,
                                                        'start' => 13170,
                                                        'end' => 13306
                                                      },
                                                      {
                                                        'div' => '9.63',
                                                        'score' => '74',
                                                        'eqstart' => 1126,
                                                        'eqend' => 1426,
                                                        'start' => 13171,
                                                        'end' => 13471
                                                      },
                                                      {
                                                        'div' => '12.36',
                                                        'score' => '112',
                                                        'eqstart' => 893,
                                                        'eqend' => 1426,
                                                        'start' => 13243,
                                                        'end' => 13784
                                                      },
                                                      {
                                                        'div' => '3.33',
                                                        'score' => '40',
                                                        'eqstart' => 967,
                                                        'eqend' => 1027,
                                                        'start' => 13412,
                                                        'end' => 13471
                                                      },
                                                      {
                                                        'div' => '6.35',
                                                        'score' => '31',
                                                        'eqstart' => '788',
                                                        'eqend' => '848',
                                                        'start' => 13483,
                                                        'end' => '13545'
                                                      },
                                                      {
                                                        'div' => '9.09',
                                                        'score' => '37',
                                                        'eqstart' => 966,
                                                        'eqend' => 1032,
                                                        'start' => 13567,
                                                        'end' => 13632
                                                      },
                                                      {
                                                        'div' => '9.09',
                                                        'score' => '37',
                                                        'eqstart' => 1281,
                                                        'eqend' => 1347,
                                                        'start' => 13567,
                                                        'end' => 13632
                                                      },
                                                      {
                                                        'div' => '11.85',
                                                        'score' => '38',
                                                        'eqstart' => '893',
                                                        'eqend' => '1027',
                                                        'start' => 13724,
                                                        'end' => 13858
                                                      },
                                                      {
                                                        'div' => '4.92',
                                                        'score' => '38',
                                                        'eqstart' => 966,
                                                        'eqend' => '1027',
                                                        'start' => 13724,
                                                        'end' => 13784
                                                      },
                                                      {
                                                        'div' => '4.92',
                                                        'score' => '38',
                                                        'eqstart' => 1281,
                                                        'eqend' => 1342,
                                                        'start' => 13724,
                                                        'end' => 13784
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Arnold2',
                                        'ranges' => [
                                                      {
                                                        'div' => '4.82',
                                                        'score' => '2803',
                                                        'eqstart' => 1,
                                                        'eqend' => 4447,
                                                        'start' => 1,
                                                        'end' => 4418
                                                      },
                                                      {
                                                        'div' => '2.50',
                                                        'score' => '230',
                                                        'eqstart' => 708,
                                                        'eqend' => 987,
                                                        'start' => 623,
                                                        'end' => 902
                                                      },
                                                      {
                                                        'div' => '2.55',
                                                        'score' => '161',
                                                        'eqstart' => 792,
                                                        'eqend' => 987,
                                                        'start' => 623,
                                                        'end' => 818
                                                      },
                                                      {
                                                        'div' => '2.68',
                                                        'score' => '90',
                                                        'eqstart' => 876,
                                                        'eqend' => 987,
                                                        'start' => 623,
                                                        'end' => 734
                                                      },
                                                      {
                                                        'div' => '11.24',
                                                        'score' => '51',
                                                        'eqstart' => '13875',
                                                        'eqend' => '14217',
                                                        'start' => 634,
                                                        'end' => '989'
                                                      },
                                                      {
                                                        'div' => '12.32',
                                                        'score' => '30',
                                                        'eqstart' => 11111,
                                                        'eqend' => 11247,
                                                        'start' => 636,
                                                        'end' => 773
                                                      },
                                                      {
                                                        'div' => '10.13',
                                                        'score' => '37',
                                                        'eqstart' => 14296,
                                                        'eqend' => 14373,
                                                        'start' => 659,
                                                        'end' => 737
                                                      },
                                                      {
                                                        'div' => '11.49',
                                                        'score' => '51',
                                                        'eqstart' => 13984,
                                                        'eqend' => 14217,
                                                        'start' => 671,
                                                        'end' => 905
                                                      },
                                                      {
                                                        'div' => '12.71',
                                                        'score' => '43',
                                                        'eqstart' => 11063,
                                                        'eqend' => 11179,
                                                        'start' => 672,
                                                        'end' => 789
                                                      },
                                                      {
                                                        'div' => '6.06',
                                                        'score' => '32',
                                                        'eqstart' => 14153,
                                                        'eqend' => 14217,
                                                        'start' => 672,
                                                        'end' => 737
                                                      },
                                                      {
                                                        'div' => '1.93',
                                                        'score' => '728',
                                                        'eqstart' => 624,
                                                        'eqend' => 1454,
                                                        'start' => 707,
                                                        'end' => 1537
                                                      },
                                                      {
                                                        'div' => '10.61',
                                                        'score' => '54',
                                                        'eqstart' => 13875,
                                                        'eqend' => 14191,
                                                        'start' => 718,
                                                        'end' => 1047
                                                      },
                                                      {
                                                        'div' => '10.00',
                                                        'score' => '35',
                                                        'eqstart' => '14305',
                                                        'eqend' => '14373',
                                                        'start' => 752,
                                                        'end' => '821'
                                                      },
                                                      {
                                                        'div' => '2.86',
                                                        'score' => '222',
                                                        'eqstart' => 624,
                                                        'eqend' => 903,
                                                        'start' => 791,
                                                        'end' => 1070
                                                      },
                                                      {
                                                        'div' => '10.16',
                                                        'score' => '43',
                                                        'eqstart' => 13875,
                                                        'eqend' => 14108,
                                                        'start' => 802,
                                                        'end' => 1047
                                                      },
                                                      {
                                                        'div' => '12.71',
                                                        'score' => '38',
                                                        'eqstart' => 11063,
                                                        'eqend' => 11179,
                                                        'start' => 840,
                                                        'end' => 957
                                                      },
                                                      {
                                                        'div' => '3.57',
                                                        'score' => '149',
                                                        'eqstart' => 624,
                                                        'eqend' => 819,
                                                        'start' => 875,
                                                        'end' => 1070
                                                      },
                                                      {
                                                        'div' => '9.52',
                                                        'score' => '39',
                                                        'eqstart' => '13875',
                                                        'eqend' => '13978',
                                                        'start' => 886,
                                                        'end' => '990'
                                                      },
                                                      {
                                                        'div' => '12.71',
                                                        'score' => '38',
                                                        'eqstart' => 11063,
                                                        'eqend' => 11179,
                                                        'start' => 924,
                                                        'end' => 1041
                                                      },
                                                      {
                                                        'div' => '4.46',
                                                        'score' => '82',
                                                        'eqstart' => 624,
                                                        'eqend' => 735,
                                                        'start' => 959,
                                                        'end' => 1070
                                                      },
                                                      {
                                                        'div' => '4.55',
                                                        'score' => '31',
                                                        'eqstart' => 14305,
                                                        'eqend' => 14348,
                                                        'start' => 1004,
                                                        'end' => 1047
                                                      },
                                                      {
                                                        'div' => '1.37',
                                                        'score' => '52',
                                                        'eqstart' => 1589,
                                                        'eqend' => 1662,
                                                        'start' => 1514,
                                                        'end' => 1586
                                                      },
                                                      {
                                                        'div' => '5.63',
                                                        'score' => '34',
                                                        'eqstart' => 1747,
                                                        'eqend' => 1815,
                                                        'start' => 1514,
                                                        'end' => 1584
                                                      },
                                                      {
                                                        'div' => '4.11',
                                                        'score' => '39',
                                                        'eqstart' => 1746,
                                                        'eqend' => 1815,
                                                        'start' => 1556,
                                                        'end' => 1628
                                                      },
                                                      {
                                                        'div' => '7.53',
                                                        'score' => '115',
                                                        'eqstart' => 1431,
                                                        'eqend' => 1616,
                                                        'start' => 1601,
                                                        'end' => 1786
                                                      },
                                                      {
                                                        'div' => '9.95',
                                                        'score' => '87',
                                                        'eqstart' => 4100,
                                                        'eqend' => 4300,
                                                        'start' => 3843,
                                                        'end' => 4043
                                                      },
                                                      {
                                                        'div' => '9.45',
                                                        'score' => '85',
                                                        'eqstart' => 3872,
                                                        'eqend' => 4072,
                                                        'start' => 4071,
                                                        'end' => 4271
                                                      },
                                                      {
                                                        'div' => '11.58',
                                                        'score' => '60',
                                                        'eqstart' => 11063,
                                                        'eqend' => 11251,
                                                        'start' => 4182,
                                                        'end' => 4371
                                                      },
                                                      {
                                                        'div' => '6.78',
                                                        'score' => '33',
                                                        'eqstart' => 13877,
                                                        'eqend' => 13935,
                                                        'start' => 4231,
                                                        'end' => 4289
                                                      },
                                                      {
                                                        'div' => '6.73',
                                                        'score' => '63',
                                                        'eqstart' => 14382,
                                                        'eqend' => 14485,
                                                        'start' => 4266,
                                                        'end' => 4369
                                                      },
                                                      {
                                                        'div' => '2.61',
                                                        'score' => '1077',
                                                        'eqstart' => 4441,
                                                        'eqend' => 5742,
                                                        'start' => 4485,
                                                        'end' => 5789
                                                      },
                                                      {
                                                        'div' => '5.75',
                                                        'score' => '357',
                                                        'eqstart' => 5510,
                                                        'eqend' => 6048,
                                                        'start' => 5330,
                                                        'end' => 5868
                                                      },
                                                      {
                                                        'div' => '11.11',
                                                        'score' => '91',
                                                        'eqstart' => 5745,
                                                        'eqend' => 5968,
                                                        'start' => 5338,
                                                        'end' => 5562
                                                      },
                                                      {
                                                        'div' => '6.87',
                                                        'score' => '148',
                                                        'eqstart' => 5283,
                                                        'eqend' => 5515,
                                                        'start' => 5557,
                                                        'end' => 5789
                                                      },
                                                      {
                                                        'div' => '2.17',
                                                        'score' => '2370',
                                                        'eqstart' => 7170,
                                                        'eqend' => 9933,
                                                        'start' => 5866,
                                                        'end' => 8627
                                                      },
                                                      {
                                                        'div' => '3.79',
                                                        'score' => '150',
                                                        'eqstart' => 9656,
                                                        'eqend' => 9867,
                                                        'start' => 8089,
                                                        'end' => 8299
                                                      },
                                                      {
                                                        'div' => '2.27',
                                                        'score' => '39',
                                                        'eqstart' => 10305,
                                                        'eqend' => 10348,
                                                        'start' => 8298,
                                                        'end' => 8341
                                                      },
                                                      {
                                                        'div' => '4.31',
                                                        'score' => '158',
                                                        'eqstart' => 9394,
                                                        'eqend' => 9602,
                                                        'start' => 8351,
                                                        'end' => 8559
                                                      },
                                                      {
                                                        'div' => '5.74',
                                                        'score' => '207',
                                                        'eqstart' => 9939,
                                                        'eqend' => 10347,
                                                        'start' => 8509,
                                                        'end' => 8891
                                                      },
                                                      {
                                                        'div' => '2.13',
                                                        'score' => '4951',
                                                        'eqstart' => 9603,
                                                        'eqend' => 15490,
                                                        'start' => 8849,
                                                        'end' => 14724
                                                      },
                                                      {
                                                        'div' => '3.33',
                                                        'score' => '151',
                                                        'eqstart' => 9394,
                                                        'eqend' => 9602,
                                                        'start' => 8902,
                                                        'end' => 9111
                                                      },
                                                      {
                                                        'div' => '10.08',
                                                        'score' => '56',
                                                        'eqstart' => 9939,
                                                        'eqend' => 10058,
                                                        'start' => 9061,
                                                        'end' => 9179
                                                      },
                                                      {
                                                        'div' => '12.95',
                                                        'score' => '50',
                                                        'eqstart' => '4256',
                                                        'eqend' => '4447',
                                                        'start' => 10361,
                                                        'end' => '10553'
                                                      },
                                                      {
                                                        'div' => '8.70',
                                                        'score' => '39',
                                                        'eqstart' => 13877,
                                                        'eqend' => 13945,
                                                        'start' => 10365,
                                                        'end' => 10433
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '30',
                                                        'eqstart' => 4368,
                                                        'eqend' => 4401,
                                                        'start' => 10389,
                                                        'end' => 10422
                                                      },
                                                      {
                                                        'div' => '9.89',
                                                        'score' => '35',
                                                        'eqstart' => 14382,
                                                        'eqend' => 14473,
                                                        'start' => 10400,
                                                        'end' => 10490
                                                      },
                                                      {
                                                        'div' => '12.30',
                                                        'score' => '47',
                                                        'eqstart' => '635',
                                                        'eqend' => '964',
                                                        'start' => 13134,
                                                        'end' => '13450'
                                                      },
                                                      {
                                                        'div' => '12.39',
                                                        'score' => '37',
                                                        'eqstart' => '719',
                                                        'eqend' => '964',
                                                        'start' => 13134,
                                                        'end' => '13367'
                                                      },
                                                      {
                                                        'div' => '9.68',
                                                        'score' => '43',
                                                        'eqstart' => 11111,
                                                        'eqend' => 11203,
                                                        'start' => 13136,
                                                        'end' => 13228
                                                      },
                                                      {
                                                        'div' => '10.42',
                                                        'score' => '36',
                                                        'eqstart' => '811',
                                                        'eqend' => '906',
                                                        'start' => 13141,
                                                        'end' => '13236'
                                                      },
                                                      {
                                                        'div' => '12.41',
                                                        'score' => '47',
                                                        'eqstart' => 14455,
                                                        'eqend' => 14599,
                                                        'start' => 13160,
                                                        'end' => 13304
                                                      },
                                                      {
                                                        'div' => '12.33',
                                                        'score' => '52',
                                                        'eqstart' => 13984,
                                                        'eqend' => 14212,
                                                        'start' => 13170,
                                                        'end' => 13388
                                                      },
                                                      {
                                                        'div' => '11.97',
                                                        'score' => '47',
                                                        'eqstart' => '672',
                                                        'eqend' => '906',
                                                        'start' => 13243,
                                                        'end' => '13476'
                                                      },
                                                      {
                                                        'div' => '11.07',
                                                        'score' => '93',
                                                        'eqstart' => 13874,
                                                        'eqend' => 14118,
                                                        'start' => 13374,
                                                        'end' => 13617
                                                      },
                                                      {
                                                        'div' => '9.09',
                                                        'score' => '37',
                                                        'eqstart' => 14460,
                                                        'eqend' => 14536,
                                                        'start' => 13406,
                                                        'end' => 13482
                                                      },
                                                      {
                                                        'div' => '12.03',
                                                        'score' => '44',
                                                        'eqstart' => 11034,
                                                        'eqend' => 11165,
                                                        'start' => 13612,
                                                        'end' => 13744
                                                      },
                                                      {
                                                        'div' => '8.65',
                                                        'score' => '58',
                                                        'eqstart' => 4295,
                                                        'eqend' => 4398,
                                                        'start' => 13641,
                                                        'end' => 13744
                                                      },
                                                      {
                                                        'div' => '9.62',
                                                        'score' => '49',
                                                        'eqstart' => 11146,
                                                        'eqend' => 11249,
                                                        'start' => 13641,
                                                        'end' => 13744
                                                      },
                                                      {
                                                        'div' => '12.41',
                                                        'score' => '50',
                                                        'eqstart' => 13901,
                                                        'eqend' => 14045,
                                                        'start' => 13714,
                                                        'end' => 13858
                                                      },
                                                      {
                                                        'div' => '4.92',
                                                        'score' => '40',
                                                        'eqstart' => 13984,
                                                        'eqend' => 14045,
                                                        'start' => 13724,
                                                        'end' => 13784
                                                      },
                                                      {
                                                        'div' => '11.11',
                                                        'score' => '63',
                                                        'eqstart' => 15188,
                                                        'eqend' => 15304,
                                                        'start' => 14370,
                                                        'end' => 14486
                                                      }
                                                    ]
                                      }
                                    ],
                         'type' => 'DNA'
                       },
          'enspm-4n_mlp' => {
                              'conlength' => '816',
                              'subtype' => 'CMC-EnSpm',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'ras1_mt' => {
                         'conlength' => '408',
                         'subtype' => undef,
                         'equiv' => [],
                         'type' => 'DNA'
                       },
          'dna9-4_fv' => {
                           'conlength' => '409',
                           'subtype' => undef,
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'pif_harbinger-2_emihux' => {
                                        'conlength' => '1293',
                                        'subtype' => 'PIF-ISL2EU',
                                        'equiv' => [],
                                        'type' => 'DNA'
                                      },
          'mer105' => {
                        'conlength' => '203',
                        'subtype' => 'hAT-Charlie',
                        'equiv' => [],
                        'type' => 'DNA'
                      },
          'sola1-1_acas' => {
                              'conlength' => '2944',
                              'subtype' => 'Sola-1',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'dna8-4_cq' => {
                           'conlength' => '4916',
                           'subtype' => undef,
                           'equiv' => [
                                        {
                                          'name' => 'DNA8-11_CQ',
                                          'ranges' => [
                                                        {
                                                          'div' => '4.08',
                                                          'score' => '41',
                                                          'eqstart' => 4,
                                                          'eqend' => 52,
                                                          'start' => 1622,
                                                          'end' => 1670
                                                        }
                                                      ]
                                        },
                                        {
                                          'name' => 'DNA-TA-14_CQ',
                                          'ranges' => [
                                                        {
                                                          'compl' => 1,
                                                          'div' => '8.57',
                                                          'score' => '34',
                                                          'eqstart' => 1,
                                                          'eqend' => 69,
                                                          'start' => 1458,
                                                          'end' => 1527
                                                        }
                                                      ]
                                        }
                                      ],
                           'type' => 'DNA'
                         },
          'kolobok-n7_cgi' => {
                                'conlength' => '470',
                                'subtype' => 'Kolobok',
                                'equiv' => [],
                                'type' => 'DNA'
                              },
          'tigger1c_crp' => {
                              'conlength' => '497',
                              'subtype' => 'TcMar-Tigger',
                              'equiv' => [
                                           {
                                             'name' => 'Tigger1B_Crp',
                                             'ranges' => [
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '178',
                                                             'eqstart' => '1',
                                                             'eqend' => '183',
                                                             'start' => '1',
                                                             'end' => '183'
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '248',
                                                             'eqstart' => '581',
                                                             'eqend' => '835',
                                                             'start' => '243',
                                                             'end' => '497'
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'Tigger1_Crp',
                                             'ranges' => [
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '178',
                                                             'eqstart' => '1',
                                                             'eqend' => '183',
                                                             'start' => '1',
                                                             'end' => '183'
                                                           },
                                                           {
                                                             'div' => '1.26',
                                                             'score' => '301',
                                                             'eqstart' => '1117',
                                                             'eqend' => '1433',
                                                             'start' => '181',
                                                             'end' => '497'
                                                           }
                                                         ]
                                           }
                                         ],
                              'type' => 'DNA'
                            },
          'dna-5-16_nv' => {
                             'conlength' => '173',
                             'subtype' => undef,
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'mudr-1_ptc' => {
                            'conlength' => '4295',
                            'subtype' => 'MULE-MuDR',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'mer96' => {
                       'conlength' => '175',
                       'subtype' => 'hAT-Tip100',
                       'equiv' => [
                                    {
                                      'name' => 'MER96B',
                                      'ranges' => [
                                                    {
                                                      'compl' => 1,
                                                      'div' => '5.17',
                                                      'score' => '32',
                                                      'eqstart' => 356,
                                                      'eqend' => 417,
                                                      'start' => 1,
                                                      'end' => 58
                                                    },
                                                    {
                                                      'div' => '3.45',
                                                      'score' => '35',
                                                      'eqstart' => 1,
                                                      'eqend' => 62,
                                                      'start' => 1,
                                                      'end' => 58
                                                    },
                                                    {
                                                      'compl' => 1,
                                                      'div' => '5.17',
                                                      'score' => '32',
                                                      'eqstart' => 1,
                                                      'eqend' => 62,
                                                      'start' => 118,
                                                      'end' => 175
                                                    }
                                                  ]
                                    }
                                  ],
                       'type' => 'DNA'
                     },
          'harbinger-n276_ami' => {
                                    'conlength' => '110',
                                    'subtype' => 'PIF-Harbinger',
                                    'equiv' => [],
                                    'type' => 'DNA'
                                  },
          'hat-n4_gav' => {
                            'conlength' => '613',
                            'subtype' => 'hAT',
                            'equiv' => [
                                         {
                                           'name' => 'hAT-N678_AMi',
                                           'ranges' => [
                                                         {
                                                           'div' => '11.59',
                                                           'score' => '156',
                                                           'eqstart' => '1',
                                                           'eqend' => '357',
                                                           'start' => '1',
                                                           'end' => '345'
                                                         },
                                                         {
                                                           'div' => '10.85',
                                                           'score' => '36',
                                                           'eqstart' => '1821',
                                                           'eqend' => '1959',
                                                           'start' => '1043',
                                                           'end' => '1171'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-224_Ami',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '2.00',
                                                           'score' => '34',
                                                           'eqstart' => '122',
                                                           'eqend' => '171',
                                                           'start' => '1018',
                                                           'end' => '1067'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N4_AMi',
                                           'ranges' => [
                                                         {
                                                           'div' => '1.82',
                                                           'score' => '39',
                                                           'eqstart' => '1046',
                                                           'eqend' => '1100',
                                                           'start' => '1013',
                                                           'end' => '1067'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N2_Gav',
                                           'ranges' => [
                                                         {
                                                           'div' => '1.82',
                                                           'score' => '39',
                                                           'eqstart' => '1138',
                                                           'eqend' => '1192',
                                                           'start' => '1013',
                                                           'end' => '1067'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-191_Ami',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '8.63',
                                                           'score' => '136',
                                                           'eqstart' => '143',
                                                           'eqend' => '468',
                                                           'start' => '795',
                                                           'end' => '1107'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '10.62',
                                                           'score' => '37',
                                                           'eqstart' => '29',
                                                           'eqend' => '195',
                                                           'start' => '1012',
                                                           'end' => '1171'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N21_Crp',
                                           'ranges' => [
                                                         {
                                                           'div' => '9.38',
                                                           'score' => '64',
                                                           'eqstart' => '1',
                                                           'eqend' => '157',
                                                           'start' => '1',
                                                           'end' => '160'
                                                         },
                                                         {
                                                           'div' => '6.12',
                                                           'score' => '52',
                                                           'eqstart' => '1050',
                                                           'eqend' => '1211',
                                                           'start' => '950',
                                                           'end' => '1096'
                                                         },
                                                         {
                                                           'div' => '5.26',
                                                           'score' => '54',
                                                           'eqstart' => '1424',
                                                           'eqend' => '1517',
                                                           'start' => '1123',
                                                           'end' => '1217'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N11B_AMi',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '11.25',
                                                           'score' => '70',
                                                           'eqstart' => '1380',
                                                           'eqend' => '1540',
                                                           'start' => '1',
                                                           'end' => '160'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '6.88',
                                                           'score' => '96',
                                                           'eqstart' => '313',
                                                           'eqend' => '472',
                                                           'start' => '950',
                                                           'end' => '1109'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N21B_Crp',
                                           'ranges' => [
                                                         {
                                                           'div' => '9.09',
                                                           'score' => '140',
                                                           'eqstart' => '1',
                                                           'eqend' => '232',
                                                           'start' => '1',
                                                           'end' => '231'
                                                         },
                                                         {
                                                           'div' => '5.94',
                                                           'score' => '107',
                                                           'eqstart' => '413',
                                                           'eqend' => '629',
                                                           'start' => '888',
                                                           'end' => '1106'
                                                         },
                                                         {
                                                           'div' => '7.89',
                                                           'score' => '70',
                                                           'eqstart' => '679',
                                                           'eqend' => '791',
                                                           'start' => '1104',
                                                           'end' => '1217'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N4793_Gav',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '7.27',
                                                           'score' => '34',
                                                           'eqstart' => '93',
                                                           'eqend' => '147',
                                                           'start' => '527',
                                                           'end' => '581'
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'dna-x-7_dr' => {
                            'conlength' => '646',
                            'subtype' => undef,
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'enspm2_hv' => {
                           'conlength' => '5014',
                           'subtype' => 'CMC-EnSpm',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'zisupton_xm' => {
                             'conlength' => '476',
                             'subtype' => 'Zisupton',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'mariner-2_dmac' => {
                                'conlength' => '459',
                                'subtype' => 'TcMar-Mariner',
                                'equiv' => [
                                             {
                                               'name' => 'Mariner-1_DMac',
                                               'ranges' => [
                                                             {
                                                               'div' => '7.42',
                                                               'score' => '142',
                                                               'eqstart' => '30',
                                                               'eqend' => '478',
                                                               'start' => '29',
                                                               'end' => '459'
                                                             }
                                                           ]
                                             }
                                           ],
                                'type' => 'DNA'
                              },
          'hatx-5_sm' => {
                           'conlength' => '2577',
                           'subtype' => 'hAT-hATx',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'hatm-2_hr' => {
                           'conlength' => '3194',
                           'subtype' => 'hAT-hATm',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'harbinger-n1_ag' => {
                                 'conlength' => '356',
                                 'subtype' => 'PIF-Harbinger',
                                 'equiv' => [
                                              {
                                                'name' => 'Harbinger1_AG',
                                                'ranges' => [
                                                              {
                                                                'div' => '7.69',
                                                                'score' => '46',
                                                                'eqstart' => 1,
                                                                'eqend' => 65,
                                                                'start' => 2,
                                                                'end' => 66
                                                              },
                                                              {
                                                                'compl' => 1,
                                                                'div' => '9.23',
                                                                'score' => '39',
                                                                'eqstart' => 1,
                                                                'eqend' => 65,
                                                                'start' => 291,
                                                                'end' => 355
                                                              },
                                                              {
                                                                'div' => '5.26',
                                                                'score' => '30',
                                                                'eqstart' => 5340,
                                                                'eqend' => 5377,
                                                                'start' => 318,
                                                                'end' => 355
                                                              }
                                                            ]
                                              }
                                            ],
                                 'type' => 'DNA'
                               },
          'navihat1' => {
                          'conlength' => '5547',
                          'subtype' => 'hAT-hATm',
                          'equiv' => [],
                          'type' => 'DNA'
                        },
          'vandal2n1' => {
                           'conlength' => '2712',
                           'subtype' => 'MULE-MuDR',
                           'equiv' => [
                                        {
                                          'name' => 'Vandal2',
                                          'ranges' => [
                                                        {
                                                          'div' => '10.87',
                                                          'score' => '45',
                                                          'eqstart' => 14940,
                                                          'eqend' => 15077,
                                                          'start' => 2455,
                                                          'end' => 2592
                                                        }
                                                      ]
                                        },
                                        {
                                          'name' => 'Vandal1',
                                          'ranges' => [
                                                        {
                                                          'div' => '0.00',
                                                          'score' => '35',
                                                          'eqstart' => 1601,
                                                          'eqend' => 1635,
                                                          'start' => 1546,
                                                          'end' => 1580
                                                        }
                                                      ]
                                        }
                                      ],
                           'type' => 'DNA'
                         },
          'cheshire_mars_' => {
                                'conlength' => '1393',
                                'subtype' => 'hAT-Charlie',
                                'equiv' => [
                                             {
                                               'name' => 'CHESHIRE-2_MD',
                                               'ranges' => [
                                                             {
                                                               'div' => '3.45',
                                                               'score' => '907',
                                                               'eqstart' => 1,
                                                               'eqend' => 1372,
                                                               'start' => 1,
                                                               'end' => 1393
                                                             }
                                                           ]
                                             },
                                             {
                                               'name' => 'Cheshire_Mars',
                                               'ranges' => [
                                                             {
                                                               'div' => '0.00',
                                                               'score' => '435',
                                                               'eqstart' => 1,
                                                               'eqend' => 438,
                                                               'start' => 1,
                                                               'end' => 438
                                                             },
                                                             {
                                                               'div' => '0.00',
                                                               'score' => '917',
                                                               'eqstart' => 1449,
                                                               'eqend' => 2404,
                                                               'start' => 438,
                                                               'end' => 1393
                                                             }
                                                           ]
                                             },
                                             {
                                               'name' => 'CheshMITE',
                                               'ranges' => [
                                                             {
                                                               'compl' => 1,
                                                               'div' => '6.32',
                                                               'score' => '72',
                                                               'eqstart' => 109,
                                                               'eqend' => 205,
                                                               'start' => 1,
                                                               'end' => 95
                                                             },
                                                             {
                                                               'div' => '3.16',
                                                               'score' => '84',
                                                               'eqstart' => 1,
                                                               'eqend' => 95,
                                                               'start' => 1,
                                                               'end' => 95
                                                             }
                                                           ]
                                             }
                                           ],
                                'type' => 'DNA'
                              },
          'mariner-13_cgi' => {
                                'conlength' => '769',
                                'subtype' => 'TcMar-Pogo',
                                'equiv' => [
                                             {
                                               'name' => 'Mariner-13N2_CGi',
                                               'ranges' => [
                                                             {
                                                               'div' => '11.79',
                                                               'score' => '97',
                                                               'eqstart' => '1',
                                                               'eqend' => '211',
                                                               'start' => '1',
                                                               'end' => '212'
                                                             }
                                                           ]
                                             },
                                             {
                                               'name' => 'Mariner-13N1_CGi',
                                               'ranges' => [
                                                             {
                                                               'div' => '5.07',
                                                               'score' => '204',
                                                               'eqstart' => '1',
                                                               'eqend' => '276',
                                                               'start' => '1',
                                                               'end' => '276'
                                                             },
                                                             {
                                                               'div' => '5.00',
                                                               'score' => '34',
                                                               'eqstart' => '114',
                                                               'eqend' => '153',
                                                               'start' => '18',
                                                               'end' => '57'
                                                             },
                                                             {
                                                               'div' => '0.00',
                                                               'score' => '34',
                                                               'eqstart' => '18',
                                                               'eqend' => '57',
                                                               'start' => '114',
                                                               'end' => '154'
                                                             },
                                                             {
                                                               'div' => '9.33',
                                                               'score' => '42',
                                                               'eqstart' => '671',
                                                               'eqend' => '745',
                                                               'start' => '2851',
                                                               'end' => '2925'
                                                             }
                                                           ]
                                             }
                                           ],
                                'type' => 'DNA'
                              },
          'hat-n13_crp' => {
                             'conlength' => '1749',
                             'subtype' => 'hAT-Ac',
                             'equiv' => [
                                          {
                                            'name' => 'hAT-353_Ami',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.40',
                                                            'score' => '65',
                                                            'eqstart' => '871',
                                                            'eqend' => '983',
                                                            'start' => '661',
                                                            'end' => '774'
                                                          },
                                                          {
                                                            'div' => '12.12',
                                                            'score' => '51',
                                                            'eqstart' => '871',
                                                            'eqend' => '968',
                                                            'start' => '1359',
                                                            'end' => '1457'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N3_Crp',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.75',
                                                            'score' => '226',
                                                            'eqstart' => '1050',
                                                            'eqend' => '1665',
                                                            'start' => '189',
                                                            'end' => '784'
                                                          },
                                                          {
                                                            'div' => '11.41',
                                                            'score' => '255',
                                                            'eqstart' => '179',
                                                            'eqend' => '799',
                                                            'start' => '189',
                                                            'end' => '784'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.98',
                                                            'score' => '97',
                                                            'eqstart' => '1105',
                                                            'eqend' => '1356',
                                                            'start' => '343',
                                                            'end' => '584'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.85',
                                                            'score' => '498',
                                                            'eqstart' => '179',
                                                            'eqend' => '1626',
                                                            'start' => '374',
                                                            'end' => '1799'
                                                          },
                                                          {
                                                            'div' => '9.68',
                                                            'score' => '787',
                                                            'eqstart' => '218',
                                                            'eqend' => '1665',
                                                            'start' => '374',
                                                            'end' => '1799'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '9.05',
                                                            'score' => '279',
                                                            'eqstart' => '1206',
                                                            'eqend' => '1626',
                                                            'start' => '519',
                                                            'end' => '938'
                                                          },
                                                          {
                                                            'div' => '7.14',
                                                            'score' => '309',
                                                            'eqstart' => '218',
                                                            'eqend' => '638',
                                                            'start' => '519',
                                                            'end' => '938'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.64',
                                                            'score' => '100',
                                                            'eqstart' => '1366',
                                                            'eqend' => '1626',
                                                            'start' => '665',
                                                            'end' => '933'
                                                          },
                                                          {
                                                            'div' => '12.04',
                                                            'score' => '117',
                                                            'eqstart' => '218',
                                                            'eqend' => '483',
                                                            'start' => '665',
                                                            'end' => '938'
                                                          },
                                                          {
                                                            'div' => '12.37',
                                                            'score' => '49',
                                                            'eqstart' => '208',
                                                            'eqend' => '305',
                                                            'start' => '810',
                                                            'end' => '906'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '10.84',
                                                            'score' => '50',
                                                            'eqstart' => '1539',
                                                            'eqend' => '1621',
                                                            'start' => '824',
                                                            'end' => '906'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '9.38',
                                                            'score' => '228',
                                                            'eqstart' => '229',
                                                            'eqend' => '638',
                                                            'start' => '1188',
                                                            'end' => '1603'
                                                          },
                                                          {
                                                            'div' => '12.02',
                                                            'score' => '183',
                                                            'eqstart' => '1206',
                                                            'eqend' => '1615',
                                                            'start' => '1188',
                                                            'end' => '1603'
                                                          },
                                                          {
                                                            'div' => '9.62',
                                                            'score' => '32',
                                                            'eqstart' => '1238',
                                                            'eqend' => '1289',
                                                            'start' => '1673',
                                                            'end' => '1724'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N4_Crp',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.57',
                                                            'score' => '81',
                                                            'eqstart' => '490',
                                                            'eqend' => '656',
                                                            'start' => '189',
                                                            'end' => '355'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '8.33',
                                                            'score' => '81',
                                                            'eqstart' => '490',
                                                            'eqend' => '622',
                                                            'start' => '369',
                                                            'end' => '500'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '9.77',
                                                            'score' => '81',
                                                            'eqstart' => '490',
                                                            'eqend' => '622',
                                                            'start' => '514',
                                                            'end' => '646'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '6.03',
                                                            'score' => '77',
                                                            'eqstart' => '508',
                                                            'eqend' => '622',
                                                            'start' => '660',
                                                            'end' => '775'
                                                          },
                                                          {
                                                            'div' => '6.00',
                                                            'score' => '65',
                                                            'eqstart' => '508',
                                                            'eqend' => '606',
                                                            'start' => '1358',
                                                            'end' => '1457'
                                                          },
                                                          {
                                                            'div' => '11.28',
                                                            'score' => '71',
                                                            'eqstart' => '490',
                                                            'eqend' => '622',
                                                            'start' => '1487',
                                                            'end' => '1619'
                                                          },
                                                          {
                                                            'div' => '11.56',
                                                            'score' => '74',
                                                            'eqstart' => '490',
                                                            'eqend' => '688',
                                                            'start' => '1633',
                                                            'end' => '1831'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-12_Crp',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.56',
                                                            'score' => '62',
                                                            'eqstart' => '2357',
                                                            'eqend' => '2555',
                                                            'start' => '660',
                                                            'end' => '866'
                                                          },
                                                          {
                                                            'div' => '10.10',
                                                            'score' => '48',
                                                            'eqstart' => '2442',
                                                            'eqend' => '2539',
                                                            'start' => '1359',
                                                            'end' => '1457'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-4B_AMi',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.51',
                                                            'score' => '133',
                                                            'eqstart' => '5171',
                                                            'eqend' => '5423',
                                                            'start' => '374',
                                                            'end' => '625'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '8.27',
                                                            'score' => '182',
                                                            'eqstart' => '5159',
                                                            'eqend' => '5423',
                                                            'start' => '519',
                                                            'end' => '784'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '10.22',
                                                            'score' => '121',
                                                            'eqstart' => '5159',
                                                            'eqend' => '5423',
                                                            'start' => '665',
                                                            'end' => '938'
                                                          },
                                                          {
                                                            'div' => '10.76',
                                                            'score' => '150',
                                                            'eqstart' => '5133',
                                                            'eqend' => '5423',
                                                            'start' => '1327',
                                                            'end' => '1614'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-262_Ami',
                                            'ranges' => [
                                                          {
                                                            'div' => '12.02',
                                                            'score' => '133',
                                                            'eqstart' => '1',
                                                            'eqend' => '341',
                                                            'start' => '1',
                                                            'end' => '341'
                                                          },
                                                          {
                                                            'div' => '8.47',
                                                            'score' => '73',
                                                            'eqstart' => '223',
                                                            'eqend' => '341',
                                                            'start' => '369',
                                                            'end' => '486'
                                                          },
                                                          {
                                                            'div' => '10.08',
                                                            'score' => '74',
                                                            'eqstart' => '223',
                                                            'eqend' => '341',
                                                            'start' => '514',
                                                            'end' => '632'
                                                          },
                                                          {
                                                            'div' => '6.90',
                                                            'score' => '76',
                                                            'eqstart' => '223',
                                                            'eqend' => '337',
                                                            'start' => '660',
                                                            'end' => '775'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '7.00',
                                                            'score' => '62',
                                                            'eqstart' => '239',
                                                            'eqend' => '337',
                                                            'start' => '1358',
                                                            'end' => '1457'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.76',
                                                            'score' => '63',
                                                            'eqstart' => '223',
                                                            'eqend' => '341',
                                                            'start' => '1501',
                                                            'end' => '1619'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '9.69',
                                                            'score' => '112',
                                                            'eqstart' => '115',
                                                            'eqend' => '341',
                                                            'start' => '1647',
                                                            'end' => '1873'
                                                          },
                                                          {
                                                            'div' => '12.23',
                                                            'score' => '48',
                                                            'eqstart' => '1354',
                                                            'eqend' => '1492',
                                                            'start' => '1860',
                                                            'end' => '1998'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-61_Ami',
                                            'ranges' => [
                                                          {
                                                            'div' => '12.79',
                                                            'score' => '85',
                                                            'eqstart' => '88',
                                                            'eqend' => '306',
                                                            'start' => '98',
                                                            'end' => '316'
                                                          },
                                                          {
                                                            'div' => '10.64',
                                                            'score' => '54',
                                                            'eqstart' => '213',
                                                            'eqend' => '306',
                                                            'start' => '369',
                                                            'end' => '462'
                                                          },
                                                          {
                                                            'div' => '9.82',
                                                            'score' => '59',
                                                            'eqstart' => '213',
                                                            'eqend' => '323',
                                                            'start' => '660',
                                                            'end' => '771'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '8.64',
                                                            'score' => '49',
                                                            'eqstart' => '229',
                                                            'eqend' => '309',
                                                            'start' => '1377',
                                                            'end' => '1457'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.44',
                                                            'score' => '88',
                                                            'eqstart' => '106',
                                                            'eqend' => '306',
                                                            'start' => '1672',
                                                            'end' => '1872'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-11_AMi',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.08',
                                                            'score' => '73',
                                                            'eqstart' => '5543',
                                                            'eqend' => '5691',
                                                            'start' => '189',
                                                            'end' => '337'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '10.53',
                                                            'score' => '59',
                                                            'eqstart' => '5543',
                                                            'eqend' => '5657',
                                                            'start' => '369',
                                                            'end' => '482'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '9.71',
                                                            'score' => '88',
                                                            'eqstart' => '5482',
                                                            'eqend' => '5657',
                                                            'start' => '660',
                                                            'end' => '834'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.80',
                                                            'score' => '51',
                                                            'eqstart' => '5538',
                                                            'eqend' => '5662',
                                                            'start' => '810',
                                                            'end' => '934'
                                                          },
                                                          {
                                                            'div' => '11.39',
                                                            'score' => '68',
                                                            'eqstart' => '5500',
                                                            'eqend' => '5657',
                                                            'start' => '1316',
                                                            'end' => '1473'
                                                          },
                                                          {
                                                            'div' => '11.70',
                                                            'score' => '49',
                                                            'eqstart' => '5564',
                                                            'eqend' => '5657',
                                                            'start' => '1526',
                                                            'end' => '1619'
                                                          },
                                                          {
                                                            'div' => '11.83',
                                                            'score' => '73',
                                                            'eqstart' => '5564',
                                                            'eqend' => '5749',
                                                            'start' => '1672',
                                                            'end' => '1857'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-74_AMi',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.63',
                                                            'score' => '168',
                                                            'eqstart' => '949',
                                                            'eqend' => '1354',
                                                            'start' => '189',
                                                            'end' => '584'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '10.20',
                                                            'score' => '58',
                                                            'eqstart' => '948',
                                                            'eqend' => '1045',
                                                            'start' => '343',
                                                            'end' => '440'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.17',
                                                            'score' => '179',
                                                            'eqstart' => '894',
                                                            'eqend' => '1315',
                                                            'start' => '374',
                                                            'end' => '784'
                                                          },
                                                          {
                                                            'div' => '12.41',
                                                            'score' => '165',
                                                            'eqstart' => '220',
                                                            'eqend' => '646',
                                                            'start' => '374',
                                                            'end' => '784'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.80',
                                                            'score' => '355',
                                                            'eqstart' => '231',
                                                            'eqend' => '1315',
                                                            'start' => '519',
                                                            'end' => '1603'
                                                          },
                                                          {
                                                            'div' => '7.83',
                                                            'score' => '695',
                                                            'eqstart' => '220',
                                                            'eqend' => '1304',
                                                            'start' => '519',
                                                            'end' => '1603'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.31',
                                                            'score' => '120',
                                                            'eqstart' => '1050',
                                                            'eqend' => '1315',
                                                            'start' => '665',
                                                            'end' => '938'
                                                          },
                                                          {
                                                            'div' => '12.04',
                                                            'score' => '112',
                                                            'eqstart' => '220',
                                                            'eqend' => '485',
                                                            'start' => '665',
                                                            'end' => '938'
                                                          },
                                                          {
                                                            'div' => '12.24',
                                                            'score' => '51',
                                                            'eqstart' => '948',
                                                            'eqend' => '1045',
                                                            'start' => '1548',
                                                            'end' => '1645'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N8_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '10.80',
                                                            'score' => '265',
                                                            'eqstart' => '38',
                                                            'eqend' => '585',
                                                            'start' => '48',
                                                            'end' => '584'
                                                          },
                                                          {
                                                            'div' => '9.98',
                                                            'score' => '195',
                                                            'eqstart' => '217',
                                                            'eqend' => '647',
                                                            'start' => '374',
                                                            'end' => '784'
                                                          },
                                                          {
                                                            'div' => '8.33',
                                                            'score' => '243',
                                                            'eqstart' => '217',
                                                            'eqend' => '647',
                                                            'start' => '519',
                                                            'end' => '938'
                                                          },
                                                          {
                                                            'div' => '10.58',
                                                            'score' => '120',
                                                            'eqstart' => '217',
                                                            'eqend' => '484',
                                                            'start' => '665',
                                                            'end' => '938'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.22',
                                                            'score' => '73',
                                                            'eqstart' => '228',
                                                            'eqend' => '484',
                                                            'start' => '1188',
                                                            'end' => '1457'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '5.39',
                                                            'score' => '332',
                                                            'eqstart' => '217',
                                                            'eqend' => '647',
                                                            'start' => '1188',
                                                            'end' => '1614'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '9.58',
                                                            'score' => '259',
                                                            'eqstart' => '105',
                                                            'eqend' => '669',
                                                            'start' => '1331',
                                                            'end' => '1873'
                                                          },
                                                          {
                                                            'div' => '10.87',
                                                            'score' => '81',
                                                            'eqstart' => '933',
                                                            'eqend' => '1070',
                                                            'start' => '1861',
                                                            'end' => '1998'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-236_Ami',
                                            'ranges' => [
                                                          {
                                                            'div' => '10.14',
                                                            'score' => '67',
                                                            'eqstart' => '820',
                                                            'eqend' => '957',
                                                            'start' => '1861',
                                                            'end' => '1998'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-4_AMi',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.36',
                                                            'score' => '178',
                                                            'eqstart' => '4933',
                                                            'eqend' => '5335',
                                                            'start' => '189',
                                                            'end' => '584'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '10.64',
                                                            'score' => '163',
                                                            'eqstart' => '4933',
                                                            'eqend' => '5296',
                                                            'start' => '374',
                                                            'end' => '730'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '8.47',
                                                            'score' => '220',
                                                            'eqstart' => '4933',
                                                            'eqend' => '5296',
                                                            'start' => '519',
                                                            'end' => '884'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '10.22',
                                                            'score' => '106',
                                                            'eqstart' => '5035',
                                                            'eqend' => '5296',
                                                            'start' => '665',
                                                            'end' => '938'
                                                          },
                                                          {
                                                            'div' => '8.83',
                                                            'score' => '241',
                                                            'eqstart' => '4881',
                                                            'eqend' => '5296',
                                                            'start' => '1196',
                                                            'end' => '1614'
                                                          },
                                                          {
                                                            'div' => '11.98',
                                                            'score' => '55',
                                                            'eqstart' => '5081',
                                                            'eqend' => '5285',
                                                            'start' => '1241',
                                                            'end' => '1457'
                                                          },
                                                          {
                                                            'div' => '11.84',
                                                            'score' => '171',
                                                            'eqstart' => '4933',
                                                            'eqend' => '5335',
                                                            'start' => '1403',
                                                            'end' => '1799'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-732_Ami',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.95',
                                                            'score' => '73',
                                                            'eqstart' => '1',
                                                            'eqend' => '139',
                                                            'start' => '1860',
                                                            'end' => '1998'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-17B_Croc',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.29',
                                                            'score' => '214',
                                                            'eqstart' => '5344',
                                                            'eqend' => '5857',
                                                            'start' => '189',
                                                            'end' => '684'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.00',
                                                            'score' => '119',
                                                            'eqstart' => '5344',
                                                            'eqend' => '5685',
                                                            'start' => '214',
                                                            'end' => '538'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '9.57',
                                                            'score' => '247',
                                                            'eqstart' => '5344',
                                                            'eqend' => '5823',
                                                            'start' => '369',
                                                            'end' => '838'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.77',
                                                            'score' => '37',
                                                            'eqstart' => '4797',
                                                            'eqend' => '4891',
                                                            'start' => '407',
                                                            'end' => '500'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '10.05',
                                                            'score' => '240',
                                                            'eqstart' => '5406',
                                                            'eqend' => '5823',
                                                            'start' => '514',
                                                            'end' => '931'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '9.56',
                                                            'score' => '140',
                                                            'eqstart' => '5559',
                                                            'eqend' => '5823',
                                                            'start' => '660',
                                                            'end' => '931'
                                                          },
                                                          {
                                                            'div' => '11.74',
                                                            'score' => '183',
                                                            'eqstart' => '5406',
                                                            'eqend' => '5807',
                                                            'start' => '1195',
                                                            'end' => '1603'
                                                          },
                                                          {
                                                            'div' => '11.03',
                                                            'score' => '99',
                                                            'eqstart' => '5559',
                                                            'eqend' => '5807',
                                                            'start' => '1195',
                                                            'end' => '1457'
                                                          },
                                                          {
                                                            'div' => '10.69',
                                                            'score' => '218',
                                                            'eqstart' => '5358',
                                                            'eqend' => '5889',
                                                            'start' => '1308',
                                                            'end' => '1831'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-6_AMi',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.08',
                                                            'score' => '136',
                                                            'eqstart' => '4692',
                                                            'eqend' => '5038',
                                                            'start' => '131',
                                                            'end' => '482'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '9.45',
                                                            'score' => '124',
                                                            'eqstart' => '4692',
                                                            'eqend' => '4942',
                                                            'start' => '375',
                                                            'end' => '628'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '7.25',
                                                            'score' => '152',
                                                            'eqstart' => '4660',
                                                            'eqend' => '4933',
                                                            'start' => '530',
                                                            'end' => '805'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '8.06',
                                                            'score' => '122',
                                                            'eqstart' => '4683',
                                                            'eqend' => '4942',
                                                            'start' => '666',
                                                            'end' => '938'
                                                          },
                                                          {
                                                            'div' => '7.37',
                                                            'score' => '87',
                                                            'eqstart' => '4729',
                                                            'eqend' => '4933',
                                                            'start' => '1241',
                                                            'end' => '1457'
                                                          },
                                                          {
                                                            'div' => '6.64',
                                                            'score' => '155',
                                                            'eqstart' => '4660',
                                                            'eqend' => '4915',
                                                            'start' => '1328',
                                                            'end' => '1583'
                                                          },
                                                          {
                                                            'div' => '11.17',
                                                            'score' => '138',
                                                            'eqstart' => '4695',
                                                            'eqend' => '5046',
                                                            'start' => '1508',
                                                            'end' => '1865'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-17_Croc',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.50',
                                                            'score' => '96',
                                                            'eqstart' => '5374',
                                                            'eqend' => '5590',
                                                            'start' => '100',
                                                            'end' => '315'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '7.02',
                                                            'score' => '72',
                                                            'eqstart' => '5351',
                                                            'eqend' => '5466',
                                                            'start' => '369',
                                                            'end' => '482'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '8.70',
                                                            'score' => '73',
                                                            'eqstart' => '5351',
                                                            'eqend' => '5466',
                                                            'start' => '514',
                                                            'end' => '628'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '5.48',
                                                            'score' => '105',
                                                            'eqstart' => '5319',
                                                            'eqend' => '5466',
                                                            'start' => '660',
                                                            'end' => '805'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '8.80',
                                                            'score' => '78',
                                                            'eqstart' => '5346',
                                                            'eqend' => '5471',
                                                            'start' => '810',
                                                            'end' => '934'
                                                          },
                                                          {
                                                            'div' => '4.62',
                                                            'score' => '94',
                                                            'eqstart' => '5319',
                                                            'eqend' => '5450',
                                                            'start' => '1328',
                                                            'end' => '1457'
                                                          },
                                                          {
                                                            'div' => '9.82',
                                                            'score' => '62',
                                                            'eqstart' => '5354',
                                                            'eqend' => '5466',
                                                            'start' => '1508',
                                                            'end' => '1619'
                                                          },
                                                          {
                                                            'div' => '11.94',
                                                            'score' => '98',
                                                            'eqstart' => '5374',
                                                            'eqend' => '5575',
                                                            'start' => '1673',
                                                            'end' => '1873'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '7.19',
                                                            'score' => '78',
                                                            'eqstart' => '1',
                                                            'eqend' => '139',
                                                            'start' => '1860',
                                                            'end' => '1998'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-12B_Crp',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.36',
                                                            'score' => '65',
                                                            'eqstart' => '3277',
                                                            'eqend' => '3409',
                                                            'start' => '369',
                                                            'end' => '500'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '9.57',
                                                            'score' => '60',
                                                            'eqstart' => '3296',
                                                            'eqend' => '3409',
                                                            'start' => '660',
                                                            'end' => '774'
                                                          },
                                                          {
                                                            'div' => '10.10',
                                                            'score' => '48',
                                                            'eqstart' => '3296',
                                                            'eqend' => '3393',
                                                            'start' => '1359',
                                                            'end' => '1457'
                                                          },
                                                          {
                                                            'div' => '12.40',
                                                            'score' => '58',
                                                            'eqstart' => '3277',
                                                            'eqend' => '3397',
                                                            'start' => '1633',
                                                            'end' => '1753'
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'dna-ta-15_nv' => {
                              'conlength' => '430',
                              'subtype' => undef,
                              'equiv' => [
                                           {
                                             'name' => 'DNA-7-10_NV',
                                             'ranges' => [
                                                           {
                                                             'div' => '11.25',
                                                             'score' => '77',
                                                             'eqstart' => 24,
                                                             'eqend' => 186,
                                                             'start' => 206,
                                                             'end' => 365
                                                           },
                                                           {
                                                             'compl' => 1,
                                                             'div' => '8.55',
                                                             'score' => '75',
                                                             'eqstart' => 952,
                                                             'eqend' => 1068,
                                                             'start' => 225,
                                                             'end' => 341
                                                           }
                                                         ]
                                           }
                                         ],
                              'type' => 'DNA'
                            },
          'enspm1_tm' => {
                           'conlength' => '8950',
                           'subtype' => 'CMC-EnSpm',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'merlin10_sm' => {
                             'conlength' => '1213',
                             'subtype' => 'Merlin',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'mariner-5_del' => {
                               'conlength' => '1054',
                               'subtype' => 'TcMar-Tc1',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'hatm-1_aa' => {
                           'conlength' => '5665',
                           'subtype' => 'hAT-hATm',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'ucon89' => {
                        'conlength' => '242',
                        'subtype' => 'hAT',
                        'equiv' => [],
                        'type' => 'DNA'
                      },
          'foldback1n_ci' => {
                               'conlength' => '2297',
                               'subtype' => undef,
                               'equiv' => [
                                            {
                                              'name' => 'HAT4_CI',
                                              'ranges' => [
                                                            {
                                                              'div' => '9.21',
                                                              'score' => '80',
                                                              'eqstart' => '3420',
                                                              'eqend' => '3569',
                                                              'start' => 131,
                                                              'end' => '282'
                                                            },
                                                            {
                                                              'div' => '8.57',
                                                              'score' => '121',
                                                              'eqstart' => 3362,
                                                              'eqend' => 3569,
                                                              'start' => 137,
                                                              'end' => 346
                                                            },
                                                            {
                                                              'div' => '7.87',
                                                              'score' => '105',
                                                              'eqstart' => 3394,
                                                              'eqend' => 3569,
                                                              'start' => 137,
                                                              'end' => 314
                                                            },
                                                            {
                                                              'div' => '8.11',
                                                              'score' => '135',
                                                              'eqstart' => 3350,
                                                              'eqend' => 3569,
                                                              'start' => 157,
                                                              'end' => 378
                                                            },
                                                            {
                                                              'div' => '7.50',
                                                              'score' => '127',
                                                              'eqstart' => 3353,
                                                              'eqend' => 3550,
                                                              'start' => 192,
                                                              'end' => 391
                                                            },
                                                            {
                                                              'div' => '8.02',
                                                              'score' => '108',
                                                              'eqstart' => 3350,
                                                              'eqend' => 3569,
                                                              'start' => 221,
                                                              'end' => 432
                                                            },
                                                            {
                                                              'div' => '6.70',
                                                              'score' => '115',
                                                              'eqstart' => 3374,
                                                              'eqend' => 3550,
                                                              'start' => 395,
                                                              'end' => 573
                                                            },
                                                            {
                                                              'div' => '7.25',
                                                              'score' => '47',
                                                              'eqstart' => '3349',
                                                              'eqend' => '3417',
                                                              'start' => 402,
                                                              'end' => '470'
                                                            },
                                                            {
                                                              'div' => '7.81',
                                                              'score' => '81',
                                                              'eqstart' => '3443',
                                                              'eqend' => '3569',
                                                              'start' => 433,
                                                              'end' => '560'
                                                            },
                                                            {
                                                              'div' => '7.28',
                                                              'score' => '110',
                                                              'eqstart' => 3356,
                                                              'eqend' => 3569,
                                                              'start' => 473,
                                                              'end' => 678
                                                            },
                                                            {
                                                              'div' => '8.08',
                                                              'score' => '95',
                                                              'eqstart' => '3349',
                                                              'eqend' => '3555',
                                                              'start' => 498,
                                                              'end' => '695'
                                                            },
                                                            {
                                                              'div' => '7.56',
                                                              'score' => '65',
                                                              'eqstart' => 3374,
                                                              'eqend' => 3491,
                                                              'start' => 577,
                                                              'end' => 695
                                                            },
                                                            {
                                                              'div' => '7.96',
                                                              'score' => '65',
                                                              'eqstart' => '3349',
                                                              'eqend' => '3461',
                                                              'start' => 584,
                                                              'end' => '696'
                                                            },
                                                            {
                                                              'div' => '6.17',
                                                              'score' => '55',
                                                              'eqstart' => 3349,
                                                              'eqend' => 3430,
                                                              'start' => 616,
                                                              'end' => 696
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '7.84',
                                                              'score' => '36',
                                                              'eqstart' => '3349',
                                                              'eqend' => '3399',
                                                              'start' => 1758,
                                                              'end' => 1808
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '4.82',
                                                              'score' => '66',
                                                              'eqstart' => 3349,
                                                              'eqend' => 3431,
                                                              'start' => 1758,
                                                              'end' => 1840
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '5.26',
                                                              'score' => '83',
                                                              'eqstart' => 3350,
                                                              'eqend' => 3462,
                                                              'start' => 1758,
                                                              'end' => 1871
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '6.25',
                                                              'score' => '97',
                                                              'eqstart' => 3350,
                                                              'eqend' => 3491,
                                                              'start' => 1760,
                                                              'end' => 1903
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '6.21',
                                                              'score' => '122',
                                                              'eqstart' => 3349,
                                                              'eqend' => 3523,
                                                              'start' => 1760,
                                                              'end' => 1936
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '6.25',
                                                              'score' => '146',
                                                              'eqstart' => 3350,
                                                              'eqend' => 3555,
                                                              'start' => 1760,
                                                              'end' => 1967
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '7.17',
                                                              'score' => '149',
                                                              'eqstart' => 3349,
                                                              'eqend' => 3569,
                                                              'start' => 1778,
                                                              'end' => 2000
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '8.11',
                                                              'score' => '138',
                                                              'eqstart' => '3350',
                                                              'eqend' => '3569',
                                                              'start' => 1810,
                                                              'end' => '2031'
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '8.97',
                                                              'score' => '133',
                                                              'eqstart' => '3349',
                                                              'eqend' => '3569',
                                                              'start' => 1842,
                                                              'end' => '2064'
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '8.52',
                                                              'score' => '136',
                                                              'eqstart' => 3349,
                                                              'eqend' => 3569,
                                                              'start' => 1874,
                                                              'end' => 2096
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '8.44',
                                                              'score' => '127',
                                                              'eqstart' => 3349,
                                                              'eqend' => 3569,
                                                              'start' => 1906,
                                                              'end' => 2130
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '8.89',
                                                              'score' => '123',
                                                              'eqstart' => 3349,
                                                              'eqend' => 3569,
                                                              'start' => 1938,
                                                              'end' => 2162
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '8.48',
                                                              'score' => '128',
                                                              'eqstart' => 3350,
                                                              'eqend' => 3569,
                                                              'start' => 1970,
                                                              'end' => 2193
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '8.00',
                                                              'score' => '130',
                                                              'eqstart' => 3349,
                                                              'eqend' => 3569,
                                                              'start' => 2034,
                                                              'end' => 2258
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '8.04',
                                                              'score' => '127',
                                                              'eqstart' => 3350,
                                                              'eqend' => 3569,
                                                              'start' => 2066,
                                                              'end' => 2289
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '8.74',
                                                              'score' => '118',
                                                              'eqstart' => 3362,
                                                              'eqend' => 3565,
                                                              'start' => 2104,
                                                              'end' => 2309
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '7.87',
                                                              'score' => '104',
                                                              'eqstart' => '3394',
                                                              'eqend' => '3569',
                                                              'start' => 2132,
                                                              'end' => '2309'
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '9.21',
                                                              'score' => '79',
                                                              'eqstart' => 3420,
                                                              'eqend' => 3569,
                                                              'start' => 2164,
                                                              'end' => 2315
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '9.17',
                                                              'score' => '64',
                                                              'eqstart' => 3451,
                                                              'eqend' => 3569,
                                                              'start' => 2196,
                                                              'end' => 2315
                                                            }
                                                          ]
                                            }
                                          ],
                               'type' => 'DNA'
                             },
          'mariner-n3b_cgi' => {
                                 'conlength' => '549',
                                 'subtype' => 'TcMar?',
                                 'equiv' => [
                                              {
                                                'name' => 'Mariner-N3_CGi',
                                                'ranges' => [
                                                              {
                                                                'div' => '0.58',
                                                                'score' => '158',
                                                                'eqstart' => '1',
                                                                'eqend' => '172',
                                                                'start' => '1',
                                                                'end' => '171'
                                                              },
                                                              {
                                                                'div' => '0.52',
                                                                'score' => '358',
                                                                'eqstart' => '534',
                                                                'eqend' => '916',
                                                                'start' => '167',
                                                                'end' => '549'
                                                              }
                                                            ]
                                              }
                                            ],
                                 'type' => 'DNA'
                               },
          'hat-n17_sbi' => {
                             'conlength' => '949',
                             'subtype' => 'hAT-Tip100',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'mudr-19_sbi' => {
                             'conlength' => '4834',
                             'subtype' => 'MULE-MuDR',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'tigger2b' => {
                          'conlength' => '726',
                          'subtype' => 'TcMar-Tigger',
                          'equiv' => [],
                          'type' => 'DNA'
                        },
          'mariner-3_dro' => {
                               'conlength' => '1648',
                               'subtype' => 'TcMar-Tc1',
                               'equiv' => [
                                            {
                                              'name' => 'Mariner-10_DK',
                                              'ranges' => [
                                                            {
                                                              'div' => '5.56',
                                                              'score' => '30',
                                                              'eqstart' => '1109',
                                                              'eqend' => '1144',
                                                              'start' => '1111',
                                                              'end' => '1146'
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '5.56',
                                                              'score' => '30',
                                                              'eqstart' => '511',
                                                              'eqend' => '546',
                                                              'start' => '1111',
                                                              'end' => '1146'
                                                            }
                                                          ]
                                            }
                                          ],
                               'type' => 'DNA'
                             },
          'mimo' => {
                      'conlength' => '381',
                      'subtype' => 'TcMar-Tc1?',
                      'equiv' => [],
                      'type' => 'DNA'
                    },
          'dna3-11_cgi' => {
                             'conlength' => '2040',
                             'subtype' => 'PIF-Harbinger',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'hat-n30_crp' => {
                             'conlength' => '341',
                             'subtype' => 'hAT-Tip100',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'p-1n1_dbp' => {
                           'conlength' => '1431',
                           'subtype' => 'P',
                           'equiv' => [
                                        {
                                          'name' => 'P-1_DBp',
                                          'ranges' => [
                                                        {
                                                          'compl' => 1,
                                                          'div' => '1.45',
                                                          'score' => '728',
                                                          'eqstart' => '4308',
                                                          'eqend' => '5129',
                                                          'start' => '1',
                                                          'end' => '825'
                                                        },
                                                        {
                                                          'div' => '1.30',
                                                          'score' => '741',
                                                          'eqstart' => '1',
                                                          'eqend' => '853',
                                                          'start' => '1',
                                                          'end' => '847'
                                                        },
                                                        {
                                                          'compl' => 1,
                                                          'div' => '1.04',
                                                          'score' => '509',
                                                          'eqstart' => '1',
                                                          'eqend' => '589',
                                                          'start' => '854',
                                                          'end' => '1431'
                                                        },
                                                        {
                                                          'div' => '1.04',
                                                          'score' => '505',
                                                          'eqstart' => '4543',
                                                          'eqend' => '5129',
                                                          'start' => '854',
                                                          'end' => '1431'
                                                        }
                                                      ]
                                        }
                                      ],
                           'type' => 'DNA'
                         },
          'mariner-6_pgr' => {
                               'conlength' => '4689',
                               'subtype' => 'TcMar-Ant1',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'hat-n9_ami' => {
                            'conlength' => '1393',
                            'subtype' => 'hAT-Charlie',
                            'equiv' => [
                                         {
                                           'name' => 'hAT-N16_AMi',
                                           'ranges' => [
                                                         {
                                                           'div' => '2.74',
                                                           'score' => '62',
                                                           'eqstart' => '143',
                                                           'eqend' => '216',
                                                           'start' => '1321',
                                                           'end' => '1393'
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'ginger1-7_hm' => {
                              'conlength' => '6088',
                              'subtype' => 'Ginger-1',
                              'equiv' => [
                                           {
                                             'name' => 'Ginger1-8_HM',
                                             'ranges' => [
                                                           {
                                                             'div' => '6.00',
                                                             'score' => '38',
                                                             'eqstart' => 6,
                                                             'eqend' => 55,
                                                             'start' => 6,
                                                             'end' => 55
                                                           }
                                                         ]
                                           }
                                         ],
                              'type' => 'DNA'
                            },
          'dna3-8_pst' => {
                            'conlength' => '172',
                            'subtype' => undef,
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'dna-at-1_dr' => {
                             'conlength' => '392',
                             'subtype' => undef,
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'piggybac-2_nv' => {
                               'conlength' => '3322',
                               'subtype' => 'PiggyBac',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'tigger3' => {
                         'conlength' => '3029',
                         'subtype' => 'TcMar-Tigger',
                         'equiv' => [
                                      {
                                        'name' => 'Tigger3c',
                                        'ranges' => [
                                                      {
                                                        'div' => '2.24',
                                                        'score' => '125',
                                                        'eqstart' => 1,
                                                        'eqend' => 134,
                                                        'start' => 1,
                                                        'end' => 134
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '451',
                                                        'eqstart' => 144,
                                                        'eqend' => 602,
                                                        'start' => 2571,
                                                        'end' => 3029
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Tigger3a',
                                        'ranges' => [
                                                      {
                                                        'div' => '1.33',
                                                        'score' => '72',
                                                        'eqstart' => 1,
                                                        'eqend' => 75,
                                                        'start' => 1,
                                                        'end' => 75
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '271',
                                                        'eqstart' => 74,
                                                        'eqend' => 348,
                                                        'start' => 2755,
                                                        'end' => 3029
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Tigger3d',
                                        'ranges' => [
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '80',
                                                        'eqstart' => 1,
                                                        'eqend' => 80,
                                                        'start' => 1,
                                                        'end' => 80
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '110',
                                                        'eqstart' => 212,
                                                        'eqend' => 321,
                                                        'start' => 2920,
                                                        'end' => 3029
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Tigger3b',
                                        'ranges' => [
                                                      {
                                                        'div' => '1.41',
                                                        'score' => '323',
                                                        'eqstart' => 1,
                                                        'eqend' => 356,
                                                        'start' => 1,
                                                        'end' => 354
                                                      },
                                                      {
                                                        'div' => '0.46',
                                                        'score' => '836',
                                                        'eqstart' => 355,
                                                        'eqend' => 1231,
                                                        'start' => 2153,
                                                        'end' => 3029
                                                      }
                                                    ]
                                      }
                                    ],
                         'type' => 'DNA'
                       },
          'academ-1_adi' => {
                              'conlength' => '9022',
                              'subtype' => 'Academ-2',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'piggybac1n_ci' => {
                               'conlength' => '633',
                               'subtype' => 'PiggyBac',
                               'equiv' => [
                                            {
                                              'name' => 'piggyBac1_CI',
                                              'ranges' => [
                                                            {
                                                              'div' => '5.11',
                                                              'score' => '134',
                                                              'eqstart' => 1,
                                                              'eqend' => 176,
                                                              'start' => 1,
                                                              'end' => 176
                                                            }
                                                          ]
                                            }
                                          ],
                               'type' => 'DNA'
                             },
          'p-1_nv' => {
                        'conlength' => '1095',
                        'subtype' => 'P',
                        'equiv' => [],
                        'type' => 'DNA'
                      },
          'mariner-n20_ag' => {
                                'conlength' => '479',
                                'subtype' => 'TcMar-ISRm11',
                                'equiv' => [],
                                'type' => 'DNA'
                              },
          'dna-23_cgi' => {
                            'conlength' => '515',
                            'subtype' => undef,
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'harb-n16_zm' => {
                             'conlength' => '404',
                             'subtype' => 'PIF-Harbinger',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'hat-10_mad' => {
                            'conlength' => '6710',
                            'subtype' => 'hAT-Ac',
                            'equiv' => [
                                         {
                                           'name' => 'HAT-N11_Mad',
                                           'ranges' => [
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '48',
                                                           'eqstart' => 32,
                                                           'eqend' => 79,
                                                           'start' => 21,
                                                           'end' => 68
                                                         },
                                                         {
                                                           'div' => '1.72',
                                                           'score' => '121',
                                                           'eqstart' => 80,
                                                           'eqend' => 253,
                                                           'start' => 141,
                                                           'end' => 314
                                                         },
                                                         {
                                                           'div' => '3.38',
                                                           'score' => '643',
                                                           'eqstart' => '245',
                                                           'eqend' => '1173',
                                                           'start' => 983,
                                                           'end' => '1928'
                                                         },
                                                         {
                                                           'div' => '2.70',
                                                           'score' => '198',
                                                           'eqstart' => 1252,
                                                           'eqend' => 1473,
                                                           'start' => 6489,
                                                           'end' => 6710
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA9-5_Mad',
                                           'ranges' => [
                                                         {
                                                           'div' => '7.63',
                                                           'score' => '306',
                                                           'eqstart' => 1,
                                                           'eqend' => 667,
                                                           'start' => 315,
                                                           'end' => 982
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'HAT-N10_Mad',
                                           'ranges' => [
                                                         {
                                                           'div' => '7.69',
                                                           'score' => '43',
                                                           'eqstart' => 4818,
                                                           'eqend' => 4882,
                                                           'start' => 6619,
                                                           'end' => 6683
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'hat-68_hm' => {
                           'conlength' => '5873',
                           'subtype' => 'hAT-Tip100',
                           'equiv' => [
                                        {
                                          'name' => 'DNA-8-2_HM',
                                          'ranges' => [
                                                        {
                                                          'compl' => 1,
                                                          'div' => '10.53',
                                                          'score' => '42',
                                                          'eqstart' => 539,
                                                          'eqend' => 632,
                                                          'start' => 5566,
                                                          'end' => 5660
                                                        }
                                                      ]
                                        },
                                        {
                                          'name' => 'hAT-15_HM',
                                          'ranges' => [
                                                        {
                                                          'div' => '3.03',
                                                          'score' => '56',
                                                          'eqstart' => 306,
                                                          'eqend' => 371,
                                                          'start' => 41,
                                                          'end' => 106
                                                        },
                                                        {
                                                          'compl' => 1,
                                                          'div' => '7.69',
                                                          'score' => '41',
                                                          'eqstart' => '306',
                                                          'eqend' => '370',
                                                          'start' => 5769,
                                                          'end' => '5833'
                                                        }
                                                      ]
                                        }
                                      ],
                           'type' => 'DNA'
                         },
          'dna-2-1_dr' => {
                            'conlength' => '2550',
                            'subtype' => undef,
                            'equiv' => [
                                         {
                                           'name' => 'Harbinger1_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '9.23',
                                                           'score' => '43',
                                                           'eqstart' => 915,
                                                           'eqend' => 979,
                                                           'start' => 1846,
                                                           'end' => 1910
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'tc1-16_xt' => {
                           'conlength' => '1635',
                           'subtype' => 'TcMar-Tc1',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'hat-n19_ami' => {
                             'conlength' => '1021',
                             'subtype' => 'hAT-Ac',
                             'equiv' => [
                                          {
                                            'name' => 'DNA-151_Ami',
                                            'ranges' => [
                                                          {
                                                            'div' => '5.41',
                                                            'score' => '85',
                                                            'eqstart' => '110',
                                                            'eqend' => '288',
                                                            'start' => '290',
                                                            'end' => '474'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '5.60',
                                                            'score' => '52',
                                                            'eqstart' => '170',
                                                            'eqend' => '288',
                                                            'start' => '842',
                                                            'end' => '966'
                                                          },
                                                          {
                                                            'div' => '1.72',
                                                            'score' => '123',
                                                            'eqstart' => '313',
                                                            'eqend' => '490',
                                                            'start' => '1097',
                                                            'end' => '1270'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-197_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '5.13',
                                                            'score' => '30',
                                                            'eqstart' => '1',
                                                            'eqend' => '39',
                                                            'start' => '1022',
                                                            'end' => '1060'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-243_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '2.17',
                                                            'score' => '35',
                                                            'eqstart' => '301',
                                                            'eqend' => '346',
                                                            'start' => '365',
                                                            'end' => '410'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '2.08',
                                                            'score' => '36',
                                                            'eqstart' => '301',
                                                            'eqend' => '348',
                                                            'start' => '904',
                                                            'end' => '951'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-1598_Gav',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '2.72',
                                                            'score' => '70',
                                                            'eqstart' => '782',
                                                            'eqend' => '950',
                                                            'start' => '1022',
                                                            'end' => '1168'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '6.35',
                                                            'score' => '35',
                                                            'eqstart' => '620',
                                                            'eqend' => '684',
                                                            'start' => '1098',
                                                            'end' => '1160'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N17_AMi',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '4.55',
                                                            'score' => '30',
                                                            'eqstart' => '1337',
                                                            'eqend' => '1380',
                                                            'start' => '363',
                                                            'end' => '406'
                                                          },
                                                          {
                                                            'div' => '7.22',
                                                            'score' => '30',
                                                            'eqstart' => '570',
                                                            'eqend' => '662',
                                                            'start' => '718',
                                                            'end' => '814'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N7B_Crp',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '4.49',
                                                            'score' => '31',
                                                            'eqstart' => '757',
                                                            'eqend' => '843',
                                                            'start' => '334',
                                                            'end' => '422'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N10_AMi',
                                            'ranges' => [
                                                          {
                                                            'div' => '6.09',
                                                            'score' => '119',
                                                            'eqstart' => '170',
                                                            'eqend' => '558',
                                                            'start' => '263',
                                                            'end' => '623'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '5.80',
                                                            'score' => '72',
                                                            'eqstart' => '860',
                                                            'eqend' => '1080',
                                                            'start' => '278',
                                                            'end' => '484'
                                                          },
                                                          {
                                                            'div' => '4.62',
                                                            'score' => '35',
                                                            'eqstart' => '657',
                                                            'eqend' => '722',
                                                            'start' => '687',
                                                            'end' => '751'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '5.36',
                                                            'score' => '90',
                                                            'eqstart' => '258',
                                                            'eqend' => '558',
                                                            'start' => '687',
                                                            'end' => '966'
                                                          },
                                                          {
                                                            'div' => '5.73',
                                                            'score' => '35',
                                                            'eqstart' => '860',
                                                            'eqend' => '1082',
                                                            'start' => '832',
                                                            'end' => '1023'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '9.09',
                                                            'score' => '31',
                                                            'eqstart' => '185',
                                                            'eqend' => '239',
                                                            'start' => '967',
                                                            'end' => '1021'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N32_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '2.78',
                                                            'score' => '32',
                                                            'eqstart' => '1',
                                                            'eqend' => '36',
                                                            'start' => '1022',
                                                            'end' => '1057'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-16_Ami',
                                            'ranges' => [
                                                          {
                                                            'div' => '0.00',
                                                            'score' => '38',
                                                            'eqstart' => '1',
                                                            'eqend' => '39',
                                                            'start' => '1022',
                                                            'end' => '1060'
                                                          },
                                                          {
                                                            'div' => '4.21',
                                                            'score' => '54',
                                                            'eqstart' => '71',
                                                            'eqend' => '171',
                                                            'start' => '1071',
                                                            'end' => '1165'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N7_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '3.64',
                                                            'score' => '33',
                                                            'eqstart' => '224',
                                                            'eqend' => '279',
                                                            'start' => '363',
                                                            'end' => '417'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '4.88',
                                                            'score' => '38',
                                                            'eqstart' => '192',
                                                            'eqend' => '277',
                                                            'start' => '900',
                                                            'end' => '981'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N18_AMi',
                                            'ranges' => [
                                                          {
                                                            'div' => '5.13',
                                                            'score' => '30',
                                                            'eqstart' => '1',
                                                            'eqend' => '39',
                                                            'start' => '1022',
                                                            'end' => '1060'
                                                          },
                                                          {
                                                            'div' => '6.56',
                                                            'score' => '31',
                                                            'eqstart' => '123',
                                                            'eqend' => '183',
                                                            'start' => '1098',
                                                            'end' => '1158'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-208_Ami',
                                            'ranges' => [
                                                          {
                                                            'div' => '2.56',
                                                            'score' => '33',
                                                            'eqstart' => '1',
                                                            'eqend' => '39',
                                                            'start' => '1022',
                                                            'end' => '1060'
                                                          },
                                                          {
                                                            'div' => '7.61',
                                                            'score' => '39',
                                                            'eqstart' => '71',
                                                            'eqend' => '168',
                                                            'start' => '1069',
                                                            'end' => '1160'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N21_Crp',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '10.56',
                                                            'score' => '42',
                                                            'eqstart' => '422',
                                                            'eqend' => '587',
                                                            'start' => '702',
                                                            'end' => '862'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '4.84',
                                                            'score' => '39',
                                                            'eqstart' => '1150',
                                                            'eqend' => '1211',
                                                            'start' => '1099',
                                                            'end' => '1160'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N11B_AMi',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '12.40',
                                                            'score' => '36',
                                                            'eqstart' => '991',
                                                            'eqend' => '1120',
                                                            'start' => '454',
                                                            'end' => '582'
                                                          },
                                                          {
                                                            'div' => '4.84',
                                                            'score' => '39',
                                                            'eqstart' => '286',
                                                            'eqend' => '347',
                                                            'start' => '1099',
                                                            'end' => '1160'
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'sola1-1_ac' => {
                            'conlength' => '3590',
                            'subtype' => 'Sola-1',
                            'equiv' => [
                                         {
                                           'name' => 'Kolobok-3_Aplcal',
                                           'ranges' => [
                                                         {
                                                           'div' => '6.94',
                                                           'score' => '30',
                                                           'eqstart' => '4123',
                                                           'eqend' => '4194',
                                                           'start' => '3499',
                                                           'end' => '3570'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'Ginger1-1_AC',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '67',
                                                           'eqstart' => 856,
                                                           'eqend' => 982,
                                                           'start' => 887,
                                                           'end' => 1013
                                                         },
                                                         {
                                                           'div' => '6.59',
                                                           'score' => '45',
                                                           'eqstart' => 856,
                                                           'eqend' => 946,
                                                           'start' => 3496,
                                                           'end' => 3586
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'Sola1-2_AC',
                                           'ranges' => [
                                                         {
                                                           'div' => '2.51',
                                                           'score' => '690',
                                                           'eqstart' => 1,
                                                           'eqend' => 829,
                                                           'start' => 1,
                                                           'end' => 837
                                                         },
                                                         {
                                                           'div' => '1.98',
                                                           'score' => '2171',
                                                           'eqstart' => '826',
                                                           'eqend' => '3386',
                                                           'start' => 1476,
                                                           'end' => 4097
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'harbinger-2n1_xt' => {
                                  'conlength' => '328',
                                  'subtype' => 'PIF-Harbinger',
                                  'equiv' => [
                                               {
                                                 'name' => 'Harbinger-2N1F_XT',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '5.88',
                                                                 'score' => '46',
                                                                 'eqstart' => 1,
                                                                 'eqend' => 69,
                                                                 'start' => 1,
                                                                 'end' => 68
                                                               },
                                                               {
                                                                 'div' => '7.98',
                                                                 'score' => '118',
                                                                 'eqstart' => 244,
                                                                 'eqend' => 432,
                                                                 'start' => 264,
                                                                 'end' => 451
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'Harbinger-N6_XT',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '4.17',
                                                                 'score' => '37',
                                                                 'eqstart' => 38,
                                                                 'eqend' => 85,
                                                                 'start' => 37,
                                                                 'end' => 84
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'Harbinger-2N1G_XT',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '8.57',
                                                                 'score' => '51',
                                                                 'eqstart' => 1,
                                                                 'eqend' => 106,
                                                                 'start' => 1,
                                                                 'end' => 105
                                                               },
                                                               {
                                                                 'div' => '6.06',
                                                                 'score' => '70',
                                                                 'eqstart' => 277,
                                                                 'eqend' => 375,
                                                                 'start' => 353,
                                                                 'end' => 451
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'Harbinger-2N1D_XT',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '8.57',
                                                                 'score' => '53',
                                                                 'eqstart' => 1,
                                                                 'eqend' => 106,
                                                                 'start' => 1,
                                                                 'end' => 105
                                                               },
                                                               {
                                                                 'div' => '9.15',
                                                                 'score' => '95',
                                                                 'eqstart' => 291,
                                                                 'eqend' => 453,
                                                                 'start' => 288,
                                                                 'end' => 451
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'Harbinger-2N1E_XT',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '2.38',
                                                                 'score' => '62',
                                                                 'eqstart' => 1,
                                                                 'eqend' => 85,
                                                                 'start' => 1,
                                                                 'end' => 84
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'Harbinger-2N1B_XT',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '2.38',
                                                                 'score' => '60',
                                                                 'eqstart' => 1,
                                                                 'eqend' => 85,
                                                                 'start' => 1,
                                                                 'end' => 84
                                                               },
                                                               {
                                                                 'div' => '8.54',
                                                                 'score' => '47',
                                                                 'eqstart' => 345,
                                                                 'eqend' => 427,
                                                                 'start' => 370,
                                                                 'end' => 451
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'Harbinger-2N1C_XT',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '9.23',
                                                                 'score' => '34',
                                                                 'eqstart' => 1,
                                                                 'eqend' => 66,
                                                                 'start' => 1,
                                                                 'end' => 65
                                                               },
                                                               {
                                                                 'div' => '7.92',
                                                                 'score' => '59',
                                                                 'eqstart' => 341,
                                                                 'eqend' => 440,
                                                                 'start' => 351,
                                                                 'end' => 451
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'Harbinger-2N1A_XT',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '4.76',
                                                                 'score' => '57',
                                                                 'eqstart' => 1,
                                                                 'eqend' => 105,
                                                                 'start' => 1,
                                                                 'end' => 105
                                                               },
                                                               {
                                                                 'div' => '4.88',
                                                                 'score' => '52',
                                                                 'eqstart' => 321,
                                                                 'eqend' => 402,
                                                                 'start' => 370,
                                                                 'end' => 451
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'Harbinger-N7A_XT',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '5.88',
                                                                 'score' => '31',
                                                                 'eqstart' => 274,
                                                                 'eqend' => 325,
                                                                 'start' => 394,
                                                                 'end' => 444
                                                               }
                                                             ]
                                               }
                                             ],
                                  'type' => 'DNA'
                                },
          'mariner-21n1_cgi' => {
                                  'conlength' => '475',
                                  'subtype' => 'TcMar-m44',
                                  'equiv' => [
                                               {
                                                 'name' => 'Mariner-21N4_CGi',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '9.61',
                                                                 'score' => '126',
                                                                 'eqstart' => '206',
                                                                 'eqend' => '434',
                                                                 'start' => '209',
                                                                 'end' => '437'
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'Mariner-21_CGi',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '8.00',
                                                                 'score' => '32',
                                                                 'eqstart' => '4',
                                                                 'eqend' => '53',
                                                                 'start' => '4',
                                                                 'end' => '53'
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'DNA3-4_CGi',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '12.35',
                                                                 'score' => '105',
                                                                 'eqstart' => '7206',
                                                                 'eqend' => '7616',
                                                                 'start' => '66',
                                                                 'end' => '470'
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'Mariner-21N3_CGi',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '9.09',
                                                                 'score' => '115',
                                                                 'eqstart' => '197',
                                                                 'eqend' => '428',
                                                                 'start' => '207',
                                                                 'end' => '437'
                                                               }
                                                             ]
                                               }
                                             ],
                                  'type' => 'DNA'
                                },
          'hopper2_mm' => {
                            'conlength' => '1593',
                            'subtype' => 'CMC-Transib',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'dna-24_cgi' => {
                            'conlength' => '1747',
                            'subtype' => undef,
                            'equiv' => [
                                         {
                                           'name' => 'DNA-24B_CGi',
                                           'ranges' => [
                                                         {
                                                           'div' => '12.63',
                                                           'score' => '151',
                                                           'eqstart' => '9',
                                                           'eqend' => '387',
                                                           'start' => '9',
                                                           'end' => '388'
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'ttaa2c_ap' => {
                           'conlength' => '423',
                           'subtype' => undef,
                           'equiv' => [
                                        {
                                          'name' => 'TTAA4B_AP',
                                          'ranges' => [
                                                        {
                                                          'compl' => 1,
                                                          'div' => '10.71',
                                                          'score' => '36',
                                                          'eqstart' => 375,
                                                          'eqend' => 430,
                                                          'start' => 1,
                                                          'end' => 56
                                                        },
                                                        {
                                                          'div' => '12.50',
                                                          'score' => '31',
                                                          'eqstart' => 1,
                                                          'eqend' => 56,
                                                          'start' => 1,
                                                          'end' => 56
                                                        },
                                                        {
                                                          'div' => '12.50',
                                                          'score' => '31',
                                                          'eqstart' => 375,
                                                          'eqend' => 430,
                                                          'start' => 368,
                                                          'end' => 423
                                                        }
                                                      ]
                                        },
                                        {
                                          'name' => 'TTAA2_AP',
                                          'ranges' => [
                                                        {
                                                          'div' => '12.27',
                                                          'score' => '162',
                                                          'eqstart' => 21,
                                                          'eqend' => 407,
                                                          'start' => 21,
                                                          'end' => 403
                                                        }
                                                      ]
                                        },
                                        {
                                          'name' => 'TTAA6_AP',
                                          'ranges' => [
                                                        {
                                                          'div' => '8.93',
                                                          'score' => '39',
                                                          'eqstart' => 1,
                                                          'eqend' => 56,
                                                          'start' => 1,
                                                          'end' => 56
                                                        },
                                                        {
                                                          'compl' => 1,
                                                          'div' => '8.93',
                                                          'score' => '34',
                                                          'eqstart' => 375,
                                                          'eqend' => 431,
                                                          'start' => 1,
                                                          'end' => 56
                                                        },
                                                        {
                                                          'compl' => 1,
                                                          'div' => '10.71',
                                                          'score' => '34',
                                                          'eqstart' => 1,
                                                          'eqend' => 56,
                                                          'start' => 368,
                                                          'end' => 423
                                                        }
                                                      ]
                                        },
                                        {
                                          'name' => 'TTAA5_AP',
                                          'ranges' => [
                                                        {
                                                          'div' => '1.92',
                                                          'score' => '49',
                                                          'eqstart' => 1,
                                                          'eqend' => 52,
                                                          'start' => 1,
                                                          'end' => 52
                                                        },
                                                        {
                                                          'compl' => 1,
                                                          'div' => '1.92',
                                                          'score' => '49',
                                                          'eqstart' => 391,
                                                          'eqend' => 442,
                                                          'start' => 1,
                                                          'end' => 52
                                                        },
                                                        {
                                                          'div' => '3.85',
                                                          'score' => '44',
                                                          'eqstart' => 391,
                                                          'eqend' => 442,
                                                          'start' => 372,
                                                          'end' => 423
                                                        },
                                                        {
                                                          'compl' => 1,
                                                          'div' => '3.85',
                                                          'score' => '44',
                                                          'eqstart' => 1,
                                                          'eqend' => 52,
                                                          'start' => 372,
                                                          'end' => 423
                                                        }
                                                      ]
                                        }
                                      ],
                           'type' => 'DNA'
                         },
          'parisa_dam' => {
                            'conlength' => '437',
                            'subtype' => 'TcMar-Tc1',
                            'equiv' => [
                                         {
                                           'name' => 'PARIS',
                                           'ranges' => [
                                                         {
                                                           'div' => '7.78',
                                                           'score' => '268',
                                                           'eqstart' => '673',
                                                           'eqend' => '1110',
                                                           'start' => '1',
                                                           'end' => '437'
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'hat-n2_xt' => {
                           'conlength' => '344',
                           'subtype' => 'hAT-Ac',
                           'equiv' => [
                                        {
                                          'name' => 'hAT-N15_XT',
                                          'ranges' => [
                                                        {
                                                          'compl' => 1,
                                                          'div' => '2.04',
                                                          'score' => '46',
                                                          'eqstart' => 1,
                                                          'eqend' => 49,
                                                          'start' => 296,
                                                          'end' => 344
                                                        }
                                                      ]
                                        },
                                        {
                                          'name' => 'hAT-N2A_XT',
                                          'ranges' => [
                                                        {
                                                          'div' => '8.54',
                                                          'score' => '56',
                                                          'eqstart' => 1,
                                                          'eqend' => 82,
                                                          'start' => 1,
                                                          'end' => 82
                                                        },
                                                        {
                                                          'div' => '4.08',
                                                          'score' => '41',
                                                          'eqstart' => 1232,
                                                          'eqend' => 1280,
                                                          'start' => 296,
                                                          'end' => 344
                                                        }
                                                      ]
                                        },
                                        {
                                          'name' => 'Harbinger-N2_XT',
                                          'ranges' => [
                                                        {
                                                          'div' => '2.78',
                                                          'score' => '33',
                                                          'eqstart' => 479,
                                                          'eqend' => 514,
                                                          'start' => 12,
                                                          'end' => 47
                                                        }
                                                      ]
                                        }
                                      ],
                           'type' => 'DNA'
                         },
          'agap4mite559' => {
                              'conlength' => '559',
                              'subtype' => 'P',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'vandal3' => {
                         'conlength' => '9104',
                         'subtype' => 'MULE-MuDR',
                         'equiv' => [
                                      {
                                        'name' => 'ATMU8',
                                        'ranges' => [
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '31',
                                                        'eqstart' => 3795,
                                                        'eqend' => 3826,
                                                        'start' => 7392,
                                                        'end' => 7423
                                                      }
                                                    ]
                                      }
                                    ],
                         'type' => 'DNA'
                       },
          'othermites_ele11' => {
                                  'conlength' => '669',
                                  'subtype' => 'hAT-hATm',
                                  'equiv' => [
                                               {
                                                 'name' => 'DNA3-1_AAe',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '12.97',
                                                                 'score' => '91',
                                                                 'eqstart' => '2302',
                                                                 'eqend' => '2486',
                                                                 'start' => '477',
                                                                 'end' => '661'
                                                               }
                                                             ]
                                               }
                                             ],
                                  'type' => 'DNA'
                                },
          'mariner-31_sm' => {
                               'conlength' => '2296',
                               'subtype' => 'TcMar-Tigger',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'hat-2_dk' => {
                          'conlength' => '2474',
                          'subtype' => 'hAT-Ac',
                          'equiv' => [],
                          'type' => 'DNA'
                        },
          'mariner-30n1_cgi' => {
                                  'conlength' => '219',
                                  'subtype' => 'TcMar-Tc2',
                                  'equiv' => [
                                               {
                                                 'name' => 'Mariner-30_CGi',
                                                 'ranges' => [
                                                               {
                                                                 'compl' => 1,
                                                                 'div' => '6.74',
                                                                 'score' => '61',
                                                                 'eqstart' => '2107',
                                                                 'eqend' => '2195',
                                                                 'start' => '1',
                                                                 'end' => '89'
                                                               },
                                                               {
                                                                 'compl' => 1,
                                                                 'div' => '2.27',
                                                                 'score' => '40',
                                                                 'eqstart' => '1',
                                                                 'eqend' => '44',
                                                                 'start' => '176',
                                                                 'end' => '219'
                                                               }
                                                             ]
                                               }
                                             ],
                                  'type' => 'DNA'
                                },
          'tir21t5a_ce' => {
                             'conlength' => '166',
                             'subtype' => undef,
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'mariner-12_df' => {
                               'conlength' => '1662',
                               'subtype' => 'TcMar-Tc1',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'piggybac-1_xt' => {
                               'conlength' => '5451',
                               'subtype' => 'PiggyBac',
                               'equiv' => [
                                            {
                                              'name' => 'piggyBac-1N1_XT',
                                              'ranges' => [
                                                            {
                                                              'div' => '5.89',
                                                              'score' => '361',
                                                              'eqstart' => 54,
                                                              'eqend' => 759,
                                                              'start' => 8,
                                                              'end' => 720
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '2.04',
                                                              'score' => '33',
                                                              'eqstart' => 97,
                                                              'eqend' => 145,
                                                              'start' => 48,
                                                              'end' => 96
                                                            },
                                                            {
                                                              'div' => '11.29',
                                                              'score' => '185',
                                                              'eqstart' => '1153',
                                                              'eqend' => '1688',
                                                              'start' => 4621,
                                                              'end' => '5169'
                                                            },
                                                            {
                                                              'div' => '6.90',
                                                              'score' => '328',
                                                              'eqstart' => 1687,
                                                              'eqend' => 2421,
                                                              'start' => 4742,
                                                              'end' => 5451
                                                            },
                                                            {
                                                              'div' => '2.59',
                                                              'score' => '1023',
                                                              'eqstart' => 2328,
                                                              'eqend' => 3531,
                                                              'start' => 4974,
                                                              'end' => 6169
                                                            },
                                                            {
                                                              'div' => '1.50',
                                                              'score' => '350',
                                                              'eqstart' => 1131,
                                                              'eqend' => 1584,
                                                              'start' => 4984,
                                                              'end' => 5451
                                                            },
                                                            {
                                                              'div' => '0.00',
                                                              'score' => '58',
                                                              'eqstart' => 882,
                                                              'eqend' => 950,
                                                              'start' => 5050,
                                                              'end' => 5117
                                                            },
                                                            {
                                                              'div' => '1.85',
                                                              'score' => '290',
                                                              'eqstart' => 1687,
                                                              'eqend' => 2012,
                                                              'start' => 5127,
                                                              'end' => 5451
                                                            },
                                                            {
                                                              'div' => '3.54',
                                                              'score' => '69',
                                                              'eqstart' => 992,
                                                              'eqend' => 1102,
                                                              'start' => 5195,
                                                              'end' => 5307
                                                            },
                                                            {
                                                              'div' => '1.19',
                                                              'score' => '72',
                                                              'eqstart' => 1131,
                                                              'eqend' => 1213,
                                                              'start' => 5368,
                                                              'end' => 5451
                                                            }
                                                          ]
                                            }
                                          ],
                               'type' => 'DNA'
                             },
          'mer131' => {
                        'conlength' => '215',
                        'subtype' => undef,
                        'equiv' => [],
                        'type' => 'DNA'
                      },
          'chap1_xt' => {
                          'conlength' => '291',
                          'subtype' => 'hAT-Charlie',
                          'equiv' => [
                                       {
                                         'name' => 'hAT-11_XT',
                                         'ranges' => [
                                                       {
                                                         'div' => '7.41',
                                                         'score' => '57',
                                                         'eqstart' => 1,
                                                         'eqend' => 81,
                                                         'start' => 1,
                                                         'end' => 81
                                                       },
                                                       {
                                                         'div' => '2.44',
                                                         'score' => '73',
                                                         'eqstart' => 2803,
                                                         'eqend' => 2884,
                                                         'start' => 367,
                                                         'end' => 448
                                                       }
                                                     ]
                                       }
                                     ],
                          'type' => 'DNA'
                        },
          'dna8-98_ap' => {
                            'conlength' => '796',
                            'subtype' => 'hAT-hAT19',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'tc1-1_tca' => {
                           'conlength' => '1630',
                           'subtype' => 'TcMar-Tc1',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'mariner34_cb' => {
                              'conlength' => '1292',
                              'subtype' => 'TcMar-Tc1',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'dna-6_nv' => {
                          'conlength' => '320',
                          'subtype' => undef,
                          'equiv' => [],
                          'type' => 'DNA'
                        },
          'dna9-3_fv' => {
                           'conlength' => '710',
                           'subtype' => undef,
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'hat-16_hm' => {
                           'conlength' => '3529',
                           'subtype' => 'hAT-Tip100',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'dna-ttaa0-7_dr' => {
                                'conlength' => '1255',
                                'subtype' => undef,
                                'equiv' => [],
                                'type' => 'DNA'
                              },
          'dna8-4b_dr' => {
                            'conlength' => '321',
                            'subtype' => 'hAT-Charlie',
                            'equiv' => [
                                         {
                                           'name' => 'DNA8-4A_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '73',
                                                           'eqstart' => 6,
                                                           'eqend' => 78,
                                                           'start' => 1,
                                                           'end' => 73
                                                         },
                                                         {
                                                           'div' => '5.88',
                                                           'score' => '105',
                                                           'eqstart' => 774,
                                                           'eqend' => 924,
                                                           'start' => 169,
                                                           'end' => 321
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA8-4_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '4.11',
                                                           'score' => '64',
                                                           'eqstart' => 1,
                                                           'eqend' => 73,
                                                           'start' => 1,
                                                           'end' => 73
                                                         },
                                                         {
                                                           'div' => '4.55',
                                                           'score' => '54',
                                                           'eqstart' => 2330,
                                                           'eqend' => 2395,
                                                           'start' => 256,
                                                           'end' => 321
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N78_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '306',
                                                           'eqstart' => 1,
                                                           'eqend' => 319,
                                                           'start' => 1,
                                                           'end' => 321
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'rcharr1' => {
                         'conlength' => '974',
                         'subtype' => 'hAT-Charlie',
                         'equiv' => [],
                         'type' => 'DNA'
                       },
          'cryptons-15_pi' => {
                                'conlength' => '3008',
                                'subtype' => 'Crypton-S',
                                'equiv' => [],
                                'type' => 'DNA'
                              },
          'dna-ta-1_df' => {
                             'conlength' => '184',
                             'subtype' => 'TcMar-Tigger',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'crypton-n2_cgi' => {
                                'conlength' => '579',
                                'subtype' => 'Crypton',
                                'equiv' => [
                                             {
                                               'name' => 'Crypton-N4_CGi',
                                               'ranges' => [
                                                             {
                                                               'div' => '4.55',
                                                               'score' => '49',
                                                               'eqstart' => '1',
                                                               'eqend' => '66',
                                                               'start' => '1',
                                                               'end' => '66'
                                                             },
                                                             {
                                                               'div' => '4.88',
                                                               'score' => '32',
                                                               'eqstart' => '337',
                                                               'eqend' => '377',
                                                               'start' => '481',
                                                               'end' => '521'
                                                             }
                                                           ]
                                             },
                                             {
                                               'name' => 'Crypton-N9_CGi',
                                               'ranges' => [
                                                             {
                                                               'div' => '4.88',
                                                               'score' => '32',
                                                               'eqstart' => '349',
                                                               'eqend' => '389',
                                                               'start' => '481',
                                                               'end' => '521'
                                                             }
                                                           ]
                                             }
                                           ],
                                'type' => 'DNA'
                              },
          'dna-7-13_nv' => {
                             'conlength' => '361',
                             'subtype' => undef,
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'vandal5a' => {
                          'conlength' => '6037',
                          'subtype' => 'MULE-MuDR',
                          'equiv' => [
                                       {
                                         'name' => 'Vandal4',
                                         'ranges' => [
                                                       {
                                                         'div' => '11.43',
                                                         'score' => '49',
                                                         'eqstart' => 3330,
                                                         'eqend' => 3434,
                                                         'start' => 4966,
                                                         'end' => 5070
                                                       }
                                                     ]
                                       },
                                       {
                                         'name' => 'Vandal5',
                                         'ranges' => [
                                                       {
                                                         'div' => '8.51',
                                                         'score' => '32',
                                                         'eqstart' => 236,
                                                         'eqend' => 282,
                                                         'start' => 237,
                                                         'end' => 283
                                                       },
                                                       {
                                                         'div' => '3.92',
                                                         'score' => '367',
                                                         'eqstart' => 1060,
                                                         'eqend' => 1697,
                                                         'start' => 1301,
                                                         'end' => 1912
                                                       },
                                                       {
                                                         'div' => '1.76',
                                                         'score' => '2689',
                                                         'eqstart' => 1700,
                                                         'eqend' => 4822,
                                                         'start' => 2364,
                                                         'end' => 5482
                                                       },
                                                       {
                                                         'div' => '8.96',
                                                         'score' => '48',
                                                         'eqstart' => 4693,
                                                         'eqend' => 4822,
                                                         'start' => 5030,
                                                         'end' => 5163
                                                       },
                                                       {
                                                         'div' => '5.63',
                                                         'score' => '460',
                                                         'eqstart' => 4370,
                                                         'eqend' => 5100,
                                                         'start' => 5353,
                                                         'end' => 6080
                                                       },
                                                       {
                                                         'div' => '10.87',
                                                         'score' => '38',
                                                         'eqstart' => 4966,
                                                         'eqend' => 5057,
                                                         'start' => 5585,
                                                         'end' => 5676
                                                       },
                                                       {
                                                         'div' => '9.23',
                                                         'score' => '45',
                                                         'eqstart' => 4370,
                                                         'eqend' => 4501,
                                                         'start' => 5673,
                                                         'end' => 5802
                                                       },
                                                       {
                                                         'div' => '3.02',
                                                         'score' => '346',
                                                         'eqstart' => 13686,
                                                         'eqend' => 14083,
                                                         'start' => 6084,
                                                         'end' => 6481
                                                       },
                                                       {
                                                         'div' => '4.09',
                                                         'score' => '443',
                                                         'eqstart' => 14162,
                                                         'eqend' => 14724,
                                                         'start' => 6361,
                                                         'end' => 6923
                                                       },
                                                       {
                                                         'div' => '11.33',
                                                         'score' => '77',
                                                         'eqstart' => 14904,
                                                         'eqend' => 15110,
                                                         'start' => 6557,
                                                         'end' => 6759
                                                       },
                                                       {
                                                         'div' => '11.97',
                                                         'score' => '56',
                                                         'eqstart' => 13696,
                                                         'eqend' => 13812,
                                                         'start' => 6807,
                                                         'end' => 6923
                                                       },
                                                       {
                                                         'div' => '3.37',
                                                         'score' => '635',
                                                         'eqstart' => 16965,
                                                         'eqend' => 17762,
                                                         'start' => 6922,
                                                         'end' => 7723
                                                       }
                                                     ]
                                       },
                                       {
                                         'name' => 'ATDNA1T9A',
                                         'ranges' => [
                                                       {
                                                         'div' => '6.12',
                                                         'score' => '35',
                                                         'eqstart' => 1757,
                                                         'eqend' => 1805,
                                                         'start' => 717,
                                                         'end' => 765
                                                       },
                                                       {
                                                         'div' => '12.64',
                                                         'score' => '33',
                                                         'eqstart' => 1718,
                                                         'eqend' => 1805,
                                                         'start' => 895,
                                                         'end' => 981
                                                       },
                                                       {
                                                         'div' => '11.76',
                                                         'score' => '36',
                                                         'eqstart' => 1738,
                                                         'eqend' => 1805,
                                                         'start' => 1130,
                                                         'end' => 1197
                                                       }
                                                     ]
                                       },
                                       {
                                         'name' => 'ATDNAI27T9A',
                                         'ranges' => [
                                                       {
                                                         'div' => '5.19',
                                                         'score' => '60',
                                                         'eqstart' => 1,
                                                         'eqend' => 77,
                                                         'start' => 1,
                                                         'end' => 77
                                                       }
                                                     ]
                                       },
                                       {
                                         'name' => 'ATDNAI27T9B',
                                         'ranges' => [
                                                       {
                                                         'div' => '7.79',
                                                         'score' => '54',
                                                         'eqstart' => 1,
                                                         'eqend' => 77,
                                                         'start' => 1,
                                                         'end' => 77
                                                       }
                                                     ]
                                       }
                                     ],
                          'type' => 'DNA'
                        },
          'harbinger-1d_crp' => {
                                  'conlength' => '3975',
                                  'subtype' => 'PIF-Harbinger',
                                  'equiv' => [
                                               {
                                                 'name' => 'Harbinger-3_AMi',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '6.25',
                                                                 'score' => '42',
                                                                 'eqstart' => '4621',
                                                                 'eqend' => '4684',
                                                                 'start' => '3440',
                                                                 'end' => '3503'
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'Harbinger-1_Crp',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '9.38',
                                                                 'score' => '34',
                                                                 'eqstart' => '4562',
                                                                 'eqend' => '4625',
                                                                 'start' => '3440',
                                                                 'end' => '3503'
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'Harbinger-1C_Crp',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '9.95',
                                                                 'score' => '610',
                                                                 'eqstart' => '746',
                                                                 'eqend' => '1884',
                                                                 'start' => '1',
                                                                 'end' => '1146'
                                                               },
                                                               {
                                                                 'div' => '10.67',
                                                                 'score' => '87',
                                                                 'eqstart' => '2690',
                                                                 'eqend' => '2901',
                                                                 'start' => '1575',
                                                                 'end' => '1799'
                                                               },
                                                               {
                                                                 'div' => '4.65',
                                                                 'score' => '36',
                                                                 'eqstart' => '2935',
                                                                 'eqend' => '2977',
                                                                 'start' => '1831',
                                                                 'end' => '1873'
                                                               }
                                                             ]
                                               }
                                             ],
                                  'type' => 'DNA'
                                },
          'pot2' => {
                      'conlength' => '1861',
                      'subtype' => 'TcMar-Fot1',
                      'equiv' => [],
                      'type' => 'DNA'
                    },
          'avpb1' => {
                       'conlength' => '1822',
                       'subtype' => 'PiggyBac',
                       'equiv' => [],
                       'type' => 'DNA'
                     },
          'mer75' => {
                       'conlength' => '514',
                       'subtype' => 'PiggyBac',
                       'equiv' => [
                                    {
                                      'name' => 'MER75B',
                                      'ranges' => [
                                                    {
                                                      'div' => '0.00',
                                                      'score' => '151',
                                                      'eqstart' => 88,
                                                      'eqend' => 243,
                                                      'start' => 359,
                                                      'end' => 514
                                                    }
                                                  ]
                                    },
                                    {
                                      'name' => 'MER75A',
                                      'ranges' => [
                                                    {
                                                      'div' => '0.00',
                                                      'score' => '36',
                                                      'eqstart' => 31,
                                                      'eqend' => 71,
                                                      'start' => 469,
                                                      'end' => 510
                                                    }
                                                  ]
                                    }
                                  ],
                       'type' => 'DNA'
                     },
          'atenspm10' => {
                           'conlength' => '8272',
                           'subtype' => 'CMC-EnSpm',
                           'equiv' => [
                                        {
                                          'name' => 'ATENSPM11',
                                          'ranges' => [
                                                        {
                                                          'div' => '5.26',
                                                          'score' => '30',
                                                          'eqstart' => '3008',
                                                          'eqend' => '3045',
                                                          'start' => 2923,
                                                          'end' => '2960'
                                                        },
                                                        {
                                                          'div' => '12.50',
                                                          'score' => '40',
                                                          'eqstart' => 6072,
                                                          'eqend' => 6159,
                                                          'start' => 6107,
                                                          'end' => 6194
                                                        }
                                                      ]
                                        }
                                      ],
                           'type' => 'DNA'
                         },
          'mu1_zm' => {
                        'conlength' => '1390',
                        'subtype' => 'MULE-MuDR',
                        'equiv' => [
                                     {
                                       'name' => 'MU4_ZM',
                                       'ranges' => [
                                                     {
                                                       'div' => '11.16',
                                                       'score' => '125',
                                                       'eqstart' => 101,
                                                       'eqend' => 315,
                                                       'start' => 14,
                                                       'end' => 228
                                                     },
                                                     {
                                                       'compl' => 1,
                                                       'div' => '10.70',
                                                       'score' => '124',
                                                       'eqstart' => 1901,
                                                       'eqend' => 2115,
                                                       'start' => 14,
                                                       'end' => 228
                                                     }
                                                   ]
                                     }
                                   ],
                        'type' => 'DNA'
                      },
          'mariner-9_hm' => {
                              'conlength' => '3542',
                              'subtype' => 'TcMar-Fot1',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'hat-14_mad' => {
                            'conlength' => '3554',
                            'subtype' => 'hAT-Tip100',
                            'equiv' => [
                                         {
                                           'name' => 'HAT-5_Mad',
                                           'ranges' => [
                                                         {
                                                           'div' => '10.39',
                                                           'score' => '46',
                                                           'eqstart' => '3179',
                                                           'eqend' => '3255',
                                                           'start' => '3080',
                                                           'end' => '3156'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'HAT-N16_Mad',
                                           'ranges' => [
                                                         {
                                                           'div' => '8.33',
                                                           'score' => '45',
                                                           'eqstart' => '511',
                                                           'eqend' => '570',
                                                           'start' => '3495',
                                                           'end' => '3554'
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'p-36_hma' => {
                          'conlength' => '3256',
                          'subtype' => 'P',
                          'equiv' => [],
                          'type' => 'DNA'
                        },
          'mariner-n7130_gav' => {
                                   'conlength' => '211',
                                   'subtype' => 'TcMar-Mariner',
                                   'equiv' => [
                                                {
                                                  'name' => 'Mariner-5_Crp',
                                                  'ranges' => [
                                                                {
                                                                  'compl' => 1,
                                                                  'div' => '3.77',
                                                                  'score' => '43',
                                                                  'eqstart' => '1242',
                                                                  'eqend' => '1294',
                                                                  'start' => '1',
                                                                  'end' => '53'
                                                                },
                                                                {
                                                                  'div' => '3.17',
                                                                  'score' => '57',
                                                                  'eqstart' => '43',
                                                                  'eqend' => '105',
                                                                  'start' => '56',
                                                                  'end' => '118'
                                                                },
                                                                {
                                                                  'div' => '2.17',
                                                                  'score' => '83',
                                                                  'eqstart' => '1203',
                                                                  'eqend' => '1294',
                                                                  'start' => '120',
                                                                  'end' => '211'
                                                                }
                                                              ]
                                                }
                                              ],
                                   'type' => 'DNA'
                                 },
          'hat-17_mad' => {
                            'conlength' => '4487',
                            'subtype' => 'hAT-Tag1',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'mudr-5_epa' => {
                            'conlength' => '4912',
                            'subtype' => 'MULE-MuDR',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'hat-n1b_md' => {
                            'conlength' => '335',
                            'subtype' => 'hAT-Tip100',
                            'equiv' => [
                                         {
                                           'name' => 'hAT-N1_MD',
                                           'ranges' => [
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '71',
                                                           'eqstart' => 141,
                                                           'eqend' => 220,
                                                           'start' => 81,
                                                           'end' => 159
                                                         },
                                                         {
                                                           'div' => '9.32',
                                                           'score' => '65',
                                                           'eqstart' => 378,
                                                           'eqend' => 495,
                                                           'start' => 218,
                                                           'end' => 335
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'puntrip_nc' => {
                            'conlength' => '1874',
                            'subtype' => 'TcMar-Fot1',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'hat-n16_mad' => {
                             'conlength' => '570',
                             'subtype' => 'hAT-Tip100',
                             'equiv' => [
                                          {
                                            'name' => 'HAT-14_Mad',
                                            'ranges' => [
                                                          {
                                                            'div' => '8.33',
                                                            'score' => '45',
                                                            'eqstart' => '3495',
                                                            'eqend' => '3554',
                                                            'start' => '511',
                                                            'end' => '570'
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'dna-12_crp' => {
                            'conlength' => '326',
                            'subtype' => undef,
                            'equiv' => [
                                         {
                                           'name' => 'UCON99',
                                           'ranges' => [
                                                         {
                                                           'div' => '7.17',
                                                           'score' => '142',
                                                           'eqstart' => '1',
                                                           'eqend' => '318',
                                                           'start' => '11',
                                                           'end' => '317'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '8.47',
                                                           'score' => '97',
                                                           'eqstart' => '54',
                                                           'eqend' => '371',
                                                           'start' => '11',
                                                           'end' => '317'
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'RC?'
                          },
          'aeherves2' => {
                           'conlength' => '2855',
                           'subtype' => 'hAT-Ac',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'athos_tm' => {
                          'conlength' => '82',
                          'subtype' => 'TcMar-Stowaway',
                          'equiv' => [],
                          'type' => 'DNA'
                        },
          'arnoldy2' => {
                          'conlength' => '892',
                          'subtype' => 'MULE-MuDR',
                          'equiv' => [
                                       {
                                         'name' => 'ArnoldY1',
                                         'ranges' => [
                                                       {
                                                         'div' => '3.56',
                                                         'score' => '186',
                                                         'eqstart' => 1,
                                                         'eqend' => 572,
                                                         'start' => 1,
                                                         'end' => 562
                                                       },
                                                       {
                                                         'compl' => 1,
                                                         'div' => '2.20',
                                                         'score' => '70',
                                                         'eqstart' => 829,
                                                         'eqend' => 919,
                                                         'start' => 271,
                                                         'end' => 361
                                                       },
                                                       {
                                                         'div' => '4.00',
                                                         'score' => '42',
                                                         'eqstart' => 509,
                                                         'eqend' => 583,
                                                         'start' => 275,
                                                         'end' => 349
                                                       },
                                                       {
                                                         'div' => '4.40',
                                                         'score' => '72',
                                                         'eqstart' => 368,
                                                         'eqend' => 568,
                                                         'start' => 281,
                                                         'end' => 462
                                                       },
                                                       {
                                                         'compl' => 1,
                                                         'div' => '2.33',
                                                         'score' => '61',
                                                         'eqstart' => 831,
                                                         'eqend' => 915,
                                                         'start' => 339,
                                                         'end' => 424
                                                       },
                                                       {
                                                         'div' => '4.97',
                                                         'score' => '117',
                                                         'eqstart' => 343,
                                                         'eqend' => 625,
                                                         'start' => 479,
                                                         'end' => 780
                                                       },
                                                       {
                                                         'div' => '11.00',
                                                         'score' => '52',
                                                         'eqstart' => 376,
                                                         'eqend' => 574,
                                                         'start' => 480,
                                                         'end' => 679
                                                       },
                                                       {
                                                         'compl' => 1,
                                                         'div' => '4.82',
                                                         'score' => '54',
                                                         'eqstart' => 831,
                                                         'eqend' => 913,
                                                         'start' => 500,
                                                         'end' => 582
                                                       },
                                                       {
                                                         'compl' => 1,
                                                         'div' => '6.82',
                                                         'score' => '48',
                                                         'eqstart' => 827,
                                                         'eqend' => 915,
                                                         'start' => 530,
                                                         'end' => 617
                                                       },
                                                       {
                                                         'div' => '8.54',
                                                         'score' => '36',
                                                         'eqstart' => 831,
                                                         'eqend' => 913,
                                                         'start' => 747,
                                                         'end' => 828
                                                       },
                                                       {
                                                         'compl' => 1,
                                                         'div' => '7.36',
                                                         'score' => '73',
                                                         'eqstart' => 301,
                                                         'eqend' => 474,
                                                         'start' => 750,
                                                         'end' => 912
                                                       },
                                                       {
                                                         'compl' => 1,
                                                         'div' => '8.47',
                                                         'score' => '56',
                                                         'eqstart' => 368,
                                                         'eqend' => 484,
                                                         'start' => 771,
                                                         'end' => 888
                                                       },
                                                       {
                                                         'div' => '4.35',
                                                         'score' => '64',
                                                         'eqstart' => 828,
                                                         'eqend' => 919,
                                                         'start' => 807,
                                                         'end' => 898
                                                       },
                                                       {
                                                         'div' => '4.26',
                                                         'score' => '52',
                                                         'eqstart' => 1613,
                                                         'eqend' => 1706,
                                                         'start' => 907,
                                                         'end' => 1000
                                                       },
                                                       {
                                                         'div' => '3.76',
                                                         'score' => '170',
                                                         'eqstart' => 1724,
                                                         'eqend' => 1936,
                                                         'start' => 967,
                                                         'end' => 1179
                                                       }
                                                     ]
                                       }
                                     ],
                          'type' => 'DNA'
                        },
          'mudr-3_vv' => {
                           'conlength' => '9276',
                           'subtype' => 'MULE-MuDR',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'cheshire-2_md' => {
                               'conlength' => '1372',
                               'subtype' => 'hAT-Charlie',
                               'equiv' => [
                                            {
                                              'name' => 'Cheshire_Mars',
                                              'ranges' => [
                                                            {
                                                              'div' => '5.90',
                                                              'score' => '230',
                                                              'eqstart' => 1,
                                                              'eqend' => 443,
                                                              'start' => 1,
                                                              'end' => 424
                                                            },
                                                            {
                                                              'div' => '2.75',
                                                              'score' => '695',
                                                              'eqstart' => 1449,
                                                              'eqend' => 2404,
                                                              'start' => 427,
                                                              'end' => 1372
                                                            }
                                                          ]
                                            },
                                            {
                                              'name' => 'Cheshire_Mars_',
                                              'ranges' => [
                                                            {
                                                              'div' => '3.64',
                                                              'score' => '903',
                                                              'eqstart' => 1,
                                                              'eqend' => 1393,
                                                              'start' => 1,
                                                              'end' => 1372
                                                            }
                                                          ]
                                            }
                                          ],
                               'type' => 'DNA'
                             },
          'dna-8-1_cr' => {
                            'conlength' => '3539',
                            'subtype' => 'P',
                            'equiv' => [
                                         {
                                           'name' => 'DNA-8-2_CR',
                                           'ranges' => [
                                                         {
                                                           'div' => '5.19',
                                                           'score' => '52',
                                                           'eqstart' => 1,
                                                           'eqend' => 78,
                                                           'start' => 1,
                                                           'end' => 77
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '5.19',
                                                           'score' => '53',
                                                           'eqstart' => 2349,
                                                           'eqend' => 2426,
                                                           'start' => 1,
                                                           'end' => 77
                                                         },
                                                         {
                                                           'div' => '5.19',
                                                           'score' => '53',
                                                           'eqstart' => 2349,
                                                           'eqend' => 2426,
                                                           'start' => 3463,
                                                           'end' => 3539
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '5.19',
                                                           'score' => '52',
                                                           'eqstart' => 1,
                                                           'eqend' => 78,
                                                           'start' => 3463,
                                                           'end' => 3539
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'P-1_CR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '4.86',
                                                           'score' => '112',
                                                           'eqstart' => 9667,
                                                           'eqend' => 9810,
                                                           'start' => 1,
                                                           'end' => 144
                                                         },
                                                         {
                                                           'div' => '4.75',
                                                           'score' => '1042',
                                                           'eqstart' => 1,
                                                           'eqend' => 1286,
                                                           'start' => 1,
                                                           'end' => 1285
                                                         },
                                                         {
                                                           'div' => '6.33',
                                                           'score' => '453',
                                                           'eqstart' => 1388,
                                                           'eqend' => 2048,
                                                           'start' => 1292,
                                                           'end' => 1954
                                                         },
                                                         {
                                                           'div' => '8.03',
                                                           'score' => '526',
                                                           'eqstart' => 8196,
                                                           'eqend' => 9810,
                                                           'start' => 1958,
                                                           'end' => 3539
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '4.86',
                                                           'score' => '112',
                                                           'eqstart' => 1,
                                                           'eqend' => 144,
                                                           'start' => 3396,
                                                           'end' => 3539
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'zator-1_lgigantea' => {
                                   'conlength' => '3221',
                                   'subtype' => 'Zator',
                                   'equiv' => [],
                                   'type' => 'DNA'
                                 },
          'belus_tm' => {
                          'conlength' => '177',
                          'subtype' => undef,
                          'equiv' => [],
                          'type' => 'DNA'
                        },
          'hat-20_zm' => {
                           'conlength' => '3771',
                           'subtype' => 'hAT-Ac',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'piggybac6_cb' => {
                              'conlength' => '478',
                              'subtype' => 'PiggyBac',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'cryptons-23_pi' => {
                                'conlength' => '2901',
                                'subtype' => 'Crypton-S',
                                'equiv' => [
                                             {
                                               'name' => 'CryptonS-22_PI',
                                               'ranges' => [
                                                             {
                                                               'div' => '5.56',
                                                               'score' => '54',
                                                               'eqstart' => '2947',
                                                               'eqend' => '3018',
                                                               'start' => '2586',
                                                               'end' => '2657'
                                                             },
                                                             {
                                                               'div' => '8.96',
                                                               'score' => '65',
                                                               'eqstart' => '3142',
                                                               'eqend' => '3285',
                                                               'start' => '2768',
                                                               'end' => '2901'
                                                             }
                                                           ]
                                             }
                                           ],
                                'type' => 'DNA'
                              },
          'hat-n53_dr' => {
                            'conlength' => '2796',
                            'subtype' => 'hAT-Ac',
                            'equiv' => [
                                         {
                                           'name' => 'hAT-N44_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '11.11',
                                                           'score' => '34',
                                                           'eqstart' => 83,
                                                           'eqend' => 188,
                                                           'start' => 4780,
                                                           'end' => 4878
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'Polinton-1_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '1.92',
                                                           'score' => '36',
                                                           'eqstart' => 17123,
                                                           'eqend' => 17174,
                                                           'start' => 2771,
                                                           'end' => 2822
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-4-3_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '6.21',
                                                           'score' => '237',
                                                           'eqstart' => 2,
                                                           'eqend' => 337,
                                                           'start' => 2032,
                                                           'end' => 2369
                                                         },
                                                         {
                                                           'div' => '6.50',
                                                           'score' => '131',
                                                           'eqstart' => 491,
                                                           'eqend' => 693,
                                                           'start' => 2375,
                                                           'end' => 2574
                                                         },
                                                         {
                                                           'div' => '6.38',
                                                           'score' => '32',
                                                           'eqstart' => 1012,
                                                           'eqend' => 1058,
                                                           'start' => 4723,
                                                           'end' => 4769
                                                         },
                                                         {
                                                           'div' => '10.00',
                                                           'score' => '197',
                                                           'eqstart' => 1054,
                                                           'eqend' => 1421,
                                                           'start' => 4780,
                                                           'end' => 5139
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'ENSPM-6_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '8.48',
                                                           'score' => '142',
                                                           'eqstart' => 13972,
                                                           'eqend' => 14300,
                                                           'start' => 2778,
                                                           'end' => 3119
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '0.00',
                                                           'score' => '30',
                                                           'eqstart' => 14851,
                                                           'eqend' => 14897,
                                                           'start' => 2778,
                                                           'end' => 2824
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '9.45',
                                                           'score' => '121',
                                                           'eqstart' => 14585,
                                                           'eqend' => 14840,
                                                           'start' => 2867,
                                                           'end' => 3120
                                                         },
                                                         {
                                                           'div' => '9.13',
                                                           'score' => '108',
                                                           'eqstart' => 21500,
                                                           'eqend' => 21715,
                                                           'start' => 2916,
                                                           'end' => 3134
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'TDR18',
                                           'ranges' => [
                                                         {
                                                           'div' => '5.57',
                                                           'score' => '213',
                                                           'eqstart' => 10,
                                                           'eqend' => '318',
                                                           'start' => 2830,
                                                           'end' => 3134
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'Dada-tL_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '10.49',
                                                           'score' => '124',
                                                           'eqstart' => '2055',
                                                           'eqend' => '2324',
                                                           'start' => '2868',
                                                           'end' => '3134'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-5-1_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '7.20',
                                                           'score' => '87',
                                                           'eqstart' => 1,
                                                           'eqend' => 125,
                                                           'start' => 2629,
                                                           'end' => 2753
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA8-1_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '8.51',
                                                           'score' => '31',
                                                           'eqstart' => 662,
                                                           'eqend' => 708,
                                                           'start' => 797,
                                                           'end' => 843
                                                         },
                                                         {
                                                           'div' => '6.67',
                                                           'score' => '79',
                                                           'eqstart' => 727,
                                                           'eqend' => 904,
                                                           'start' => 844,
                                                           'end' => 1023
                                                         },
                                                         {
                                                           'div' => '7.42',
                                                           'score' => '138',
                                                           'eqstart' => 928,
                                                           'eqend' => 1174,
                                                           'start' => 1359,
                                                           'end' => 1614
                                                         },
                                                         {
                                                           'div' => '7.59',
                                                           'score' => '59',
                                                           'eqstart' => 1198,
                                                           'eqend' => 1365,
                                                           'start' => 1670,
                                                           'end' => 1827
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'EnSpm-6N1_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '6.61',
                                                           'score' => '112',
                                                           'eqstart' => 1186,
                                                           'eqend' => 1450,
                                                           'start' => 2989,
                                                           'end' => 3245
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-X-13_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '10.36',
                                                           'score' => '48',
                                                           'eqstart' => 221,
                                                           'eqend' => 407,
                                                           'start' => 2382,
                                                           'end' => 2574
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N21_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '11.70',
                                                           'score' => '32',
                                                           'eqstart' => '819',
                                                           'eqend' => '913',
                                                           'start' => '2919',
                                                           'end' => '3012'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-5-8_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '4.86',
                                                           'score' => '83',
                                                           'eqstart' => 822,
                                                           'eqend' => 960,
                                                           'start' => 1373,
                                                           'end' => 1516
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '9.28',
                                                           'score' => '53',
                                                           'eqstart' => 604,
                                                           'eqend' => 804,
                                                           'start' => 1645,
                                                           'end' => 1838
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'stowaway46_os' => {
                               'conlength' => '154',
                               'subtype' => 'TcMar-Stowaway',
                               'equiv' => [
                                            {
                                              'name' => 'STOWAWAY15-2_OS',
                                              'ranges' => [
                                                            {
                                                              'div' => '10.00',
                                                              'score' => '69',
                                                              'eqstart' => 1,
                                                              'eqend' => 145,
                                                              'start' => 3,
                                                              'end' => 152
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '10.67',
                                                              'score' => '69',
                                                              'eqstart' => 1,
                                                              'eqend' => 145,
                                                              'start' => 3,
                                                              'end' => 152
                                                            }
                                                          ]
                                            },
                                            {
                                              'name' => 'STOWAWAY47_OS',
                                              'ranges' => [
                                                            {
                                                              'compl' => 1,
                                                              'div' => '9.24',
                                                              'score' => '39',
                                                              'eqstart' => 36,
                                                              'eqend' => 148,
                                                              'start' => 1,
                                                              'end' => 119
                                                            },
                                                            {
                                                              'div' => '9.24',
                                                              'score' => '38',
                                                              'eqstart' => 36,
                                                              'eqend' => 148,
                                                              'start' => 36,
                                                              'end' => 154
                                                            }
                                                          ]
                                            }
                                          ],
                               'type' => 'DNA'
                             },
          'ginger-1_triadh' => {
                                 'conlength' => '5030',
                                 'subtype' => 'Ginger-2',
                                 'equiv' => [
                                              {
                                                'name' => 'DNAX-5_Tad',
                                                'ranges' => [
                                                              {
                                                                'compl' => 1,
                                                                'div' => '10.56',
                                                                'score' => '78',
                                                                'eqstart' => '227',
                                                                'eqend' => '387',
                                                                'start' => '1917',
                                                                'end' => '2077'
                                                              }
                                                            ]
                                              }
                                            ],
                                 'type' => 'DNA'
                               },
          'mer6' => {
                      'conlength' => '865',
                      'subtype' => 'TcMar-Tigger',
                      'equiv' => [
                                   {
                                     'name' => 'MER6C',
                                     'ranges' => [
                                                   {
                                                     'div' => '1.56',
                                                     'score' => '107',
                                                     'eqstart' => 70,
                                                     'eqend' => 202,
                                                     'start' => 738,
                                                     'end' => 865
                                                   },
                                                   {
                                                     'compl' => 1,
                                                     'div' => '0.00',
                                                     'score' => '63',
                                                     'eqstart' => 1,
                                                     'eqend' => 63,
                                                     'start' => 803,
                                                     'end' => 865
                                                   }
                                                 ]
                                   },
                                   {
                                     'name' => 'MER6B',
                                     'ranges' => [
                                                   {
                                                     'div' => '1.52',
                                                     'score' => '63',
                                                     'eqstart' => 67,
                                                     'eqend' => 132,
                                                     'start' => 1,
                                                     'end' => 66
                                                   },
                                                   {
                                                     'div' => '4.88',
                                                     'score' => '69',
                                                     'eqstart' => 129,
                                                     'eqend' => 210,
                                                     'start' => 784,
                                                     'end' => 865
                                                   },
                                                   {
                                                     'compl' => 1,
                                                     'div' => '0.00',
                                                     'score' => '66',
                                                     'eqstart' => 1,
                                                     'eqend' => 66,
                                                     'start' => 800,
                                                     'end' => 865
                                                   }
                                                 ]
                                   },
                                   {
                                     'name' => 'MER6A',
                                     'ranges' => [
                                                   {
                                                     'div' => '1.47',
                                                     'score' => '319',
                                                     'eqstart' => 1,
                                                     'eqend' => 341,
                                                     'start' => 1,
                                                     'end' => 341
                                                   },
                                                   {
                                                     'div' => '0.00',
                                                     'score' => '249',
                                                     'eqstart' => 340,
                                                     'eqend' => 605,
                                                     'start' => 600,
                                                     'end' => 865
                                                   }
                                                 ]
                                   }
                                 ],
                      'type' => 'DNA'
                    },
          'dna-8-28_dr' => {
                             'conlength' => '582',
                             'subtype' => 'hAT-Tip100',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'dna3-3_mad' => {
                            'conlength' => '374',
                            'subtype' => undef,
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'dna-4-3_dr' => {
                            'conlength' => '1421',
                            'subtype' => undef,
                            'equiv' => [
                                         {
                                           'name' => 'DNA-X-13_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '10.02',
                                                           'score' => '157',
                                                           'eqstart' => 86,
                                                           'eqend' => 691,
                                                           'start' => 355,
                                                           'end' => 943
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N44_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '6.22',
                                                           'score' => '112',
                                                           'eqstart' => 81,
                                                           'eqend' => 271,
                                                           'start' => 967,
                                                           'end' => 1159
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-8-27_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '5.70',
                                                           'score' => '111',
                                                           'eqstart' => 1383,
                                                           'eqend' => 1567,
                                                           'start' => 973,
                                                           'end' => 1165
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA2-4_DR',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '8.78',
                                                           'score' => '78',
                                                           'eqstart' => '124',
                                                           'eqend' => '269',
                                                           'start' => '967',
                                                           'end' => '1114'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N53_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '6.25',
                                                           'score' => '239',
                                                           'eqstart' => 2032,
                                                           'eqend' => 2369,
                                                           'start' => 2,
                                                           'end' => 337
                                                         },
                                                         {
                                                           'div' => '6.40',
                                                           'score' => '129',
                                                           'eqstart' => 2375,
                                                           'eqend' => 2574,
                                                           'start' => 491,
                                                           'end' => 693
                                                         },
                                                         {
                                                           'div' => '9.78',
                                                           'score' => '197',
                                                           'eqstart' => 4780,
                                                           'eqend' => 5139,
                                                           'start' => 1054,
                                                           'end' => 1421
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'mariner14_cb' => {
                              'conlength' => '1642',
                              'subtype' => 'TcMar-Tc1',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'dna4-5b_cgi' => {
                             'conlength' => '887',
                             'subtype' => undef,
                             'equiv' => [
                                          {
                                            'name' => 'DNA4-5_CGi',
                                            'ranges' => [
                                                          {
                                                            'div' => '11.96',
                                                            'score' => '358',
                                                            'eqstart' => '6',
                                                            'eqend' => '883',
                                                            'start' => '6',
                                                            'end' => '883'
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'mariner-9_dk' => {
                              'conlength' => '1763',
                              'subtype' => 'TcMar-Tc1',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'dna-5-14_nv' => {
                             'conlength' => '343',
                             'subtype' => 'hAT-Tip100',
                             'equiv' => [
                                          {
                                            'name' => 'DNA-5-10_NV',
                                            'ranges' => [
                                                          {
                                                            'div' => '7.35',
                                                            'score' => '42',
                                                            'eqstart' => 1,
                                                            'eqend' => 68,
                                                            'start' => 1,
                                                            'end' => 68
                                                          },
                                                          {
                                                            'div' => '5.26',
                                                            'score' => '32',
                                                            'eqstart' => 124,
                                                            'eqend' => 180,
                                                            'start' => 287,
                                                            'end' => 343
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'x9b_dna' => {
                         'conlength' => '632',
                         'subtype' => 'TcMar-Tigger',
                         'equiv' => [],
                         'type' => 'DNA'
                       },
          'chapaev-n5_aae' => {
                                'conlength' => '2588',
                                'subtype' => 'CMC-Chapaev',
                                'equiv' => [
                                             {
                                               'name' => 'Chapaev-N3_AAe',
                                               'ranges' => [
                                                             {
                                                               'div' => '6.90',
                                                               'score' => '43',
                                                               'eqstart' => '82',
                                                               'eqend' => '139',
                                                               'start' => '83',
                                                               'end' => '140'
                                                             },
                                                             {
                                                               'compl' => 1,
                                                               'div' => '12.50',
                                                               'score' => '30',
                                                               'eqstart' => '2290',
                                                               'eqend' => '2345',
                                                               'start' => '85',
                                                               'end' => '140'
                                                             }
                                                           ]
                                             }
                                           ],
                                'type' => 'DNA'
                              },
          'oposcharlie1' => {
                              'conlength' => '790',
                              'subtype' => 'hAT-Charlie',
                              'equiv' => [
                                           {
                                             'name' => 'OposCharlie1a',
                                             'ranges' => [
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '412',
                                                             'eqstart' => 1,
                                                             'eqend' => 419,
                                                             'start' => 1,
                                                             'end' => 419
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '78',
                                                             'eqstart' => 432,
                                                             'eqend' => 509,
                                                             'start' => 3251,
                                                             'end' => 3328
                                                           }
                                                         ]
                                           }
                                         ],
                              'type' => 'DNA'
                            },
          'cryptons-5_pi' => {
                               'conlength' => '2827',
                               'subtype' => 'Crypton-S',
                               'equiv' => [
                                            {
                                              'name' => 'CryptonS-6_PI',
                                              'ranges' => [
                                                            {
                                                              'div' => '6.76',
                                                              'score' => '47',
                                                              'eqstart' => '1',
                                                              'eqend' => '75',
                                                              'start' => '1',
                                                              'end' => '74'
                                                            }
                                                          ]
                                            }
                                          ],
                               'type' => 'DNA'
                             },
          'mariner1_ag' => {
                             'conlength' => '943',
                             'subtype' => 'TcMar-Tc1',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'hat4n_ci' => {
                          'conlength' => '449',
                          'subtype' => 'hAT-Ac',
                          'equiv' => [
                                       {
                                         'name' => 'HAT4_CI',
                                         'ranges' => [
                                                       {
                                                         'div' => '1.80',
                                                         'score' => '99',
                                                         'eqstart' => 1,
                                                         'eqend' => 111,
                                                         'start' => 158,
                                                         'end' => 268
                                                       },
                                                       {
                                                         'div' => '1.32',
                                                         'score' => '70',
                                                         'eqstart' => 3273,
                                                         'eqend' => 3348,
                                                         'start' => 372,
                                                         'end' => 447
                                                       },
                                                       {
                                                         'div' => '1.45',
                                                         'score' => '60',
                                                         'eqstart' => 145,
                                                         'eqend' => 213,
                                                         'start' => 381,
                                                         'end' => 449
                                                       }
                                                     ]
                                       }
                                     ],
                          'type' => 'DNA'
                        },
          'dna7-1_sp' => {
                           'conlength' => '908',
                           'subtype' => 'hAT',
                           'equiv' => [
                                        {
                                          'name' => 'hATw-2_SP',
                                          'ranges' => [
                                                        {
                                                          'div' => '12.55',
                                                          'score' => '99',
                                                          'eqstart' => 1,
                                                          'eqend' => 267,
                                                          'start' => 1,
                                                          'end' => 271
                                                        },
                                                        {
                                                          'div' => '6.02',
                                                          'score' => '44',
                                                          'eqstart' => 400,
                                                          'eqend' => 482,
                                                          'start' => 405,
                                                          'end' => 487
                                                        }
                                                      ]
                                        }
                                      ],
                           'type' => 'DNA'
                         },
          'atenspm9' => {
                          'conlength' => '8285',
                          'subtype' => 'CMC-EnSpm',
                          'equiv' => [
                                       {
                                         'name' => 'ATENSPM6',
                                         'ranges' => [
                                                       {
                                                         'div' => '12.93',
                                                         'score' => '933',
                                                         'eqstart' => 885,
                                                         'eqend' => 3091,
                                                         'start' => 1066,
                                                         'end' => 3269
                                                       },
                                                       {
                                                         'div' => '12.64',
                                                         'score' => '70',
                                                         'eqstart' => 3144,
                                                         'eqend' => 3317,
                                                         'start' => 3332,
                                                         'end' => 3505
                                                       }
                                                     ]
                                       },
                                       {
                                         'name' => 'ATENSPM5',
                                         'ranges' => [
                                                       {
                                                         'div' => '12.76',
                                                         'score' => '1041',
                                                         'eqstart' => 528,
                                                         'eqend' => 3108,
                                                         'start' => 669,
                                                         'end' => 3269
                                                       },
                                                       {
                                                         'div' => '7.55',
                                                         'score' => '36',
                                                         'eqstart' => 4354,
                                                         'eqend' => 4406,
                                                         'start' => 4519,
                                                         'end' => 4571
                                                       }
                                                     ]
                                       }
                                     ],
                          'type' => 'DNA'
                        },
          'dna-1_ppac' => {
                            'conlength' => '805',
                            'subtype' => undef,
                            'equiv' => [
                                         {
                                           'name' => 'DNA-5_PPac',
                                           'ranges' => [
                                                         {
                                                           'div' => '6.32',
                                                           'score' => '122',
                                                           'eqstart' => 293,
                                                           'eqend' => 468,
                                                           'start' => 302,
                                                           'end' => 475
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA-4_PPac',
                                           'ranges' => [
                                                         {
                                                           'div' => '12.10',
                                                           'score' => '219',
                                                           'eqstart' => 293,
                                                           'eqend' => 732,
                                                           'start' => 302,
                                                           'end' => 739
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'chapaev3-3n1_ac' => {
                                 'conlength' => '443',
                                 'subtype' => 'CMC-Chapaev-3',
                                 'equiv' => [
                                              {
                                                'name' => 'hAT-N11_ACar',
                                                'ranges' => [
                                                              {
                                                                'div' => '5.83',
                                                                'score' => '75',
                                                                'eqstart' => '261',
                                                                'eqend' => '363',
                                                                'start' => '26',
                                                                'end' => '128'
                                                              },
                                                              {
                                                                'compl' => 1,
                                                                'div' => '3.28',
                                                                'score' => '54',
                                                                'eqstart' => '414',
                                                                'eqend' => '474',
                                                                'start' => '58',
                                                                'end' => '118'
                                                              }
                                                            ]
                                              }
                                            ],
                                 'type' => 'DNA'
                               },
          'hat-6n1_crp' => {
                             'conlength' => '314',
                             'subtype' => 'hAT-Charlie',
                             'equiv' => [
                                          {
                                            'name' => 'hAT-6_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '0.00',
                                                            'score' => '152',
                                                            'eqstart' => '1',
                                                            'eqend' => '153',
                                                            'start' => '1',
                                                            'end' => '153'
                                                          },
                                                          {
                                                            'div' => '0.00',
                                                            'score' => '148',
                                                            'eqstart' => '2376',
                                                            'eqend' => '2528',
                                                            'start' => '162',
                                                            'end' => '314'
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'smar27' => {
                        'conlength' => '1357',
                        'subtype' => 'TcMar-Mariner',
                        'equiv' => [],
                        'type' => 'DNA'
                      },
          'dna5-7_cgi' => {
                            'conlength' => '981',
                            'subtype' => undef,
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'monorep4' => {
                          'conlength' => '610',
                          'subtype' => 'TcMar-Tigger',
                          'equiv' => [],
                          'type' => 'DNA'
                        },
          'hatm-20_hm' => {
                            'conlength' => '2827',
                            'subtype' => 'hAT-hATm',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'nhat3_ml' => {
                          'conlength' => '209',
                          'subtype' => 'hAT-Charlie',
                          'equiv' => [],
                          'type' => 'DNA'
                        },
          'sola2-1_hrobusta' => {
                                  'conlength' => '1621',
                                  'subtype' => 'Sola-2',
                                  'equiv' => [],
                                  'type' => 'DNA'
                                },
          'stowaway23_sb' => {
                               'conlength' => '237',
                               'subtype' => 'TcMar-Stowaway',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'dna-9-1_ta' => {
                            'conlength' => '328',
                            'subtype' => undef,
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'ttaa27_ap' => {
                           'conlength' => '289',
                           'subtype' => undef,
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'cryptoni-1_aa' => {
                               'conlength' => '1980',
                               'subtype' => 'Crypton-I',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'mtph-a6-1-ia' => {
                              'conlength' => '4075',
                              'subtype' => 'PIF-Harbinger',
                              'equiv' => [
                                           {
                                             'name' => 'MtPH-A6-3-Ia',
                                             'ranges' => [
                                                           {
                                                             'div' => '10.69',
                                                             'score' => '1212',
                                                             'eqstart' => 1554,
                                                             'eqend' => 4220,
                                                             'start' => 802,
                                                             'end' => 3429
                                                           }
                                                         ]
                                           }
                                         ],
                              'type' => 'DNA'
                            },
          'mudrn3_os' => {
                           'conlength' => '903',
                           'subtype' => 'MULE-MuDR',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'hat-n13_mad' => {
                             'conlength' => '511',
                             'subtype' => 'hAT-Tag1',
                             'equiv' => [
                                          {
                                            'name' => 'hAT-N3_Mad',
                                            'ranges' => [
                                                          {
                                                            'div' => '2.47',
                                                            'score' => '67',
                                                            'eqstart' => 1,
                                                            'eqend' => 81,
                                                            'start' => 1,
                                                            'end' => 81
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N2_Mad',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '7.41',
                                                            'score' => '53',
                                                            'eqstart' => 893,
                                                            'eqend' => 973,
                                                            'start' => 1,
                                                            'end' => 81
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'mudr-1x_ap' => {
                            'conlength' => '3643',
                            'subtype' => 'MULE-MuDR',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'hydargos1_em' => {
                              'conlength' => '1865',
                              'subtype' => 'TcMar-Tc1',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'piggybac-n6_bf' => {
                                'conlength' => '1426',
                                'subtype' => 'PiggyBac',
                                'equiv' => [
                                             {
                                               'name' => 'piggyBac-3_BF',
                                               'ranges' => [
                                                             {
                                                               'div' => '10.68',
                                                               'score' => '61',
                                                               'eqstart' => '1',
                                                               'eqend' => '103',
                                                               'start' => '1',
                                                               'end' => '103'
                                                             },
                                                             {
                                                               'div' => '12.33',
                                                               'score' => '40',
                                                               'eqstart' => '156',
                                                               'eqend' => '228',
                                                               'start' => '156',
                                                               'end' => '228'
                                                             }
                                                           ]
                                             }
                                           ],
                                'type' => 'DNA'
                              },
          'transib-20_hm' => {
                               'conlength' => '4865',
                               'subtype' => 'CMC-Transib',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'mariner-12_drh' => {
                                'conlength' => '1640',
                                'subtype' => 'TcMar-Tc1',
                                'equiv' => [],
                                'type' => 'DNA'
                              },
          'dna8-2b_cgi' => {
                             'conlength' => '891',
                             'subtype' => 'hAT-Ac',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'parisa_dpe' => {
                            'conlength' => '1742',
                            'subtype' => 'TcMar-Tc1',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'dna-9-1_hm' => {
                            'conlength' => '3061',
                            'subtype' => undef,
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'dna8-54_ap' => {
                            'conlength' => '147',
                            'subtype' => undef,
                            'equiv' => [
                                         {
                                           'name' => 'DNA8-56_AP',
                                           'ranges' => [
                                                         {
                                                           'div' => '9.30',
                                                           'score' => '30',
                                                           'eqstart' => '500',
                                                           'eqend' => '585',
                                                           'start' => '503',
                                                           'end' => '588'
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'polinton-2_nv' => {
                               'conlength' => '21301',
                               'subtype' => 'Maverick',
                               'equiv' => [
                                            {
                                              'name' => 'Polinton-2A_NV',
                                              'ranges' => [
                                                            {
                                                              'div' => '10.91',
                                                              'score' => '36',
                                                              'eqstart' => 2490,
                                                              'eqend' => 2544,
                                                              'start' => 3088,
                                                              'end' => 3142
                                                            },
                                                            {
                                                              'div' => '2.56',
                                                              'score' => '33',
                                                              'eqstart' => 13944,
                                                              'eqend' => 13982,
                                                              'start' => 14605,
                                                              'end' => 14643
                                                            },
                                                            {
                                                              'div' => '12.96',
                                                              'score' => '64',
                                                              'eqstart' => 14462,
                                                              'eqend' => 14617,
                                                              'start' => 15093,
                                                              'end' => 15254
                                                            },
                                                            {
                                                              'div' => '0.00',
                                                              'score' => '31',
                                                              'eqstart' => 16115,
                                                              'eqend' => 16153,
                                                              'start' => 16621,
                                                              'end' => 16660
                                                            },
                                                            {
                                                              'div' => '8.51',
                                                              'score' => '30',
                                                              'eqstart' => 18459,
                                                              'eqend' => 18505,
                                                              'start' => 19083,
                                                              'end' => 19129
                                                            }
                                                          ]
                                            },
                                            {
                                              'name' => 'Polinton-5_NV',
                                              'ranges' => [
                                                            {
                                                              'div' => '12.73',
                                                              'score' => '30',
                                                              'eqstart' => '12386',
                                                              'eqend' => '12440',
                                                              'start' => '13108',
                                                              'end' => '13162'
                                                            }
                                                          ]
                                            }
                                          ],
                               'type' => 'DNA'
                             },
          'cemudr1' => {
                         'conlength' => '7188',
                         'subtype' => 'MULE-MuDR',
                         'equiv' => [],
                         'type' => 'DNA'
                       },
          'hat-9n2_xt' => {
                            'conlength' => '525',
                            'subtype' => 'hAT-Ac',
                            'equiv' => [
                                         {
                                           'name' => 'hAT-9N3_XT',
                                           'ranges' => [
                                                         {
                                                           'div' => '4.63',
                                                           'score' => '78',
                                                           'eqstart' => 1,
                                                           'eqend' => 108,
                                                           'start' => 1,
                                                           'end' => 108
                                                         },
                                                         {
                                                           'div' => '4.92',
                                                           'score' => '188',
                                                           'eqstart' => 269,
                                                           'eqend' => 512,
                                                           'start' => 282,
                                                           'end' => 525
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'Harbinger-N14_XT',
                                           'ranges' => [
                                                         {
                                                           'div' => '5.26',
                                                           'score' => '44',
                                                           'eqstart' => 14,
                                                           'eqend' => 70,
                                                           'start' => 108,
                                                           'end' => 164
                                                         },
                                                         {
                                                           'div' => '3.61',
                                                           'score' => '67',
                                                           'eqstart' => 112,
                                                           'eqend' => 195,
                                                           'start' => 176,
                                                           'end' => 258
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-9_XT',
                                           'ranges' => [
                                                         {
                                                           'div' => '5.56',
                                                           'score' => '85',
                                                           'eqstart' => 1,
                                                           'eqend' => 108,
                                                           'start' => 1,
                                                           'end' => 108
                                                         },
                                                         {
                                                           'div' => '3.46',
                                                           'score' => '220',
                                                           'eqstart' => 5457,
                                                           'eqend' => 5716,
                                                           'start' => 266,
                                                           'end' => 525
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'Harbinger-3_XT',
                                           'ranges' => [
                                                         {
                                                           'div' => '5.26',
                                                           'score' => '44',
                                                           'eqstart' => 14,
                                                           'eqend' => 70,
                                                           'start' => 108,
                                                           'end' => 164
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'XL1723L',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '7.11',
                                                           'score' => '105',
                                                           'eqstart' => 29,
                                                           'eqend' => 230,
                                                           'start' => 289,
                                                           'end' => 485
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'XT1723',
                                           'ranges' => [
                                                         {
                                                           'div' => '4.63',
                                                           'score' => '51',
                                                           'eqstart' => 1,
                                                           'eqend' => 100,
                                                           'start' => 1,
                                                           'end' => 108
                                                         },
                                                         {
                                                           'div' => '3.46',
                                                           'score' => '220',
                                                           'eqstart' => 985,
                                                           'eqend' => 1244,
                                                           'start' => 266,
                                                           'end' => 525
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-9A_XT',
                                           'ranges' => [
                                                         {
                                                           'div' => '4.69',
                                                           'score' => '205',
                                                           'eqstart' => 4702,
                                                           'eqend' => 4957,
                                                           'start' => 266,
                                                           'end' => 521
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-9N1_XT',
                                           'ranges' => [
                                                         {
                                                           'div' => '2.44',
                                                           'score' => '60',
                                                           'eqstart' => 1,
                                                           'eqend' => 82,
                                                           'start' => 1,
                                                           'end' => 82
                                                         },
                                                         {
                                                           'div' => '6.22',
                                                           'score' => '174',
                                                           'eqstart' => 306,
                                                           'eqend' => 546,
                                                           'start' => 285,
                                                           'end' => 525
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'enspm_ca' => {
                          'conlength' => '1112',
                          'subtype' => 'CMC-EnSpm',
                          'equiv' => [],
                          'type' => 'DNA'
                        },
          'dna3-7_mlp' => {
                            'conlength' => '887',
                            'subtype' => undef,
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'hat-n1_crp' => {
                            'conlength' => '1219',
                            'subtype' => 'hAT-Charlie',
                            'equiv' => [
                                         {
                                           'name' => 'hAT-5524_Ami',
                                           'ranges' => [
                                                         {
                                                           'div' => '11.38',
                                                           'score' => '68',
                                                           'eqstart' => '1206',
                                                           'eqend' => '1328',
                                                           'start' => '1561',
                                                           'end' => '1683'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N20_AMi',
                                           'ranges' => [
                                                         {
                                                           'div' => '5.29',
                                                           'score' => '1086',
                                                           'eqstart' => '1',
                                                           'eqend' => '1661',
                                                           'start' => '1',
                                                           'end' => '1683'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '10.94',
                                                           'score' => '95',
                                                           'eqstart' => '356',
                                                           'eqend' => '729',
                                                           'start' => '348',
                                                           'end' => '740'
                                                         },
                                                         {
                                                           'div' => '10.69',
                                                           'score' => '82',
                                                           'eqstart' => '1029',
                                                           'eqend' => '1187',
                                                           'start' => '361',
                                                           'end' => '519'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '12.81',
                                                           'score' => '184',
                                                           'eqstart' => '558',
                                                           'eqend' => '1188',
                                                           'start' => '581',
                                                           'end' => '1220'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-2210_Ami',
                                           'ranges' => [
                                                         {
                                                           'div' => '4.96',
                                                           'score' => '94',
                                                           'eqstart' => '2163',
                                                           'eqend' => '2283',
                                                           'start' => '1563',
                                                           'end' => '1683'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N16_Crp',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '7.38',
                                                           'score' => '76',
                                                           'eqstart' => '1',
                                                           'eqend' => '121',
                                                           'start' => '1562',
                                                           'end' => '1683'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-7_AMi',
                                           'ranges' => [
                                                         {
                                                           'div' => '2.38',
                                                           'score' => '35',
                                                           'eqstart' => '1',
                                                           'eqend' => '42',
                                                           'start' => '1',
                                                           'end' => '42'
                                                         },
                                                         {
                                                           'div' => '8.94',
                                                           'score' => '76',
                                                           'eqstart' => '3986',
                                                           'eqend' => '4108',
                                                           'start' => '1561',
                                                           'end' => '1683'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-2477_Ami',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '8.75',
                                                           'score' => '108',
                                                           'eqstart' => '1540',
                                                           'eqend' => '1700',
                                                           'start' => '1',
                                                           'end' => '160'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '5.74',
                                                           'score' => '94',
                                                           'eqstart' => '1',
                                                           'eqend' => '122',
                                                           'start' => '1562',
                                                           'end' => '1683'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-1960_Ami',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '11.88',
                                                           'score' => '77',
                                                           'eqstart' => '858',
                                                           'eqend' => '1014',
                                                           'start' => '1',
                                                           'end' => '160'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '4.27',
                                                           'score' => '95',
                                                           'eqstart' => '1',
                                                           'eqend' => '117',
                                                           'start' => '1567',
                                                           'end' => '1683'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N8B_AMi',
                                           'ranges' => [
                                                         {
                                                           'div' => '12.61',
                                                           'score' => '63',
                                                           'eqstart' => '1',
                                                           'eqend' => '120',
                                                           'start' => '1',
                                                           'end' => '119'
                                                         },
                                                         {
                                                           'div' => '8.70',
                                                           'score' => '46',
                                                           'eqstart' => '119',
                                                           'eqend' => '187',
                                                           'start' => '1615',
                                                           'end' => '1683'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N8_AMi',
                                           'ranges' => [
                                                         {
                                                           'div' => '5.88',
                                                           'score' => '187',
                                                           'eqstart' => '1',
                                                           'eqend' => '256',
                                                           'start' => '1',
                                                           'end' => '255'
                                                         },
                                                         {
                                                           'div' => '9.98',
                                                           'score' => '164',
                                                           'eqstart' => '304',
                                                           'eqend' => '719',
                                                           'start' => '351',
                                                           'end' => '781'
                                                         },
                                                         {
                                                           'div' => '11.95',
                                                           'score' => '76',
                                                           'eqstart' => '758',
                                                           'eqend' => '916',
                                                           'start' => '361',
                                                           'end' => '519'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '9.22',
                                                           'score' => '93',
                                                           'eqstart' => '716',
                                                           'eqend' => '917',
                                                           'start' => '581',
                                                           'end' => '786'
                                                         },
                                                         {
                                                           'div' => '5.71',
                                                           'score' => '424',
                                                           'eqstart' => '716',
                                                           'eqend' => '1406',
                                                           'start' => '1018',
                                                           'end' => '1683'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '12.56',
                                                           'score' => '87',
                                                           'eqstart' => '509',
                                                           'eqend' => '719',
                                                           'start' => '1023',
                                                           'end' => '1229'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N24_Crp',
                                           'ranges' => [
                                                         {
                                                           'div' => '9.02',
                                                           'score' => '76',
                                                           'eqstart' => '1384',
                                                           'eqend' => '1505',
                                                           'start' => '1562',
                                                           'end' => '1683'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-310_Ami',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '9.90',
                                                           'score' => '111',
                                                           'eqstart' => '919',
                                                           'eqend' => '1117',
                                                           'start' => '1',
                                                           'end' => '202'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '7.38',
                                                           'score' => '82',
                                                           'eqstart' => '1',
                                                           'eqend' => '121',
                                                           'start' => '1562',
                                                           'end' => '1683'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N25_Crp',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '11.58',
                                                           'score' => '50',
                                                           'eqstart' => '1',
                                                           'eqend' => '95',
                                                           'start' => '1589',
                                                           'end' => '1683'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-658_Ami',
                                           'ranges' => [
                                                         {
                                                           'div' => '4.88',
                                                           'score' => '31',
                                                           'eqstart' => '1',
                                                           'eqend' => '41',
                                                           'start' => '1',
                                                           'end' => '41'
                                                         },
                                                         {
                                                           'div' => '11.97',
                                                           'score' => '48',
                                                           'eqstart' => '1531',
                                                           'eqend' => '1647',
                                                           'start' => '1567',
                                                           'end' => '1683'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N1B_Crp',
                                           'ranges' => [
                                                         {
                                                           'div' => '7.32',
                                                           'score' => '236',
                                                           'eqstart' => '1',
                                                           'eqend' => '496',
                                                           'start' => '1',
                                                           'end' => '519'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '7.19',
                                                           'score' => '105',
                                                           'eqstart' => '337',
                                                           'eqend' => '503',
                                                           'start' => '360',
                                                           'end' => '526'
                                                         },
                                                         {
                                                           'div' => '7.78',
                                                           'score' => '101',
                                                           'eqstart' => '823',
                                                           'eqend' => '989',
                                                           'start' => '361',
                                                           'end' => '527'
                                                         },
                                                         {
                                                           'div' => '7.98',
                                                           'score' => '564',
                                                           'eqstart' => '343',
                                                           'eqend' => '1417',
                                                           'start' => '581',
                                                           'end' => '1683'
                                                         },
                                                         {
                                                           'div' => '12.42',
                                                           'score' => '40',
                                                           'eqstart' => '828',
                                                           'eqend' => '981',
                                                           'start' => '581',
                                                           'end' => '733'
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '9.48',
                                                           'score' => '350',
                                                           'eqstart' => '329',
                                                           'eqend' => '982',
                                                           'start' => '581',
                                                           'end' => '1234'
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'dna-5_sbi' => {
                           'conlength' => '535',
                           'subtype' => 'MULE-MuDR',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'sola3-1_nv' => {
                            'conlength' => '5079',
                            'subtype' => 'Sola-3',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'dna-ta-8_nv' => {
                             'conlength' => '141',
                             'subtype' => undef,
                             'equiv' => [
                                          {
                                            'name' => 'Harbinger2-1_NV',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '1.94',
                                                            'score' => '88',
                                                            'eqstart' => 931,
                                                            'eqend' => 1033,
                                                            'start' => 39,
                                                            'end' => 141
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'hat-n14_mad' => {
                             'conlength' => '886',
                             'subtype' => 'hAT-Ac',
                             'equiv' => [
                                          {
                                            'name' => 'HAT-N6_Mad',
                                            'ranges' => [
                                                          {
                                                            'div' => '6.32',
                                                            'score' => '112',
                                                            'eqstart' => 1,
                                                            'eqend' => 173,
                                                            'start' => 1,
                                                            'end' => 174
                                                          },
                                                          {
                                                            'div' => '3.24',
                                                            'score' => '153',
                                                            'eqstart' => 1031,
                                                            'eqend' => 1215,
                                                            'start' => 702,
                                                            'end' => 886
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N5_Mad',
                                            'ranges' => [
                                                          {
                                                            'div' => '8.24',
                                                            'score' => '159',
                                                            'eqstart' => 1230,
                                                            'eqend' => 1684,
                                                            'start' => 462,
                                                            'end' => 886
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'cryptons-16_pi' => {
                                'conlength' => '3362',
                                'subtype' => 'Crypton-S',
                                'equiv' => [
                                             {
                                               'name' => 'CryptonS-14_PI',
                                               'ranges' => [
                                                             {
                                                               'div' => '11.76',
                                                               'score' => '30',
                                                               'eqstart' => '673',
                                                               'eqend' => '740',
                                                               'start' => '667',
                                                               'end' => '734'
                                                             },
                                                             {
                                                               'div' => '7.35',
                                                               'score' => '50',
                                                               'eqstart' => '2483',
                                                               'eqend' => '2550',
                                                               'start' => '2699',
                                                               'end' => '2766'
                                                             },
                                                             {
                                                               'div' => '12.66',
                                                               'score' => '39',
                                                               'eqstart' => '2924',
                                                               'eqend' => '3002',
                                                               'start' => '3122',
                                                               'end' => '3200'
                                                             },
                                                             {
                                                               'div' => '0.00',
                                                               'score' => '35',
                                                               'eqstart' => '3101',
                                                               'eqend' => '3139',
                                                               'start' => '3324',
                                                               'end' => '3362'
                                                             }
                                                           ]
                                             },
                                             {
                                               'name' => 'CryptonS-13_PI',
                                               'ranges' => [
                                                             {
                                                               'div' => '12.90',
                                                               'score' => '52',
                                                               'eqstart' => '497',
                                                               'eqend' => '620',
                                                               'start' => '491',
                                                               'end' => '614'
                                                             },
                                                             {
                                                               'div' => '0.00',
                                                               'score' => '35',
                                                               'eqstart' => '3483',
                                                               'eqend' => '3521',
                                                               'start' => '3324',
                                                               'end' => '3362'
                                                             }
                                                           ]
                                             }
                                           ],
                                'type' => 'DNA'
                              },
          'hat-n3_mad' => {
                            'conlength' => '660',
                            'subtype' => 'hAT-Tag1',
                            'equiv' => [
                                         {
                                           'name' => 'HAT-N13_Mad',
                                           'ranges' => [
                                                         {
                                                           'div' => '2.47',
                                                           'score' => '68',
                                                           'eqstart' => 1,
                                                           'eqend' => 81,
                                                           'start' => 1,
                                                           'end' => 81
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'hAT-N2_Mad',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '7.37',
                                                           'score' => '64',
                                                           'eqstart' => 879,
                                                           'eqend' => 973,
                                                           'start' => 1,
                                                           'end' => 95
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '2.63',
                                                           'score' => '35',
                                                           'eqstart' => 1,
                                                           'eqend' => 38,
                                                           'start' => 623,
                                                           'end' => 660
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'dna-aatt-1_cq' => {
                               'conlength' => '324',
                               'subtype' => undef,
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'mariner-10_del' => {
                                'conlength' => '1532',
                                'subtype' => 'TcMar-Tc1',
                                'equiv' => [],
                                'type' => 'DNA'
                              },
          'harb_cis1' => {
                           'conlength' => '4252',
                           'subtype' => 'PIF-Harbinger',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'vader' => {
                       'conlength' => '437',
                       'subtype' => undef,
                       'equiv' => [],
                       'type' => 'DNA'
                     },
          'dna-3-10_nv' => {
                             'conlength' => '440',
                             'subtype' => undef,
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'navimar1' => {
                          'conlength' => '1223',
                          'subtype' => 'TcMar-Mariner',
                          'equiv' => [],
                          'type' => 'DNA'
                        },
          'mariner-5_deu' => {
                               'conlength' => '1639',
                               'subtype' => 'TcMar-Tc1',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'smar3' => {
                       'conlength' => '1992',
                       'subtype' => 'TcMar-Pogo',
                       'equiv' => [],
                       'type' => 'DNA'
                     },
          'cacta-q' => {
                         'conlength' => '2062',
                         'subtype' => 'CMC-EnSpm',
                         'equiv' => [
                                      {
                                        'name' => 'OSTE22',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '9.03',
                                                        'score' => '272',
                                                        'eqstart' => 330,
                                                        'eqend' => 929,
                                                        'start' => 1177,
                                                        'end' => 1796
                                                      },
                                                      {
                                                        'div' => '11.94',
                                                        'score' => '247',
                                                        'eqstart' => 1083,
                                                        'eqend' => 1704,
                                                        'start' => 1177,
                                                        'end' => 1796
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '9.24',
                                                        'score' => '329',
                                                        'eqstart' => 1420,
                                                        'eqend' => 2037,
                                                        'start' => 1180,
                                                        'end' => 1796
                                                      },
                                                      {
                                                        'div' => '10.88',
                                                        'score' => '187',
                                                        'eqstart' => 37,
                                                        'eqend' => 595,
                                                        'start' => 1218,
                                                        'end' => 1796
                                                      },
                                                      {
                                                        'div' => '10.16',
                                                        'score' => '124',
                                                        'eqstart' => 1,
                                                        'eqend' => 254,
                                                        'start' => 1336,
                                                        'end' => 1591
                                                      },
                                                      {
                                                        'div' => '8.98',
                                                        'score' => '124',
                                                        'eqstart' => 1097,
                                                        'eqend' => 1344,
                                                        'start' => 1347,
                                                        'end' => 1591
                                                      },
                                                      {
                                                        'div' => '11.48',
                                                        'score' => '32',
                                                        'eqstart' => '816',
                                                        'eqend' => '876',
                                                        'start' => 1706,
                                                        'end' => '1766'
                                                      },
                                                      {
                                                        'div' => '11.48',
                                                        'score' => '32',
                                                        'eqstart' => '1925',
                                                        'eqend' => '1985',
                                                        'start' => 1706,
                                                        'end' => '1766'
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '8.00',
                                                        'score' => '48',
                                                        'eqstart' => 180,
                                                        'eqend' => 254,
                                                        'start' => 1717,
                                                        'end' => 1791
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '8.75',
                                                        'score' => '44',
                                                        'eqstart' => 1264,
                                                        'eqend' => 1344,
                                                        'start' => 1717,
                                                        'end' => 1796
                                                      },
                                                      {
                                                        'div' => '11.65',
                                                        'score' => '50',
                                                        'eqstart' => 671,
                                                        'eqend' => 773,
                                                        'start' => 1717,
                                                        'end' => 1819
                                                      },
                                                      {
                                                        'div' => '11.65',
                                                        'score' => '50',
                                                        'eqstart' => 1780,
                                                        'eqend' => 1882,
                                                        'start' => 1717,
                                                        'end' => 1819
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'ENSPM3_OS',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '10.91',
                                                        'score' => '32',
                                                        'eqstart' => '4864',
                                                        'eqend' => '4918',
                                                        'start' => '1697',
                                                        'end' => '1751'
                                                      }
                                                    ]
                                      }
                                    ],
                         'type' => 'DNA'
                       },
          'dna8-107_ap' => {
                             'conlength' => '1026',
                             'subtype' => 'hAT-Tip100',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'mariner-n1743_ami' => {
                                   'conlength' => '582',
                                   'subtype' => 'TcMar-Tigger',
                                   'equiv' => [
                                                {
                                                  'name' => 'Mariner-7_Croc',
                                                  'ranges' => [
                                                                {
                                                                  'div' => '12.64',
                                                                  'score' => '43',
                                                                  'eqstart' => '1',
                                                                  'eqend' => '87',
                                                                  'start' => '1',
                                                                  'end' => '87'
                                                                }
                                                              ]
                                                },
                                                {
                                                  'name' => 'Mariner-N320_AMi',
                                                  'ranges' => [
                                                                {
                                                                  'div' => '8.18',
                                                                  'score' => '72',
                                                                  'eqstart' => '1',
                                                                  'eqend' => '110',
                                                                  'start' => '1',
                                                                  'end' => '110'
                                                                }
                                                              ]
                                                }
                                              ],
                                   'type' => 'DNA'
                                 },
          'dna8-17_ap' => {
                            'conlength' => '919',
                            'subtype' => undef,
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'kolobok-n1_dr' => {
                               'conlength' => '799',
                               'subtype' => 'Kolobok-T2',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'hat-7_sm' => {
                          'conlength' => '3389',
                          'subtype' => 'hAT-hATm',
                          'equiv' => [
                                       {
                                         'name' => 'hAT-10_SM',
                                         'ranges' => [
                                                       {
                                                         'div' => '4.88',
                                                         'score' => '32',
                                                         'eqstart' => '89',
                                                         'eqend' => '129',
                                                         'start' => '89',
                                                         'end' => '129'
                                                       }
                                                     ]
                                       }
                                     ],
                          'type' => 'DNA'
                        },
          'hat-4_ap' => {
                          'conlength' => '3428',
                          'subtype' => 'hAT-hATm',
                          'equiv' => [
                                       {
                                         'name' => 'hAT-4D_AP',
                                         'ranges' => [
                                                       {
                                                         'compl' => 1,
                                                         'div' => '12.73',
                                                         'score' => '96',
                                                         'eqstart' => 3138,
                                                         'eqend' => 3411,
                                                         'start' => 1,
                                                         'end' => 275
                                                       }
                                                     ]
                                       }
                                     ],
                          'type' => 'DNA'
                        },
          'academ-2_cgi' => {
                              'conlength' => '8165',
                              'subtype' => 'Academ-2',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'stone' => {
                       'conlength' => '130',
                       'subtype' => 'PIF-Harbinger',
                       'equiv' => [],
                       'type' => 'DNA'
                     },
          'marstigger1b' => {
                              'conlength' => '534',
                              'subtype' => 'TcMar-Tigger',
                              'equiv' => [
                                           {
                                             'name' => 'MARINERNA1_ME',
                                             'ranges' => [
                                                           {
                                                             'div' => '7.41',
                                                             'score' => '162',
                                                             'eqstart' => 7,
                                                             'eqend' => 222,
                                                             'start' => 5,
                                                             'end' => 220
                                                           },
                                                           {
                                                             'div' => '9.43',
                                                             'score' => '75',
                                                             'eqstart' => 224,
                                                             'eqend' => 329,
                                                             'start' => 425,
                                                             'end' => 530
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'MarsTigger1a',
                                             'ranges' => [
                                                           {
                                                             'div' => '1.68',
                                                             'score' => '221',
                                                             'eqstart' => 1,
                                                             'eqend' => 238,
                                                             'start' => 1,
                                                             'end' => 238
                                                           },
                                                           {
                                                             'div' => '2.11',
                                                             'score' => '132',
                                                             'eqstart' => 238,
                                                             'eqend' => 379,
                                                             'start' => 393,
                                                             'end' => 534
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'MarsTigger1c',
                                             'ranges' => [
                                                           {
                                                             'div' => '0.60',
                                                             'score' => '292',
                                                             'eqstart' => 1,
                                                             'eqend' => 330,
                                                             'start' => 1,
                                                             'end' => 335
                                                           },
                                                           {
                                                             'div' => '3.95',
                                                             'score' => '66',
                                                             'eqstart' => 1738,
                                                             'eqend' => 1813,
                                                             'start' => 459,
                                                             'end' => 534
                                                           }
                                                         ]
                                           },
                                           {
                                             'name' => 'MarinerNB1_MEu',
                                             'ranges' => [
                                                           {
                                                             'div' => '1.04',
                                                             'score' => '184',
                                                             'eqstart' => 5,
                                                             'eqend' => 196,
                                                             'start' => 5,
                                                             'end' => 196
                                                           },
                                                           {
                                                             'div' => '0.00',
                                                             'score' => '157',
                                                             'eqstart' => 194,
                                                             'eqend' => 352,
                                                             'start' => 372,
                                                             'end' => 530
                                                           }
                                                         ]
                                           }
                                         ],
                              'type' => 'DNA'
                            },
          'mariner-6_mlp' => {
                               'conlength' => '2863',
                               'subtype' => 'TcMar-Pogo',
                               'equiv' => [
                                            {
                                              'name' => 'MarinerN-1_MLP',
                                              'ranges' => [
                                                            {
                                                              'div' => '2.63',
                                                              'score' => '33',
                                                              'eqstart' => '871',
                                                              'eqend' => '908',
                                                              'start' => '2826',
                                                              'end' => '2863'
                                                            }
                                                          ]
                                            }
                                          ],
                               'type' => 'DNA'
                             },
          'hat-4_drh' => {
                           'conlength' => '2680',
                           'subtype' => 'hAT-hobo',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'merlin1_cb' => {
                            'conlength' => '1912',
                            'subtype' => 'Merlin',
                            'equiv' => [
                                         {
                                           'name' => 'MERLIN6_CB',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '11.69',
                                                           'score' => '93',
                                                           'eqstart' => 241,
                                                           'eqend' => 485,
                                                           'start' => 1474,
                                                           'end' => 1721
                                                         },
                                                         {
                                                           'div' => '5.08',
                                                           'score' => '70',
                                                           'eqstart' => 367,
                                                           'eqend' => 485,
                                                           'start' => 1632,
                                                           'end' => 1749
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'hazean1' => {
                         'conlength' => '694',
                         'subtype' => 'hAT-Ac',
                         'equiv' => [
                                      {
                                        'name' => 'HAZEAN2',
                                        'ranges' => [
                                                      {
                                                        'div' => '8.33',
                                                        'score' => '39',
                                                        'eqstart' => 1,
                                                        'eqend' => 60,
                                                        'start' => 1,
                                                        'end' => 60
                                                      }
                                                    ]
                                      }
                                    ],
                         'type' => 'DNA'
                       },
          'harbinger-2_drh' => {
                                 'conlength' => '1441',
                                 'subtype' => 'PIF-Harbinger',
                                 'equiv' => [
                                              {
                                                'name' => 'Harbinger-2B_DRh',
                                                'ranges' => [
                                                              {
                                                                'div' => '1.00',
                                                                'score' => '625',
                                                                'eqstart' => '1',
                                                                'eqend' => '693',
                                                                'start' => '1',
                                                                'end' => '701'
                                                              },
                                                              {
                                                                'div' => '8.89',
                                                                'score' => '86',
                                                                'eqstart' => '693',
                                                                'eqend' => '827',
                                                                'start' => '1',
                                                                'end' => '135'
                                                              },
                                                              {
                                                                'div' => '7.97',
                                                                'score' => '93',
                                                                'eqstart' => '690',
                                                                'eqend' => '827',
                                                                'start' => '740',
                                                                'end' => '877'
                                                              },
                                                              {
                                                                'div' => '1.14',
                                                                'score' => '612',
                                                                'eqstart' => '1',
                                                                'eqend' => '690',
                                                                'start' => '743',
                                                                'end' => '1441'
                                                              }
                                                            ]
                                              }
                                            ],
                                 'type' => 'DNA'
                               },
          'oste17' => {
                        'conlength' => '734',
                        'subtype' => 'MULE-MuDR',
                        'equiv' => [],
                        'type' => 'DNA'
                      },
          'harbinger-2_bf' => {
                                'conlength' => '3179',
                                'subtype' => 'PIF-Harbinger',
                                'equiv' => [
                                             {
                                               'name' => 'Harbinger-2N1_BF',
                                               'ranges' => [
                                                             {
                                                               'div' => '3.04',
                                                               'score' => '217',
                                                               'eqstart' => 1031,
                                                               'eqend' => 1293,
                                                               'start' => 5419,
                                                               'end' => 5681
                                                             }
                                                           ]
                                             }
                                           ],
                                'type' => 'DNA'
                              },
          'mariner-21_dk' => {
                               'conlength' => '1619',
                               'subtype' => 'TcMar-Tc1',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'kiddod' => {
                        'conlength' => '279',
                        'subtype' => 'PIF-Harbinger',
                        'equiv' => [],
                        'type' => 'DNA'
                      },
          'enspm-n5_bf' => {
                             'conlength' => '3450',
                             'subtype' => 'CMC-EnSpm?',
                             'equiv' => [
                                          {
                                            'name' => 'hAT-N3_BF',
                                            'ranges' => [
                                                          {
                                                            'div' => '0.00',
                                                            'score' => '223',
                                                            'eqstart' => 1166,
                                                            'eqend' => 1410,
                                                            'start' => 1806,
                                                            'end' => 2055
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'dna-6-n5_dr' => {
                             'conlength' => '3301',
                             'subtype' => undef,
                             'equiv' => [
                                          {
                                            'name' => 'TDR19',
                                            'ranges' => [
                                                          {
                                                            'div' => '9.21',
                                                            'score' => '50',
                                                            'eqstart' => 99,
                                                            'eqend' => 175,
                                                            'start' => 1553,
                                                            'end' => 1628
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '7.32',
                                                            'score' => '60',
                                                            'eqstart' => 203,
                                                            'eqend' => 284,
                                                            'start' => 1553,
                                                            'end' => 1634
                                                          },
                                                          {
                                                            'div' => '9.09',
                                                            'score' => '32',
                                                            'eqstart' => 246,
                                                            'eqend' => 289,
                                                            'start' => 1700,
                                                            'end' => 1743
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '9.30',
                                                            'score' => '33',
                                                            'eqstart' => 95,
                                                            'eqend' => 137,
                                                            'start' => 1700,
                                                            'end' => 1742
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'isl2eu-n11_cgi' => {
                                'conlength' => '972',
                                'subtype' => 'PIF-Spy',
                                'equiv' => [],
                                'type' => 'DNA'
                              },
          'dna8-32_ap' => {
                            'conlength' => '240',
                            'subtype' => 'hAT-Charlie',
                            'equiv' => [
                                         {
                                           'name' => 'DNA8-33_AP',
                                           'ranges' => [
                                                         {
                                                           'div' => '3.57',
                                                           'score' => '38',
                                                           'eqstart' => 1,
                                                           'eqend' => 56,
                                                           'start' => 1,
                                                           'end' => 56
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'rehavkus-3_tc' => {
                               'conlength' => '18218',
                               'subtype' => 'MULE-NOF',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'dna2-2_cq' => {
                           'conlength' => '4736',
                           'subtype' => 'hAT-Tip100',
                           'equiv' => [
                                        {
                                          'name' => 'Shinagawa-1_CQ',
                                          'ranges' => [
                                                        {
                                                          'compl' => 1,
                                                          'div' => '9.38',
                                                          'score' => '43',
                                                          'eqstart' => 1199,
                                                          'eqend' => 1262,
                                                          'start' => 3633,
                                                          'end' => 3696
                                                        }
                                                      ]
                                        }
                                      ],
                           'type' => 'DNA'
                         },
          'dna8-74_ap' => {
                            'conlength' => '902',
                            'subtype' => 'hAT-hAT19',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'mdr1' => {
                      'conlength' => '7383',
                      'subtype' => 'MULE-MuDR',
                      'equiv' => [
                                   {
                                     'name' => 'OSTE33',
                                     'ranges' => [
                                                   {
                                                     'compl' => 1,
                                                     'div' => '10.47',
                                                     'score' => '48',
                                                     'eqstart' => 907,
                                                     'eqend' => 993,
                                                     'start' => 1,
                                                     'end' => 86
                                                   },
                                                   {
                                                     'compl' => 1,
                                                     'div' => '12.59',
                                                     'score' => '59',
                                                     'eqstart' => 31,
                                                     'eqend' => 164,
                                                     'start' => 7239,
                                                     'end' => 7373
                                                   }
                                                 ]
                                   }
                                 ],
                      'type' => 'DNA'
                    },
          'tgm1_gm' => {
                         'conlength' => '3516',
                         'subtype' => 'CMC-EnSpm',
                         'equiv' => [
                                      {
                                        'name' => 'EnSpm-1_GM',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '9.47',
                                                        'score' => '94',
                                                        'eqstart' => '7535',
                                                        'eqend' => '7845',
                                                        'start' => '1',
                                                        'end' => '338'
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '5.26',
                                                        'score' => '32',
                                                        'eqstart' => '7407',
                                                        'eqend' => '7444',
                                                        'start' => '302',
                                                        'end' => '339'
                                                      },
                                                      {
                                                        'div' => '7.46',
                                                        'score' => '35',
                                                        'eqstart' => '7329',
                                                        'eqend' => '7398',
                                                        'start' => '415',
                                                        'end' => '481'
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '5.00',
                                                        'score' => '30',
                                                        'eqstart' => '7617',
                                                        'eqend' => '7657',
                                                        'start' => '551',
                                                        'end' => '590'
                                                      },
                                                      {
                                                        'div' => '4.44',
                                                        'score' => '33',
                                                        'eqstart' => '7366',
                                                        'eqend' => '7443',
                                                        'start' => '556',
                                                        'end' => '645'
                                                      },
                                                      {
                                                        'div' => '4.93',
                                                        'score' => '32',
                                                        'eqstart' => '7492',
                                                        'eqend' => '7609',
                                                        'start' => '556',
                                                        'end' => '697'
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '4.88',
                                                        'score' => '34',
                                                        'eqstart' => '7617',
                                                        'eqend' => '7657',
                                                        'start' => '604',
                                                        'end' => '644'
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '4.88',
                                                        'score' => '34',
                                                        'eqstart' => '7617',
                                                        'eqend' => '7657',
                                                        'start' => '658',
                                                        'end' => '698'
                                                      },
                                                      {
                                                        'div' => '2.70',
                                                        'score' => '34',
                                                        'eqstart' => '7534',
                                                        'eqend' => '7570',
                                                        'start' => '663',
                                                        'end' => '699'
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'MuDR-9_GM',
                                        'ranges' => [
                                                      {
                                                        'div' => '11.76',
                                                        'score' => '41',
                                                        'eqstart' => '856',
                                                        'eqend' => '940',
                                                        'start' => '3149',
                                                        'end' => '3233'
                                                      }
                                                    ]
                                      }
                                    ],
                         'type' => 'DNA'
                       },
          'dada-ta_ol' => {
                            'conlength' => '2940',
                            'subtype' => 'Dada',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'te-2_cq' => {
                         'conlength' => '1334',
                         'subtype' => undef,
                         'equiv' => [],
                         'type' => 'DNA'
                       },
          'simpleguy1' => {
                            'conlength' => '747',
                            'subtype' => 'PIF-Harbinger',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'shinagawa-3_aae' => {
                                 'conlength' => '1822',
                                 'subtype' => undef,
                                 'equiv' => [
                                              {
                                                'name' => 'Shinagawa-4_AAe',
                                                'ranges' => [
                                                              {
                                                                'div' => '2.81',
                                                                'score' => '154',
                                                                'eqstart' => '1',
                                                                'eqend' => '178',
                                                                'start' => '1',
                                                                'end' => '178'
                                                              },
                                                              {
                                                                'compl' => 1,
                                                                'div' => '7.38',
                                                                'score' => '69',
                                                                'eqstart' => '2409',
                                                                'eqend' => '2531',
                                                                'start' => '11',
                                                                'end' => '132'
                                                              },
                                                              {
                                                                'div' => '12.23',
                                                                'score' => '66',
                                                                'eqstart' => '1557',
                                                                'eqend' => '1695',
                                                                'start' => '1377',
                                                                'end' => '1515'
                                                              },
                                                              {
                                                                'div' => '6.09',
                                                                'score' => '144',
                                                                'eqstart' => '2361',
                                                                'eqend' => '2556',
                                                                'start' => '1686',
                                                                'end' => '1882'
                                                              },
                                                              {
                                                                'compl' => 1,
                                                                'div' => '8.94',
                                                                'score' => '62',
                                                                'eqstart' => '11',
                                                                'eqend' => '132',
                                                                'start' => '1735',
                                                                'end' => '1857'
                                                              },
                                                              {
                                                                'compl' => 1,
                                                                'div' => '5.13',
                                                                'score' => '30',
                                                                'eqstart' => '108',
                                                                'eqend' => '146',
                                                                'start' => '1784',
                                                                'end' => '1822'
                                                              }
                                                            ]
                                              },
                                              {
                                                'name' => 'Shinagawa-1_AAe',
                                                'ranges' => [
                                                              {
                                                                'div' => '5.17',
                                                                'score' => '38',
                                                                'eqstart' => '90',
                                                                'eqend' => '149',
                                                                'start' => '57',
                                                                'end' => '114'
                                                              },
                                                              {
                                                                'div' => '12.59',
                                                                'score' => '53',
                                                                'eqstart' => '2108',
                                                                'eqend' => '2244',
                                                                'start' => '1737',
                                                                'end' => '1871'
                                                              },
                                                              {
                                                                'compl' => 1,
                                                                'div' => '11.67',
                                                                'score' => '50',
                                                                'eqstart' => '26',
                                                                'eqend' => '148',
                                                                'start' => '1753',
                                                                'end' => '1872'
                                                              }
                                                            ]
                                              },
                                              {
                                                'name' => 'Shinagawa-5_AAe',
                                                'ranges' => [
                                                              {
                                                                'div' => '4.07',
                                                                'score' => '155',
                                                                'eqstart' => '1',
                                                                'eqend' => '217',
                                                                'start' => '1',
                                                                'end' => '221'
                                                              },
                                                              {
                                                                'compl' => 1,
                                                                'div' => '9.24',
                                                                'score' => '60',
                                                                'eqstart' => '1957',
                                                                'eqend' => '2076',
                                                                'start' => '14',
                                                                'end' => '132'
                                                              },
                                                              {
                                                                'div' => '5.64',
                                                                'score' => '141',
                                                                'eqstart' => '1913',
                                                                'eqend' => '2104',
                                                                'start' => '1688',
                                                                'end' => '1882'
                                                              },
                                                              {
                                                                'compl' => 1,
                                                                'div' => '9.76',
                                                                'score' => '59',
                                                                'eqstart' => '11',
                                                                'eqend' => '132',
                                                                'start' => '1735',
                                                                'end' => '1857'
                                                              },
                                                              {
                                                                'compl' => 1,
                                                                'div' => '5.13',
                                                                'score' => '30',
                                                                'eqstart' => '108',
                                                                'eqend' => '146',
                                                                'start' => '1784',
                                                                'end' => '1822'
                                                              }
                                                            ]
                                              }
                                            ],
                                 'type' => 'DNA'
                               },
          'tc1-3_fr' => {
                          'conlength' => '1595',
                          'subtype' => 'TcMar-Tc1',
                          'equiv' => [],
                          'type' => 'DNA'
                        },
          'dada-ty_pmar' => {
                              'conlength' => '4281',
                              'subtype' => 'Dada',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'dna7-1_pgr' => {
                            'conlength' => '483',
                            'subtype' => undef,
                            'equiv' => [
                                         {
                                           'name' => 'DNA7-1B_PGr',
                                           'ranges' => [
                                                         {
                                                           'div' => '12.80',
                                                           'score' => '84',
                                                           'eqstart' => '194',
                                                           'eqend' => '477',
                                                           'start' => '195',
                                                           'end' => '483'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA7-1E_PGr',
                                           'ranges' => [
                                                         {
                                                           'div' => '11.90',
                                                           'score' => '45',
                                                           'eqstart' => '1',
                                                           'eqend' => '84',
                                                           'start' => '1',
                                                           'end' => '84'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA7-1C_PGr',
                                           'ranges' => [
                                                         {
                                                           'div' => '11.95',
                                                           'score' => '186',
                                                           'eqstart' => '1',
                                                           'eqend' => '470',
                                                           'start' => '1',
                                                           'end' => '477'
                                                         },
                                                         {
                                                           'div' => '8.93',
                                                           'score' => '39',
                                                           'eqstart' => '275',
                                                           'eqend' => '330',
                                                           'start' => '355',
                                                           'end' => '410'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'DNA7-1F_PGr',
                                           'ranges' => [
                                                         {
                                                           'div' => '10.91',
                                                           'score' => '30',
                                                           'eqstart' => '417',
                                                           'eqend' => '471',
                                                           'start' => '423',
                                                           'end' => '477'
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'kolobok-n2_cgi' => {
                                'conlength' => '965',
                                'subtype' => 'Kolobok',
                                'equiv' => [],
                                'type' => 'DNA'
                              },
          'homo6' => {
                       'conlength' => '3944',
                       'subtype' => 'hAT-Pegasus',
                       'equiv' => [],
                       'type' => 'DNA'
                     },
          'enspm2_ptr' => {
                            'conlength' => '3558',
                            'subtype' => 'CMC-EnSpm',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'mariner-n15_ag' => {
                                'conlength' => '249',
                                'subtype' => 'TcMar-ISRm11',
                                'equiv' => [],
                                'type' => 'DNA'
                              },
          'transib-8_drh' => {
                               'conlength' => '1060',
                               'subtype' => 'CMC-Transib',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'hat1_dr' => {
                         'conlength' => '3292',
                         'subtype' => 'hAT-Ac',
                         'equiv' => [
                                      {
                                        'name' => 'DNA2-1_DR',
                                        'ranges' => [
                                                      {
                                                        'div' => '10.49',
                                                        'score' => '94',
                                                        'eqstart' => 4138,
                                                        'eqend' => 4298,
                                                        'start' => 1,
                                                        'end' => 162
                                                      },
                                                      {
                                                        'div' => '10.71',
                                                        'score' => '68',
                                                        'eqstart' => 4985,
                                                        'eqend' => 5096,
                                                        'start' => 3181,
                                                        'end' => 3292
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Harbinger3_DR',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '43',
                                                        'eqstart' => 2046,
                                                        'eqend' => 2102,
                                                        'start' => 591,
                                                        'end' => 647
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'hAT-N76_DR',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '7.14',
                                                        'score' => '30',
                                                        'eqstart' => 2325,
                                                        'eqend' => 2380,
                                                        'start' => 589,
                                                        'end' => 644
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'HAT1N_DR',
                                        'ranges' => [
                                                      {
                                                        'div' => '9.32',
                                                        'score' => '101',
                                                        'eqstart' => 1,
                                                        'eqend' => 160,
                                                        'start' => 1,
                                                        'end' => 161
                                                      },
                                                      {
                                                        'div' => '8.93',
                                                        'score' => '74',
                                                        'eqstart' => 854,
                                                        'eqend' => 965,
                                                        'start' => 3181,
                                                        'end' => 3292
                                                      }
                                                    ]
                                      }
                                    ],
                         'type' => 'DNA'
                       },
          'dna-3_mad' => {
                           'conlength' => '137',
                           'subtype' => undef,
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'crypton-n7_cgi' => {
                                'conlength' => '1128',
                                'subtype' => 'Crypton-A',
                                'equiv' => [
                                             {
                                               'name' => 'Crypton-N13_CGi',
                                               'ranges' => [
                                                             {
                                                               'div' => '11.76',
                                                               'score' => '40',
                                                               'eqstart' => '239',
                                                               'eqend' => '306',
                                                               'start' => '1015',
                                                               'end' => '1082'
                                                             }
                                                           ]
                                             },
                                             {
                                               'name' => 'Crypton-10N1_CGi',
                                               'ranges' => [
                                                             {
                                                               'div' => '5.88',
                                                               'score' => '38',
                                                               'eqstart' => '215',
                                                               'eqend' => '265',
                                                               'start' => '1023',
                                                               'end' => '1073'
                                                             }
                                                           ]
                                             },
                                             {
                                               'name' => 'Crypton-10N2_CGi',
                                               'ranges' => [
                                                             {
                                                               'div' => '9.80',
                                                               'score' => '32',
                                                               'eqstart' => '288',
                                                               'eqend' => '338',
                                                               'start' => '1023',
                                                               'end' => '1073'
                                                             }
                                                           ]
                                             }
                                           ],
                                'type' => 'DNA'
                              },
          'harbinger3_tp' => {
                               'conlength' => '3954',
                               'subtype' => 'PIF-Harbinger',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'enspm-n21_sbi' => {
                               'conlength' => '3881',
                               'subtype' => 'CMC-EnSpm',
                               'equiv' => [
                                            {
                                              'name' => 'EnSpm-42_SBi',
                                              'ranges' => [
                                                            {
                                                              'compl' => 1,
                                                              'div' => '6.51',
                                                              'score' => '249',
                                                              'eqstart' => 8471,
                                                              'eqend' => 8892,
                                                              'start' => 1,
                                                              'end' => 430
                                                            },
                                                            {
                                                              'compl' => 1,
                                                              'div' => '7.08',
                                                              'score' => '137',
                                                              'eqstart' => 5920,
                                                              'eqend' => 6149,
                                                              'start' => 1140,
                                                              'end' => 1365
                                                            }
                                                          ]
                                            }
                                          ],
                               'type' => 'DNA'
                             },
          'transib-2_dk' => {
                              'conlength' => '910',
                              'subtype' => 'CMC-Transib',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'mudr5x_ap' => {
                           'conlength' => '2680',
                           'subtype' => 'MULE-MuDR',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'polinton-4_nv' => {
                               'conlength' => '13070',
                               'subtype' => 'Maverick',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'enspm-8_zm' => {
                            'conlength' => '8071',
                            'subtype' => 'CMC-EnSpm',
                            'equiv' => [
                                         {
                                           'name' => 'ENSPM-5_ZM',
                                           'ranges' => [
                                                         {
                                                           'div' => '6.41',
                                                           'score' => '46',
                                                           'eqstart' => 2079,
                                                           'eqend' => 2155,
                                                           'start' => 2252,
                                                           'end' => 2329
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'hat-n21_crp' => {
                             'conlength' => '925',
                             'subtype' => 'hAT',
                             'equiv' => [
                                          {
                                            'name' => 'DNA-151_Ami',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '4.84',
                                                            'score' => '33',
                                                            'eqstart' => '315',
                                                            'eqend' => '377',
                                                            'start' => '1150',
                                                            'end' => '1211'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N2B_AMi',
                                            'ranges' => [
                                                          {
                                                            'div' => '8.00',
                                                            'score' => '31',
                                                            'eqstart' => '628',
                                                            'eqend' => '701',
                                                            'start' => '1137',
                                                            'end' => '1211'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N4_Gav',
                                            'ranges' => [
                                                          {
                                                            'div' => '9.55',
                                                            'score' => '64',
                                                            'eqstart' => '1',
                                                            'eqend' => '160',
                                                            'start' => '1',
                                                            'end' => '157'
                                                          },
                                                          {
                                                            'div' => '5.56',
                                                            'score' => '53',
                                                            'eqstart' => '950',
                                                            'eqend' => '1096',
                                                            'start' => '1050',
                                                            'end' => '1211'
                                                          },
                                                          {
                                                            'div' => '5.32',
                                                            'score' => '55',
                                                            'eqstart' => '1123',
                                                            'eqend' => '1217',
                                                            'start' => '1424',
                                                            'end' => '1517'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-243_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '8.33',
                                                            'score' => '37',
                                                            'eqstart' => '490',
                                                            'eqend' => '575',
                                                            'start' => '515',
                                                            'end' => '598'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '4.92',
                                                            'score' => '33',
                                                            'eqstart' => '514',
                                                            'eqend' => '575',
                                                            'start' => '864',
                                                            'end' => '924'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N19_AMi',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '10.84',
                                                            'score' => '44',
                                                            'eqstart' => '702',
                                                            'eqend' => '862',
                                                            'start' => '422',
                                                            'end' => '587'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '4.84',
                                                            'score' => '38',
                                                            'eqstart' => '1099',
                                                            'eqend' => '1160',
                                                            'start' => '1150',
                                                            'end' => '1211'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N2_AMi',
                                            'ranges' => [
                                                          {
                                                            'div' => '0.00',
                                                            'score' => '34',
                                                            'eqstart' => '130',
                                                            'eqend' => '164',
                                                            'start' => '129',
                                                            'end' => '163'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-1598_Gav',
                                            'ranges' => [
                                                          {
                                                            'div' => '7.46',
                                                            'score' => '31',
                                                            'eqstart' => '615',
                                                            'eqend' => '683',
                                                            'start' => '1145',
                                                            'end' => '1211'
                                                          },
                                                          {
                                                            'div' => '3.23',
                                                            'score' => '36',
                                                            'eqstart' => '790',
                                                            'eqend' => '852',
                                                            'start' => '1150',
                                                            'end' => '1211'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N10_AMi',
                                            'ranges' => [
                                                          {
                                                            'div' => '9.29',
                                                            'score' => '44',
                                                            'eqstart' => '360',
                                                            'eqend' => '543',
                                                            'start' => '405',
                                                            'end' => '587'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N18_Crp',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.90',
                                                            'score' => '31',
                                                            'eqstart' => '330',
                                                            'eqend' => '414',
                                                            'start' => '545',
                                                            'end' => '628'
                                                          },
                                                          {
                                                            'div' => '12.13',
                                                            'score' => '54',
                                                            'eqstart' => '329',
                                                            'eqend' => '583',
                                                            'start' => '833',
                                                            'end' => '1071'
                                                          },
                                                          {
                                                            'div' => '4.17',
                                                            'score' => '31',
                                                            'eqstart' => '603',
                                                            'eqend' => '671',
                                                            'start' => '1140',
                                                            'end' => '1211'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-8_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '12.00',
                                                            'score' => '43',
                                                            'eqstart' => '1990',
                                                            'eqend' => '2144',
                                                            'start' => '1',
                                                            'end' => '150'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-191_Ami',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '10.47',
                                                            'score' => '233',
                                                            'eqstart' => '697',
                                                            'eqend' => '1360',
                                                            'start' => '1',
                                                            'end' => '678'
                                                          },
                                                          {
                                                            'div' => '10.75',
                                                            'score' => '68',
                                                            'eqstart' => '391',
                                                            'eqend' => '597',
                                                            'start' => '465',
                                                            'end' => '678'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '10.56',
                                                            'score' => '39',
                                                            'eqstart' => '472',
                                                            'eqend' => '627',
                                                            'start' => '752',
                                                            'end' => '912'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '2.88',
                                                            'score' => '59',
                                                            'eqstart' => '179',
                                                            'eqend' => '303',
                                                            'start' => '1051',
                                                            'end' => '1189'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-16_Ami',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '3.77',
                                                            'score' => '31',
                                                            'eqstart' => '104',
                                                            'eqend' => '157',
                                                            'start' => '1159',
                                                            'end' => '1211'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N11_AMi',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '0.00',
                                                            'score' => '34',
                                                            'eqstart' => '1352',
                                                            'eqend' => '1386',
                                                            'start' => '129',
                                                            'end' => '163'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '4.25',
                                                            'score' => '209',
                                                            'eqstart' => '1',
                                                            'eqend' => '314',
                                                            'start' => '1212',
                                                            'end' => '1517'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N11B_AMi',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '5.23',
                                                            'score' => '946',
                                                            'eqstart' => '24',
                                                            'eqend' => '1540',
                                                            'start' => '1',
                                                            'end' => '1473'
                                                          },
                                                          {
                                                            'div' => '10.66',
                                                            'score' => '117',
                                                            'eqstart' => '599',
                                                            'eqend' => '1008',
                                                            'start' => '532',
                                                            'end' => '925'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '2.27',
                                                            'score' => '40',
                                                            'eqstart' => '1',
                                                            'eqend' => '44',
                                                            'start' => '1474',
                                                            'end' => '1517'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N21B_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '6.33',
                                                            'score' => '51',
                                                            'eqstart' => '474',
                                                            'eqend' => '552',
                                                            'start' => '1050',
                                                            'end' => '1128'
                                                          },
                                                          {
                                                            'div' => '7.45',
                                                            'score' => '50',
                                                            'eqstart' => '698',
                                                            'eqend' => '791',
                                                            'start' => '1424',
                                                            'end' => '1517'
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'dna-at-4_dr' => {
                             'conlength' => '951',
                             'subtype' => 'PIF-ISL2EU',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'rahat' => {
                       'conlength' => '422',
                       'subtype' => 'hAT-Tip100',
                       'equiv' => [],
                       'type' => 'DNA'
                     },
          'rehavkus1_ap' => {
                              'conlength' => '4714',
                              'subtype' => 'MULE-NOF',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'atrep17' => {
                         'conlength' => '1268',
                         'subtype' => 'MULE-MuDR',
                         'equiv' => [],
                         'type' => 'DNA'
                       },
          'mariner-n2_pgr' => {
                                'conlength' => '676',
                                'subtype' => 'TcMar-Tc1',
                                'equiv' => [],
                                'type' => 'DNA'
                              },
          'mudrash4_mt' => {
                             'conlength' => '381',
                             'subtype' => 'MULE-MuDR',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'mer97a' => {
                        'conlength' => '890',
                        'subtype' => 'hAT-Tip100',
                        'equiv' => [
                                     {
                                       'name' => 'MER97c',
                                       'ranges' => [
                                                     {
                                                       'div' => '0.14',
                                                       'score' => '707',
                                                       'eqstart' => 1,
                                                       'eqend' => 721,
                                                       'start' => 1,
                                                       'end' => 721
                                                     },
                                                     {
                                                       'div' => '0.00',
                                                       'score' => '93',
                                                       'eqstart' => 1036,
                                                       'eqend' => 1129,
                                                       'start' => 797,
                                                       'end' => 890
                                                     }
                                                   ]
                                     },
                                     {
                                       'name' => 'MER97d',
                                       'ranges' => [
                                                     {
                                                       'div' => '0.00',
                                                       'score' => '660',
                                                       'eqstart' => 1,
                                                       'eqend' => 668,
                                                       'start' => 1,
                                                       'end' => 668
                                                     },
                                                     {
                                                       'div' => '0.00',
                                                       'score' => '93',
                                                       'eqstart' => 1112,
                                                       'eqend' => 1205,
                                                       'start' => 797,
                                                       'end' => 890
                                                     }
                                                   ]
                                     },
                                     {
                                       'name' => 'Zaphod3',
                                       'ranges' => [
                                                     {
                                                       'div' => '0.13',
                                                       'score' => '746',
                                                       'eqstart' => 1,
                                                       'eqend' => 776,
                                                       'start' => 1,
                                                       'end' => 780
                                                     },
                                                     {
                                                       'div' => '0.00',
                                                       'score' => '93',
                                                       'eqstart' => 2531,
                                                       'eqend' => '2624',
                                                       'start' => 797,
                                                       'end' => 890
                                                     }
                                                   ]
                                     },
                                     {
                                       'name' => 'MER97b',
                                       'ranges' => [
                                                     {
                                                       'div' => '0.00',
                                                       'score' => '747',
                                                       'eqstart' => 1,
                                                       'eqend' => 776,
                                                       'start' => 1,
                                                       'end' => 780
                                                     },
                                                     {
                                                       'div' => '0.00',
                                                       'score' => '93',
                                                       'eqstart' => 956,
                                                       'eqend' => 1049,
                                                       'start' => 797,
                                                       'end' => 890
                                                     }
                                                   ]
                                     }
                                   ],
                        'type' => 'DNA'
                      },
          'parisa-2_dw' => {
                             'conlength' => '1695',
                             'subtype' => 'TcMar-Tc1',
                             'equiv' => [
                                          {
                                            'name' => 'PARISa-5_DW',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '9.17',
                                                            'score' => '51',
                                                            'eqstart' => '1252',
                                                            'eqend' => '1470',
                                                            'start' => '1',
                                                            'end' => '240'
                                                          },
                                                          {
                                                            'div' => '9.56',
                                                            'score' => '244',
                                                            'eqstart' => '23',
                                                            'eqend' => '544',
                                                            'start' => '97',
                                                            'end' => '640'
                                                          },
                                                          {
                                                            'div' => '5.92',
                                                            'score' => '355',
                                                            'eqstart' => '544',
                                                            'eqend' => '1055',
                                                            'start' => '705',
                                                            'end' => '1228'
                                                          },
                                                          {
                                                            'div' => '9.36',
                                                            'score' => '187',
                                                            'eqstart' => '1055',
                                                            'eqend' => '1470',
                                                            'start' => '1258',
                                                            'end' => '1695'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.03',
                                                            'score' => '48',
                                                            'eqstart' => '23',
                                                            'eqend' => '160',
                                                            'start' => '1455',
                                                            'end' => '1599'
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'tdr17' => {
                       'conlength' => '248',
                       'subtype' => 'Sola-1',
                       'equiv' => [],
                       'type' => 'DNA'
                     },
          'hat-n1_md' => {
                           'conlength' => '495',
                           'subtype' => 'hAT-Tip100',
                           'equiv' => [
                                        {
                                          'name' => 'hAT-N1B_MD',
                                          'ranges' => [
                                                        {
                                                          'div' => '0.00',
                                                          'score' => '71',
                                                          'eqstart' => 81,
                                                          'eqend' => 159,
                                                          'start' => 141,
                                                          'end' => 220
                                                        },
                                                        {
                                                          'div' => '9.32',
                                                          'score' => '64',
                                                          'eqstart' => 218,
                                                          'eqend' => 335,
                                                          'start' => 378,
                                                          'end' => 495
                                                        }
                                                      ]
                                        }
                                      ],
                           'type' => 'DNA'
                         },
          'hatm-21_hm' => {
                            'conlength' => '2905',
                            'subtype' => 'hAT-hATm',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'dna-2-2_nv' => {
                            'conlength' => '273',
                            'subtype' => undef,
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'mariner-4n1_xt' => {
                                'conlength' => '258',
                                'subtype' => 'TcMar-Tc2',
                                'equiv' => [
                                             {
                                               'name' => 'Mariner-3N1_XT',
                                               'ranges' => [
                                                             {
                                                               'div' => '10.99',
                                                               'score' => '43',
                                                               'eqstart' => 430,
                                                               'eqend' => 520,
                                                               'start' => 168,
                                                               'end' => 258
                                                             }
                                                           ]
                                             },
                                             {
                                               'name' => 'Mariner-3_XT',
                                               'ranges' => [
                                                             {
                                                               'div' => '10.99',
                                                               'score' => '43',
                                                               'eqstart' => 1494,
                                                               'eqend' => 1584,
                                                               'start' => 168,
                                                               'end' => 258
                                                             }
                                                           ]
                                             },
                                             {
                                               'name' => 'Mariner-4_XT',
                                               'ranges' => [
                                                             {
                                                               'div' => '4.76',
                                                               'score' => '66',
                                                               'eqstart' => 5,
                                                               'eqend' => 105,
                                                               'start' => 5,
                                                               'end' => 109
                                                             },
                                                             {
                                                               'div' => '1.69',
                                                               'score' => '104',
                                                               'eqstart' => 2493,
                                                               'eqend' => 2610,
                                                               'start' => 138,
                                                               'end' => 255
                                                             }
                                                           ]
                                             }
                                           ],
                                'type' => 'DNA'
                              },
          'piggybac-1_sm' => {
                               'conlength' => '2434',
                               'subtype' => 'PiggyBac',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'dna4-3_ap' => {
                           'conlength' => '637',
                           'subtype' => undef,
                           'equiv' => [
                                        {
                                          'name' => 'DNA8-1_AP',
                                          'ranges' => [
                                                        {
                                                          'div' => '5.45',
                                                          'score' => '35',
                                                          'eqstart' => 162,
                                                          'eqend' => 216,
                                                          'start' => 19,
                                                          'end' => 73
                                                        },
                                                        {
                                                          'div' => '10.60',
                                                          'score' => '112',
                                                          'eqstart' => '308',
                                                          'eqend' => '523',
                                                          'start' => 184,
                                                          'end' => '400'
                                                        },
                                                        {
                                                          'compl' => 1,
                                                          'div' => '3.92',
                                                          'score' => '32',
                                                          'eqstart' => 166,
                                                          'eqend' => 216,
                                                          'start' => 565,
                                                          'end' => 615
                                                        }
                                                      ]
                                        }
                                      ],
                           'type' => 'DNA'
                         },
          'hat-28_hm' => {
                           'conlength' => '6750',
                           'subtype' => 'hAT-Ac',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'dna9-13_mad' => {
                             'conlength' => '590',
                             'subtype' => undef,
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'mariner-n1_sp' => {
                               'conlength' => '569',
                               'subtype' => 'TcMar-Tc2',
                               'equiv' => [
                                            {
                                              'name' => 'hAT-N1_SP',
                                              'ranges' => [
                                                            {
                                                              'div' => '4.34',
                                                              'score' => '250',
                                                              'eqstart' => 113,
                                                              'eqend' => 489,
                                                              'start' => 94,
                                                              'end' => 485
                                                            }
                                                          ]
                                            }
                                          ],
                               'type' => 'DNA'
                             },
          'hat-33_hm' => {
                           'conlength' => '3017',
                           'subtype' => 'hAT-hAT5',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'oste15' => {
                        'conlength' => '1168',
                        'subtype' => 'MULE-MuDR',
                        'equiv' => [
                                     {
                                       'name' => 'OSMU5',
                                       'ranges' => [
                                                     {
                                                       'compl' => 1,
                                                       'div' => '10.00',
                                                       'score' => '31',
                                                       'eqstart' => 1,
                                                       'eqend' => 59,
                                                       'start' => 1105,
                                                       'end' => 1164
                                                     }
                                                   ]
                                     }
                                   ],
                        'type' => 'DNA'
                      },
          'mariner-n320_ami' => {
                                  'conlength' => '251',
                                  'subtype' => 'TcMar-Tigger',
                                  'equiv' => [
                                               {
                                                 'name' => 'Mariner-7_Croc',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '10.53',
                                                                 'score' => '67',
                                                                 'eqstart' => '1',
                                                                 'eqend' => '113',
                                                                 'start' => '1',
                                                                 'end' => '114'
                                                               },
                                                               {
                                                                 'div' => '5.19',
                                                                 'score' => '56',
                                                                 'eqstart' => '2260',
                                                                 'eqend' => '2335',
                                                                 'start' => '175',
                                                                 'end' => '251'
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'Mariner-N1743_AMi',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '8.18',
                                                                 'score' => '71',
                                                                 'eqstart' => '1',
                                                                 'eqend' => '110',
                                                                 'start' => '1',
                                                                 'end' => '110'
                                                               }
                                                             ]
                                               }
                                             ],
                                  'type' => 'DNA'
                                },
          'harbinger-3c_pst' => {
                                  'conlength' => '3521',
                                  'subtype' => 'PIF-Harbinger',
                                  'equiv' => [
                                               {
                                                 'name' => 'Harbinger-3B_PSt',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '10.22',
                                                                 'score' => '1837',
                                                                 'eqstart' => '1',
                                                                 'eqend' => '3555',
                                                                 'start' => '1',
                                                                 'end' => '3521'
                                                               }
                                                             ]
                                               },
                                               {
                                                 'name' => 'Harbinger-3_PSt',
                                                 'ranges' => [
                                                               {
                                                                 'div' => '11.63',
                                                                 'score' => '708',
                                                                 'eqstart' => '2066',
                                                                 'eqend' => '3595',
                                                                 'start' => '2009',
                                                                 'end' => '3521'
                                                               }
                                                             ]
                                               }
                                             ],
                                  'type' => 'DNA'
                                },
          'mudr-12_sbi' => {
                             'conlength' => '10041',
                             'subtype' => 'MULE-MuDR',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'mariner_am' => {
                            'conlength' => '937',
                            'subtype' => 'TcMar-Mariner',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'hat-12_vvi' => {
                            'conlength' => '1173',
                            'subtype' => 'hAT-Tag1',
                            'equiv' => [
                                         {
                                           'name' => 'VIHAT1',
                                           'ranges' => [
                                                         {
                                                           'div' => '11.39',
                                                           'score' => '48',
                                                           'eqstart' => '4478',
                                                           'eqend' => '4556',
                                                           'start' => '4151',
                                                           'end' => '4229'
                                                         },
                                                         {
                                                           'div' => '8.22',
                                                           'score' => '42',
                                                           'eqstart' => '5475',
                                                           'eqend' => '5547',
                                                           'start' => '5190',
                                                           'end' => '5262'
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'MUDRAVI1',
                                           'ranges' => [
                                                         {
                                                           'div' => '4.95',
                                                           'score' => '51',
                                                           'eqstart' => '5461',
                                                           'eqend' => '5564',
                                                           'start' => '5159',
                                                           'end' => '5259'
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'mermite-17' => {
                            'conlength' => '2759',
                            'subtype' => 'MULE-MuDR',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'mariner-2n1_xt' => {
                                'conlength' => '361',
                                'subtype' => 'TcMar-Tc2',
                                'equiv' => [
                                             {
                                               'name' => 'Mariner-2_XT',
                                               'ranges' => [
                                                             {
                                                               'div' => '4.88',
                                                               'score' => '126',
                                                               'eqstart' => 1,
                                                               'eqend' => 165,
                                                               'start' => 1,
                                                               'end' => 164
                                                             },
                                                             {
                                                               'div' => '6.06',
                                                               'score' => '71',
                                                               'eqstart' => 163,
                                                               'eqend' => 261,
                                                               'start' => 116,
                                                               'end' => 214
                                                             },
                                                             {
                                                               'div' => '1.75',
                                                               'score' => '91',
                                                               'eqstart' => 391,
                                                               'eqend' => 505,
                                                               'start' => 248,
                                                               'end' => 361
                                                             },
                                                             {
                                                               'div' => '1.79',
                                                               'score' => '87',
                                                               'eqstart' => 424,
                                                               'eqend' => 537,
                                                               'start' => 248,
                                                               'end' => 359
                                                             },
                                                             {
                                                               'div' => '0.88',
                                                               'score' => '89',
                                                               'eqstart' => 458,
                                                               'eqend' => 574,
                                                               'start' => 248,
                                                               'end' => 361
                                                             },
                                                             {
                                                               'div' => '1.79',
                                                               'score' => '87',
                                                               'eqstart' => 493,
                                                               'eqend' => 606,
                                                               'start' => 248,
                                                               'end' => 359
                                                             },
                                                             {
                                                               'div' => '0.97',
                                                               'score' => '78',
                                                               'eqstart' => 527,
                                                               'eqend' => 632,
                                                               'start' => 248,
                                                               'end' => 350
                                                             },
                                                             {
                                                               'div' => '2.90',
                                                               'score' => '47',
                                                               'eqstart' => 562,
                                                               'eqend' => 632,
                                                               'start' => 248,
                                                               'end' => 316
                                                             },
                                                             {
                                                               'div' => '1.22',
                                                               'score' => '65',
                                                               'eqstart' => 388,
                                                               'eqend' => 468,
                                                               'start' => 278,
                                                               'end' => 359
                                                             },
                                                             {
                                                               'div' => '2.00',
                                                               'score' => '36',
                                                               'eqstart' => 388,
                                                               'eqend' => 436,
                                                               'start' => 312,
                                                               'end' => 361
                                                             },
                                                             {
                                                               'div' => '0.82',
                                                               'score' => '112',
                                                               'eqstart' => 2317,
                                                               'eqend' => 2438,
                                                               'start' => 366,
                                                               'end' => 487
                                                             }
                                                           ]
                                             }
                                           ],
                                'type' => 'DNA'
                              },
          'hat-12b_crp' => {
                             'conlength' => '3405',
                             'subtype' => 'hAT-Ac',
                             'equiv' => [
                                          {
                                            'name' => 'hAT-353_Ami',
                                            'ranges' => [
                                                          {
                                                            'div' => '9.42',
                                                            'score' => '116',
                                                            'eqstart' => '863',
                                                            'eqend' => '1050',
                                                            'start' => '3288',
                                                            'end' => '3478'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N3_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '12.31',
                                                            'score' => '56',
                                                            'eqstart' => '1129',
                                                            'eqend' => '1332',
                                                            'start' => '3217',
                                                            'end' => '3411'
                                                          },
                                                          {
                                                            'div' => '10.77',
                                                            'score' => '32',
                                                            'eqstart' => '1105',
                                                            'eqend' => '1169',
                                                            'start' => '3339',
                                                            'end' => '3403'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N9_Gav',
                                            'ranges' => [
                                                          {
                                                            'div' => '11.02',
                                                            'score' => '69',
                                                            'eqstart' => '27',
                                                            'eqend' => '153',
                                                            'start' => '5',
                                                            'end' => '131'
                                                          },
                                                          {
                                                            'div' => '8.43',
                                                            'score' => '39',
                                                            'eqstart' => '712',
                                                            'eqend' => '794',
                                                            'start' => '3517',
                                                            'end' => '3599'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N4_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '6.72',
                                                            'score' => '62',
                                                            'eqstart' => '24',
                                                            'eqend' => '142',
                                                            'start' => '2',
                                                            'end' => '120'
                                                          },
                                                          {
                                                            'div' => '3.33',
                                                            'score' => '81',
                                                            'eqstart' => '234',
                                                            'eqend' => '323',
                                                            'start' => '227',
                                                            'end' => '316'
                                                          },
                                                          {
                                                            'div' => '7.95',
                                                            'score' => '200',
                                                            'eqstart' => '456',
                                                            'eqend' => '814',
                                                            'start' => '3243',
                                                            'end' => '3594'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N22_Croc',
                                            'ranges' => [
                                                          {
                                                            'div' => '6.67',
                                                            'score' => '92',
                                                            'eqstart' => '23',
                                                            'eqend' => '142',
                                                            'start' => '1',
                                                            'end' => '120'
                                                          },
                                                          {
                                                            'div' => '8.50',
                                                            'score' => '114',
                                                            'eqstart' => '1102',
                                                            'eqend' => '1254',
                                                            'start' => '3469',
                                                            'end' => '3621'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-4B_AMi',
                                            'ranges' => [
                                                          {
                                                            'div' => '9.07',
                                                            'score' => '1274',
                                                            'eqstart' => '841',
                                                            'eqend' => '3428',
                                                            'start' => '634',
                                                            'end' => '3136'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-12_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '11.94',
                                                            'score' => '66',
                                                            'eqstart' => '23',
                                                            'eqend' => '150',
                                                            'start' => '1',
                                                            'end' => '134'
                                                          },
                                                          {
                                                            'div' => '0.00',
                                                            'score' => '31',
                                                            'eqstart' => '2635',
                                                            'eqend' => '2670',
                                                            'start' => '34',
                                                            'end' => '70'
                                                          },
                                                          {
                                                            'div' => '2.65',
                                                            'score' => '2313',
                                                            'eqstart' => '156',
                                                            'eqend' => '2756',
                                                            'start' => '1011',
                                                            'end' => '3616'
                                                          },
                                                          {
                                                            'div' => '11.22',
                                                            'score' => '51',
                                                            'eqstart' => '2463',
                                                            'eqend' => '2560',
                                                            'start' => '3171',
                                                            'end' => '3268'
                                                          },
                                                          {
                                                            'div' => '9.28',
                                                            'score' => '59',
                                                            'eqstart' => '2317',
                                                            'eqend' => '2413',
                                                            'start' => '3317',
                                                            'end' => '3413'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-262_Ami',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '7.85',
                                                            'score' => '122',
                                                            'eqstart' => '157',
                                                            'eqend' => '344',
                                                            'start' => '3288',
                                                            'end' => '3478'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-46_Ami',
                                            'ranges' => [
                                                          {
                                                            'div' => '11.81',
                                                            'score' => '69',
                                                            'eqstart' => '23',
                                                            'eqend' => '149',
                                                            'start' => '1',
                                                            'end' => '127'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-1040_AMi',
                                            'ranges' => [
                                                          {
                                                            'div' => '1.57',
                                                            'score' => '121',
                                                            'eqstart' => '23',
                                                            'eqend' => '149',
                                                            'start' => '1',
                                                            'end' => '127'
                                                          },
                                                          {
                                                            'div' => '7.10',
                                                            'score' => '109',
                                                            'eqstart' => '1292',
                                                            'eqend' => '1452',
                                                            'start' => '3467',
                                                            'end' => '3621'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '7.32',
                                                            'score' => '34',
                                                            'eqstart' => '142',
                                                            'eqend' => '182',
                                                            'start' => '3467',
                                                            'end' => '3507'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-61_Ami',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '7.85',
                                                            'score' => '119',
                                                            'eqstart' => '147',
                                                            'eqend' => '334',
                                                            'start' => '3288',
                                                            'end' => '3478'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-112_ASi',
                                            'ranges' => [
                                                          {
                                                            'div' => '7.56',
                                                            'score' => '88',
                                                            'eqstart' => '24',
                                                            'eqend' => '142',
                                                            'start' => '2',
                                                            'end' => '120'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-11_AMi',
                                            'ranges' => [
                                                          {
                                                            'div' => '8.77',
                                                            'score' => '80',
                                                            'eqstart' => '199',
                                                            'eqend' => '312',
                                                            'start' => '203',
                                                            'end' => '316'
                                                          },
                                                          {
                                                            'div' => '6.16',
                                                            'score' => '1801',
                                                            'eqstart' => '448',
                                                            'eqend' => '3194',
                                                            'start' => '442',
                                                            'end' => '3154'
                                                          },
                                                          {
                                                            'div' => '10.34',
                                                            'score' => '46',
                                                            'eqstart' => '5565',
                                                            'eqend' => '5651',
                                                            'start' => '3171',
                                                            'end' => '3257'
                                                          },
                                                          {
                                                            'div' => '11.11',
                                                            'score' => '137',
                                                            'eqstart' => '5544',
                                                            'eqend' => '5801',
                                                            'start' => '3296',
                                                            'end' => '3556'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-74_AMi',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.94',
                                                            'score' => '31',
                                                            'eqstart' => '522',
                                                            'eqend' => '588',
                                                            'start' => '3337',
                                                            'end' => '3403'
                                                          },
                                                          {
                                                            'div' => '10.77',
                                                            'score' => '32',
                                                            'eqstart' => '949',
                                                            'eqend' => '1013',
                                                            'start' => '3339',
                                                            'end' => '3403'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N13_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '12.40',
                                                            'score' => '58',
                                                            'eqstart' => '1633',
                                                            'eqend' => '1753',
                                                            'start' => '3277',
                                                            'end' => '3397'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '11.28',
                                                            'score' => '65',
                                                            'eqstart' => '369',
                                                            'eqend' => '500',
                                                            'start' => '3277',
                                                            'end' => '3409'
                                                          },
                                                          {
                                                            'div' => '10.20',
                                                            'score' => '49',
                                                            'eqstart' => '1359',
                                                            'eqend' => '1457',
                                                            'start' => '3296',
                                                            'end' => '3393'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '9.65',
                                                            'score' => '61',
                                                            'eqstart' => '660',
                                                            'eqend' => '774',
                                                            'start' => '3296',
                                                            'end' => '3409'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N5888_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '6.67',
                                                            'score' => '86',
                                                            'eqstart' => '23',
                                                            'eqend' => '142',
                                                            'start' => '1',
                                                            'end' => '120'
                                                          },
                                                          {
                                                            'div' => '9.80',
                                                            'score' => '87',
                                                            'eqstart' => '1251',
                                                            'eqend' => '1409',
                                                            'start' => '3469',
                                                            'end' => '3621'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N9_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '7.45',
                                                            'score' => '69',
                                                            'eqstart' => '27',
                                                            'eqend' => '120',
                                                            'start' => '5',
                                                            'end' => '98'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N8_Crp',
                                            'ranges' => [
                                                          {
                                                            'compl' => 1,
                                                            'div' => '7.46',
                                                            'score' => '45',
                                                            'eqstart' => '746',
                                                            'eqend' => '812',
                                                            'start' => '234',
                                                            'end' => '300'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '7.87',
                                                            'score' => '77',
                                                            'eqstart' => '218',
                                                            'eqend' => '346',
                                                            'start' => '3277',
                                                            'end' => '3403'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '8.11',
                                                            'score' => '45',
                                                            'eqstart' => '360',
                                                            'eqend' => '433',
                                                            'start' => '3336',
                                                            'end' => '3409'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-4_AMi',
                                            'ranges' => [
                                                          {
                                                            'div' => '8.63',
                                                            'score' => '1341',
                                                            'eqstart' => '1184',
                                                            'eqend' => '3776',
                                                            'start' => '634',
                                                            'end' => '3136'
                                                          },
                                                          {
                                                            'div' => '7.89',
                                                            'score' => '71',
                                                            'eqstart' => '5047',
                                                            'eqend' => '5161',
                                                            'start' => '3298',
                                                            'end' => '3411'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-N9B_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '2.59',
                                                            'score' => '92',
                                                            'eqstart' => '27',
                                                            'eqend' => '142',
                                                            'start' => '5',
                                                            'end' => '120'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-17B_Croc',
                                            'ranges' => [
                                                          {
                                                            'div' => '8.59',
                                                            'score' => '49',
                                                            'eqstart' => '28',
                                                            'eqend' => '202',
                                                            'start' => '7',
                                                            'end' => '169'
                                                          },
                                                          {
                                                            'div' => '5.56',
                                                            'score' => '77',
                                                            'eqstart' => '221',
                                                            'eqend' => '310',
                                                            'start' => '227',
                                                            'end' => '316'
                                                          },
                                                          {
                                                            'div' => '5.00',
                                                            'score' => '38',
                                                            'eqstart' => '482',
                                                            'eqend' => '628',
                                                            'start' => '490',
                                                            'end' => '649'
                                                          },
                                                          {
                                                            'div' => '5.79',
                                                            'score' => '1784',
                                                            'eqstart' => '724',
                                                            'eqend' => '3276',
                                                            'start' => '634',
                                                            'end' => '3136'
                                                          },
                                                          {
                                                            'div' => '4.35',
                                                            'score' => '62',
                                                            'eqstart' => '4822',
                                                            'eqend' => '4917',
                                                            'start' => '3156',
                                                            'end' => '3247'
                                                          },
                                                          {
                                                            'div' => '11.57',
                                                            'score' => '100',
                                                            'eqstart' => '5430',
                                                            'eqend' => '5678',
                                                            'start' => '3170',
                                                            'end' => '3411'
                                                          },
                                                          {
                                                            'div' => '11.75',
                                                            'score' => '199',
                                                            'eqstart' => '5584',
                                                            'eqend' => '6042',
                                                            'start' => '3171',
                                                            'end' => '3621'
                                                          },
                                                          {
                                                            'div' => '8.33',
                                                            'score' => '63',
                                                            'eqstart' => '4796',
                                                            'eqend' => '4891',
                                                            'start' => '3276',
                                                            'end' => '3371'
                                                          },
                                                          {
                                                            'div' => '6.90',
                                                            'score' => '78',
                                                            'eqstart' => '5409',
                                                            'eqend' => '5525',
                                                            'start' => '3296',
                                                            'end' => '3411'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-6_AMi',
                                            'ranges' => [
                                                          {
                                                            'div' => '8.61',
                                                            'score' => '1322',
                                                            'eqstart' => '1074',
                                                            'eqend' => '3397',
                                                            'start' => '867',
                                                            'end' => '3153'
                                                          },
                                                          {
                                                            'div' => '11.00',
                                                            'score' => '106',
                                                            'eqstart' => '4714',
                                                            'eqend' => '5012',
                                                            'start' => '3170',
                                                            'end' => '3478'
                                                          },
                                                          {
                                                            'div' => '7.76',
                                                            'score' => '72',
                                                            'eqstart' => '4693',
                                                            'eqend' => '4809',
                                                            'start' => '3296',
                                                            'end' => '3411'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-2_Crp',
                                            'ranges' => [
                                                          {
                                                            'div' => '5.88',
                                                            'score' => '31',
                                                            'eqstart' => '1116',
                                                            'eqend' => '1169',
                                                            'start' => '975',
                                                            'end' => '1025'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-17_Croc',
                                            'ranges' => [
                                                          {
                                                            'div' => '9.82',
                                                            'score' => '65',
                                                            'eqstart' => '224',
                                                            'eqend' => '334',
                                                            'start' => '204',
                                                            'end' => '315'
                                                          },
                                                          {
                                                            'div' => '12.86',
                                                            'score' => '32',
                                                            'eqstart' => '565',
                                                            'eqend' => '633',
                                                            'start' => '532',
                                                            'end' => '601'
                                                          },
                                                          {
                                                            'div' => '8.65',
                                                            'score' => '1334',
                                                            'eqstart' => '1148',
                                                            'eqend' => '3474',
                                                            'start' => '865',
                                                            'end' => '3153'
                                                          },
                                                          {
                                                            'div' => '8.74',
                                                            'score' => '102',
                                                            'eqstart' => '5352',
                                                            'eqend' => '5532',
                                                            'start' => '3296',
                                                            'end' => '3478'
                                                          }
                                                        ]
                                          },
                                          {
                                            'name' => 'hAT-112_Ami',
                                            'ranges' => [
                                                          {
                                                            'div' => '6.03',
                                                            'score' => '80',
                                                            'eqstart' => '27',
                                                            'eqend' => '142',
                                                            'start' => '5',
                                                            'end' => '120'
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'hat-10_sbi' => {
                            'conlength' => '3639',
                            'subtype' => 'hAT-Tag1',
                            'equiv' => [
                                         {
                                           'name' => 'hAT-11_SBi',
                                           'ranges' => [
                                                         {
                                                           'div' => '0.00',
                                                           'score' => '35',
                                                           'eqstart' => 877,
                                                           'eqend' => 912,
                                                           'start' => 783,
                                                           'end' => 818
                                                         },
                                                         {
                                                           'div' => '9.09',
                                                           'score' => '85',
                                                           'eqstart' => 2821,
                                                           'eqend' => 2952,
                                                           'start' => 2670,
                                                           'end' => 2801
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'harbinger-1_vv' => {
                                'conlength' => '4128',
                                'subtype' => 'PIF-Harbinger',
                                'equiv' => [
                                             {
                                               'name' => 'Harbinger-1N1_VV',
                                               'ranges' => [
                                                             {
                                                               'div' => '1.40',
                                                               'score' => '171',
                                                               'eqstart' => 2,
                                                               'eqend' => 216,
                                                               'start' => 2,
                                                               'end' => 215
                                                             },
                                                             {
                                                               'div' => '7.50',
                                                               'score' => '77',
                                                               'eqstart' => '238',
                                                               'eqend' => '483',
                                                               'start' => 3720,
                                                               'end' => '3959'
                                                             },
                                                             {
                                                               'div' => '1.17',
                                                               'score' => '370',
                                                               'eqstart' => 222,
                                                               'eqend' => 734,
                                                               'start' => 3868,
                                                               'end' => 4378
                                                             },
                                                             {
                                                               'div' => '6.19',
                                                               'score' => '38',
                                                               'eqstart' => '222',
                                                               'eqend' => '340',
                                                               'start' => 4035,
                                                               'end' => '4147'
                                                             }
                                                           ]
                                             }
                                           ],
                                'type' => 'DNA'
                              },
          'dna-ta-1_tm' => {
                             'conlength' => '108',
                             'subtype' => 'TcMar-Stowaway',
                             'equiv' => [],
                             'type' => 'DNA'
                           },
          'dna-2-1_nv' => {
                            'conlength' => '1953',
                            'subtype' => undef,
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'mudr3x_sm' => {
                           'conlength' => '2211',
                           'subtype' => 'MULE-MuDR',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'hat1-1_nv' => {
                           'conlength' => '2438',
                           'subtype' => 'hAT-hAT1',
                           'equiv' => [],
                           'type' => 'DNA'
                         },
          'tc1-2_fr' => {
                          'conlength' => '1368',
                          'subtype' => 'TcMar-Tc1',
                          'equiv' => [],
                          'type' => 'DNA'
                        },
          'transib-9_hm' => {
                              'conlength' => '3734',
                              'subtype' => 'CMC-Transib',
                              'equiv' => [],
                              'type' => 'DNA'
                            },
          'mudr-4_cgi' => {
                            'conlength' => '2667',
                            'subtype' => 'MULE-MuDR',
                            'equiv' => [],
                            'type' => 'DNA'
                          },
          'charlie10b' => {
                            'conlength' => '183',
                            'subtype' => 'hAT-Charlie',
                            'equiv' => [
                                         {
                                           'name' => 'Charlie10',
                                           'ranges' => [
                                                         {
                                                           'div' => '5.56',
                                                           'score' => '91',
                                                           'eqstart' => 1378,
                                                           'eqend' => 1485,
                                                           'start' => 34,
                                                           'end' => 141
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '11.69',
                                                           'score' => '46',
                                                           'eqstart' => 1,
                                                           'eqend' => 76,
                                                           'start' => 166,
                                                           'end' => 242
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'MER5C1',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '5.19',
                                                           'score' => '61',
                                                           'eqstart' => 1,
                                                           'eqend' => 76,
                                                           'start' => 166,
                                                           'end' => 242
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'MER5C',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '5.19',
                                                           'score' => '61',
                                                           'eqstart' => 1,
                                                           'eqend' => 76,
                                                           'start' => 166,
                                                           'end' => 242
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'Charlie10a',
                                           'ranges' => [
                                                         {
                                                           'div' => '3.11',
                                                           'score' => '200',
                                                           'eqstart' => 57,
                                                           'eqend' => 280,
                                                           'start' => 18,
                                                           'end' => 242
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '2.17',
                                                           'score' => '42',
                                                           'eqstart' => 179,
                                                           'eqend' => 224,
                                                           'start' => 18,
                                                           'end' => 63
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '7.77',
                                                           'score' => '75',
                                                           'eqstart' => 1,
                                                           'eqend' => 102,
                                                           'start' => 140,
                                                           'end' => 242
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'mermite18f' => {
                            'conlength' => '1175',
                            'subtype' => 'MULE-MuDR',
                            'equiv' => [
                                         {
                                           'name' => 'MERMITE18C',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '10.53',
                                                           'score' => '36',
                                                           'eqstart' => 1395,
                                                           'eqend' => 1471,
                                                           'start' => 14,
                                                           'end' => 89
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '12.05',
                                                           'score' => '41',
                                                           'eqstart' => 3,
                                                           'eqend' => 178,
                                                           'start' => 996,
                                                           'end' => 1161
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'MERMITE18D',
                                           'ranges' => [
                                                         {
                                                           'div' => '9.66',
                                                           'score' => '87',
                                                           'eqstart' => 26,
                                                           'eqend' => 265,
                                                           'start' => 31,
                                                           'end' => 268
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '5.76',
                                                           'score' => '74',
                                                           'eqstart' => 1319,
                                                           'eqend' => 1464,
                                                           'start' => 33,
                                                           'end' => 171
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '6.28',
                                                           'score' => '87',
                                                           'eqstart' => 26,
                                                           'eqend' => 473,
                                                           'start' => 683,
                                                           'end' => 1144
                                                         },
                                                         {
                                                           'div' => '4.38',
                                                           'score' => '70',
                                                           'eqstart' => 1319,
                                                           'eqend' => 1464,
                                                           'start' => 1006,
                                                           'end' => 1142
                                                         }
                                                       ]
                                         },
                                         {
                                           'name' => 'MERMITE-18',
                                           'ranges' => [
                                                         {
                                                           'compl' => 1,
                                                           'div' => '8.88',
                                                           'score' => '93',
                                                           'eqstart' => 1045,
                                                           'eqend' => 1263,
                                                           'start' => 16,
                                                           'end' => 229
                                                         },
                                                         {
                                                           'div' => '7.84',
                                                           'score' => '101',
                                                           'eqstart' => '1',
                                                           'eqend' => '210',
                                                           'start' => 16,
                                                           'end' => 219
                                                         },
                                                         {
                                                           'div' => '10.33',
                                                           'score' => '77',
                                                           'eqstart' => 990,
                                                           'eqend' => 1263,
                                                           'start' => 889,
                                                           'end' => 1159
                                                         },
                                                         {
                                                           'compl' => 1,
                                                           'div' => '6.74',
                                                           'score' => '91',
                                                           'eqstart' => 1,
                                                           'eqend' => 201,
                                                           'start' => 967,
                                                           'end' => 1159
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'dna3-2b_pst' => {
                             'conlength' => '194',
                             'subtype' => undef,
                             'equiv' => [
                                          {
                                            'name' => 'DNA3-2_PSt',
                                            'ranges' => [
                                                          {
                                                            'div' => '0.00',
                                                            'score' => '41',
                                                            'eqstart' => '1',
                                                            'eqend' => '43',
                                                            'start' => '1',
                                                            'end' => '43'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '3.28',
                                                            'score' => '52',
                                                            'eqstart' => '78',
                                                            'eqend' => '138',
                                                            'start' => '1',
                                                            'end' => '61'
                                                          },
                                                          {
                                                            'div' => '1.64',
                                                            'score' => '54',
                                                            'eqstart' => '78',
                                                            'eqend' => '138',
                                                            'start' => '134',
                                                            'end' => '194'
                                                          },
                                                          {
                                                            'compl' => 1,
                                                            'div' => '0.00',
                                                            'score' => '41',
                                                            'eqstart' => '1',
                                                            'eqend' => '43',
                                                            'start' => '152',
                                                            'end' => '194'
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'piggybac-n1_dwil' => {
                                  'conlength' => '658',
                                  'subtype' => 'PiggyBac',
                                  'equiv' => [],
                                  'type' => 'DNA'
                                },
          'cryptonf-1_ro' => {
                               'conlength' => '3484',
                               'subtype' => 'Crypton-F',
                               'equiv' => [
                                            {
                                              'name' => 'Merlin-2_Roryzae',
                                              'ranges' => [
                                                            {
                                                              'div' => '7.98',
                                                              'score' => '196',
                                                              'eqstart' => '3032',
                                                              'eqend' => '3501',
                                                              'start' => '488',
                                                              'end' => '963'
                                                            }
                                                          ]
                                            }
                                          ],
                               'type' => 'DNA'
                             },
          'mariner-5_adi' => {
                               'conlength' => '3867',
                               'subtype' => 'TcMar-ISRm11',
                               'equiv' => [],
                               'type' => 'DNA'
                             },
          'hat-n34_dr' => {
                            'conlength' => '949',
                            'subtype' => 'hAT-Ac',
                            'equiv' => [
                                         {
                                           'name' => 'hAT-N48_DR',
                                           'ranges' => [
                                                         {
                                                           'div' => '8.94',
                                                           'score' => '86',
                                                           'eqstart' => 582,
                                                           'eqend' => 808,
                                                           'start' => 7,
                                                           'end' => 241
                                                         },
                                                         {
                                                           'div' => '3.45',
                                                           'score' => '33',
                                                           'eqstart' => 1394,
                                                           'eqend' => 1456,
                                                           'start' => 832,
                                                           'end' => 889
                                                         }
                                                       ]
                                         }
                                       ],
                            'type' => 'DNA'
                          },
          'isl2eu-n3b_cgi' => {
                                'conlength' => '736',
                                'subtype' => 'PIF-Spy',
                                'equiv' => [
                                             {
                                               'name' => 'DNA8-12_CGi',
                                               'ranges' => [
                                                             {
                                                               'compl' => 1,
                                                               'div' => '4.48',
                                                               'score' => '49',
                                                               'eqstart' => '1007',
                                                               'eqend' => '1073',
                                                               'start' => '3',
                                                               'end' => '69'
                                                             }
                                                           ]
                                             }
                                           ],
                                'type' => 'DNA'
                              },
          'dna-9-36_nv' => {
                             'conlength' => '48',
                             'subtype' => undef,
                             'equiv' => [
                                          {
                                            'name' => 'DNA-9-36A_NV',
                                            'ranges' => [
                                                          {
                                                            'div' => '0.00',
                                                            'score' => '30',
                                                            'eqstart' => '73',
                                                            'eqend' => '105',
                                                            'start' => '16',
                                                            'end' => '48'
                                                          }
                                                        ]
                                          }
                                        ],
                             'type' => 'DNA'
                           },
          'p-30_hm' => {
                         'conlength' => '4563',
                         'subtype' => 'P',
                         'equiv' => [
                                      {
                                        'name' => 'Mariner-19_HM',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '38',
                                                        'eqstart' => 1028,
                                                        'eqend' => 1104,
                                                        'start' => 3401,
                                                        'end' => 3477
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '39',
                                                        'eqstart' => 1028,
                                                        'eqend' => 1105,
                                                        'start' => 3402,
                                                        'end' => 3479
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '38',
                                                        'eqstart' => 1028,
                                                        'eqend' => 1104,
                                                        'start' => 4467,
                                                        'end' => 4543
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '38',
                                                        'eqstart' => 1028,
                                                        'eqend' => 1104,
                                                        'start' => 4486,
                                                        'end' => 4562
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'EnSpm-5_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '3.09',
                                                        'score' => '39',
                                                        'eqstart' => 3611,
                                                        'eqend' => 3707,
                                                        'start' => 3377,
                                                        'end' => 3473
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '3.09',
                                                        'score' => '39',
                                                        'eqstart' => 3611,
                                                        'eqend' => 3707,
                                                        'start' => 3382,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'div' => '2.08',
                                                        'score' => '38',
                                                        'eqstart' => 3612,
                                                        'eqend' => 3707,
                                                        'start' => 4467,
                                                        'end' => 4562
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '2.06',
                                                        'score' => '38',
                                                        'eqstart' => 3611,
                                                        'eqend' => 3707,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Transib-2_HM',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.97',
                                                        'score' => '52',
                                                        'eqstart' => 613,
                                                        'eqend' => 715,
                                                        'start' => 3377,
                                                        'end' => 3479
                                                      },
                                                      {
                                                        'div' => '0.98',
                                                        'score' => '51',
                                                        'eqstart' => 614,
                                                        'eqend' => 715,
                                                        'start' => 3377,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 614,
                                                        'eqend' => 710,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 615,
                                                        'eqend' => 711,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'P-27_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '2.94',
                                                        'score' => '45',
                                                        'eqstart' => 5099,
                                                        'eqend' => 5200,
                                                        'start' => 3377,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '1.96',
                                                        'score' => '48',
                                                        'eqstart' => 5109,
                                                        'eqend' => 5210,
                                                        'start' => 3377,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'div' => '2.02',
                                                        'score' => '47',
                                                        'eqstart' => 5200,
                                                        'eqend' => 5298,
                                                        'start' => 4465,
                                                        'end' => 4563
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '1.04',
                                                        'score' => '48',
                                                        'eqstart' => 5098,
                                                        'eqend' => 5193,
                                                        'start' => 4465,
                                                        'end' => 4560
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'DNA-8-1_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '1.03',
                                                        'score' => '49',
                                                        'eqstart' => 1626,
                                                        'eqend' => 1722,
                                                        'start' => 3377,
                                                        'end' => 3473
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '1.02',
                                                        'score' => '49',
                                                        'eqstart' => 1625,
                                                        'eqend' => 1722,
                                                        'start' => 3382,
                                                        'end' => 3479
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 1627,
                                                        'eqend' => 1722,
                                                        'start' => 4467,
                                                        'end' => 4562
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 1626,
                                                        'eqend' => 1722,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Academ-1_HM',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '32',
                                                        'eqstart' => 731,
                                                        'eqend' => 793,
                                                        'start' => 3415,
                                                        'end' => 3477
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '32',
                                                        'eqstart' => 731,
                                                        'eqend' => 794,
                                                        'start' => 3416,
                                                        'end' => 3479
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '1.22',
                                                        'score' => '44',
                                                        'eqstart' => 731,
                                                        'eqend' => 811,
                                                        'start' => 4453,
                                                        'end' => 4534
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '32',
                                                        'eqstart' => 731,
                                                        'eqend' => 793,
                                                        'start' => 4467,
                                                        'end' => 4529
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'EnSpm-9_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '50',
                                                        'eqstart' => 2978,
                                                        'eqend' => 3070,
                                                        'start' => 3385,
                                                        'end' => 3477
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '45',
                                                        'eqstart' => 2980,
                                                        'eqend' => 3070,
                                                        'start' => 3388,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '45',
                                                        'eqstart' => 2980,
                                                        'eqend' => 3070,
                                                        'start' => 4468,
                                                        'end' => 4558
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '45',
                                                        'eqstart' => 2980,
                                                        'eqend' => 3070,
                                                        'start' => 4473,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'hATm-54_HM',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.98',
                                                        'score' => '51',
                                                        'eqstart' => 506,
                                                        'eqend' => 607,
                                                        'start' => 3377,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'div' => '0.97',
                                                        'score' => '52',
                                                        'eqstart' => 510,
                                                        'eqend' => 612,
                                                        'start' => 3377,
                                                        'end' => 3479
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 506,
                                                        'eqend' => 602,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 505,
                                                        'eqend' => 601,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'hATw-3_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '37',
                                                        'eqstart' => 674,
                                                        'eqend' => 747,
                                                        'start' => 3387,
                                                        'end' => 3460
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '37',
                                                        'eqstart' => 673,
                                                        'eqend' => 747,
                                                        'start' => 3405,
                                                        'end' => 3479
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '37',
                                                        'eqstart' => 674,
                                                        'eqend' => 747,
                                                        'start' => 4468,
                                                        'end' => 4541
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '37',
                                                        'eqstart' => 674,
                                                        'eqend' => 747,
                                                        'start' => 4490,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'P-34_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '1.04',
                                                        'score' => '48',
                                                        'eqstart' => 3000,
                                                        'eqend' => 3095,
                                                        'start' => 3378,
                                                        'end' => 3473
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '1.04',
                                                        'score' => '48',
                                                        'eqstart' => 3000,
                                                        'eqend' => 3095,
                                                        'start' => 3382,
                                                        'end' => 3477
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 3000,
                                                        'eqend' => 3095,
                                                        'start' => 4467,
                                                        'end' => 4562
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 3000,
                                                        'eqend' => 3095,
                                                        'start' => 4467,
                                                        'end' => 4562
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Mariner-33_HM',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.98',
                                                        'score' => '51',
                                                        'eqstart' => 749,
                                                        'eqend' => 850,
                                                        'start' => 3377,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'div' => '0.97',
                                                        'score' => '52',
                                                        'eqstart' => 783,
                                                        'eqend' => 885,
                                                        'start' => 3377,
                                                        'end' => 3479
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '52',
                                                        'eqstart' => 747,
                                                        'eqend' => 844,
                                                        'start' => 4466,
                                                        'end' => 4563
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 749,
                                                        'eqend' => 845,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Harbinger2-2_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '0.98',
                                                        'score' => '51',
                                                        'eqstart' => 255,
                                                        'eqend' => 356,
                                                        'start' => 3377,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.98',
                                                        'score' => '51',
                                                        'eqstart' => 255,
                                                        'eqend' => 356,
                                                        'start' => 3377,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 254,
                                                        'eqend' => 350,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 255,
                                                        'eqend' => 351,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'EnSpm-21_HMa',
                                        'ranges' => [
                                                      {
                                                        'div' => '7.84',
                                                        'score' => '30',
                                                        'eqstart' => '4458',
                                                        'eqend' => '4559',
                                                        'start' => '3377',
                                                        'end' => '3478'
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '6.12',
                                                        'score' => '34',
                                                        'eqstart' => '4462',
                                                        'eqend' => '4559',
                                                        'start' => '3381',
                                                        'end' => '3478'
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '1.12',
                                                        'score' => '55',
                                                        'eqstart' => '4458',
                                                        'eqend' => '4546',
                                                        'start' => '4453',
                                                        'end' => '4541'
                                                      },
                                                      {
                                                        'div' => '6.25',
                                                        'score' => '30',
                                                        'eqstart' => '4458',
                                                        'eqend' => '4553',
                                                        'start' => '4468',
                                                        'end' => '4563'
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Ginger1-5_HM',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '45',
                                                        'eqstart' => 4463,
                                                        'eqend' => 4553,
                                                        'start' => 3387,
                                                        'end' => 3477
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '46',
                                                        'eqstart' => 4463,
                                                        'eqend' => 4554,
                                                        'start' => 3388,
                                                        'end' => 3479
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '33',
                                                        'eqstart' => 3659,
                                                        'eqend' => 3705,
                                                        'start' => 4433,
                                                        'end' => 4479
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '45',
                                                        'eqstart' => 4463,
                                                        'eqend' => 4553,
                                                        'start' => 4467,
                                                        'end' => 4557
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '45',
                                                        'eqstart' => 4463,
                                                        'eqend' => 4553,
                                                        'start' => 4472,
                                                        'end' => 4562
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Sola2-1_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '43',
                                                        'eqstart' => 826,
                                                        'eqend' => 905,
                                                        'start' => 3385,
                                                        'end' => 3464
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '45',
                                                        'eqstart' => 1343,
                                                        'eqend' => 1432,
                                                        'start' => 3387,
                                                        'end' => 3476
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '45',
                                                        'eqstart' => 1342,
                                                        'eqend' => 1432,
                                                        'start' => 3389,
                                                        'end' => 3479
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '39',
                                                        'eqstart' => 828,
                                                        'eqend' => 905,
                                                        'start' => 3401,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'div' => '2.15',
                                                        'score' => '33',
                                                        'eqstart' => 814,
                                                        'eqend' => 905,
                                                        'start' => 4467,
                                                        'end' => 4559
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '45',
                                                        'eqstart' => 1343,
                                                        'eqend' => 1432,
                                                        'start' => 4468,
                                                        'end' => 4557
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '2.15',
                                                        'score' => '33',
                                                        'eqstart' => 814,
                                                        'eqend' => 905,
                                                        'start' => 4470,
                                                        'end' => 4562
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '45',
                                                        'eqstart' => 1343,
                                                        'eqend' => 1432,
                                                        'start' => 4474,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Mariner-31_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '0.98',
                                                        'score' => '51',
                                                        'eqstart' => 859,
                                                        'eqend' => 960,
                                                        'start' => 3377,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.97',
                                                        'score' => '52',
                                                        'eqstart' => 858,
                                                        'eqend' => 960,
                                                        'start' => 3377,
                                                        'end' => 3479
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '53',
                                                        'eqstart' => 889,
                                                        'eqend' => 987,
                                                        'start' => 4465,
                                                        'end' => 4563
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 860,
                                                        'eqend' => 956,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'EnSpm-8_HM',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 3194,
                                                        'eqend' => 3282,
                                                        'start' => 3384,
                                                        'end' => 3472
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '43',
                                                        'eqstart' => 3194,
                                                        'eqend' => 3279,
                                                        'start' => 3387,
                                                        'end' => 3472
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '43',
                                                        'eqstart' => 3194,
                                                        'eqend' => 3279,
                                                        'start' => 4468,
                                                        'end' => 4553
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '43',
                                                        'eqstart' => 3194,
                                                        'eqend' => 3279,
                                                        'start' => 4478,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Chapaev-6_HM',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.96',
                                                        'score' => '59',
                                                        'eqstart' => 4427,
                                                        'eqend' => 4530,
                                                        'start' => 3375,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'div' => '0.98',
                                                        'score' => '51',
                                                        'eqstart' => 4411,
                                                        'eqend' => 4512,
                                                        'start' => 3377,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 4411,
                                                        'eqend' => 4507,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '52',
                                                        'eqstart' => 4432,
                                                        'eqend' => 4529,
                                                        'start' => 4467,
                                                        'end' => 4564
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Mariner-36_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '1.00',
                                                        'score' => '50',
                                                        'eqstart' => 898,
                                                        'eqend' => 997,
                                                        'start' => 3378,
                                                        'end' => 3477
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '1.00',
                                                        'score' => '50',
                                                        'eqstart' => 898,
                                                        'eqend' => 997,
                                                        'start' => 3378,
                                                        'end' => 3477
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '53',
                                                        'eqstart' => 896,
                                                        'eqend' => 994,
                                                        'start' => 4465,
                                                        'end' => 4563
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 899,
                                                        'eqend' => 995,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Transib-3_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '0.98',
                                                        'score' => '51',
                                                        'eqstart' => 592,
                                                        'eqend' => 693,
                                                        'start' => 3377,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.97',
                                                        'score' => '52',
                                                        'eqstart' => 591,
                                                        'eqend' => 693,
                                                        'start' => 3377,
                                                        'end' => 3479
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '53',
                                                        'eqstart' => 706,
                                                        'eqend' => 804,
                                                        'start' => 4465,
                                                        'end' => 4563
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 593,
                                                        'eqend' => 689,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'EnSpm-7_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '0.97',
                                                        'score' => '56',
                                                        'eqstart' => 3566,
                                                        'eqend' => 3668,
                                                        'start' => 3376,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'div' => '3.88',
                                                        'score' => '34',
                                                        'eqstart' => 3172,
                                                        'eqend' => 3273,
                                                        'start' => 3377,
                                                        'end' => 3479
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.98',
                                                        'score' => '51',
                                                        'eqstart' => 3567,
                                                        'eqend' => 3668,
                                                        'start' => 3377,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '2.06',
                                                        'score' => '37',
                                                        'eqstart' => 3172,
                                                        'eqend' => 3267,
                                                        'start' => 3380,
                                                        'end' => 3476
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '50',
                                                        'eqstart' => 499,
                                                        'eqend' => 592,
                                                        'start' => 3383,
                                                        'end' => 3476
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '41',
                                                        'eqstart' => 3977,
                                                        'eqend' => 4059,
                                                        'start' => 3387,
                                                        'end' => 3469
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '45',
                                                        'eqstart' => 503,
                                                        'eqend' => 592,
                                                        'start' => 3389,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '41',
                                                        'eqstart' => 3977,
                                                        'eqend' => 4059,
                                                        'start' => 3396,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.97',
                                                        'score' => '57',
                                                        'eqstart' => 3643,
                                                        'eqend' => 3745,
                                                        'start' => 4461,
                                                        'end' => 4563
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '2.02',
                                                        'score' => '38',
                                                        'eqstart' => 3172,
                                                        'eqend' => 3269,
                                                        'start' => 4465,
                                                        'end' => 4563
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '46',
                                                        'eqstart' => 3977,
                                                        'eqend' => 4061,
                                                        'start' => 4465,
                                                        'end' => 4549
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 3568,
                                                        'eqend' => 3664,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      },
                                                      {
                                                        'div' => '1.06',
                                                        'score' => '44',
                                                        'eqstart' => 499,
                                                        'eqend' => 592,
                                                        'start' => 4468,
                                                        'end' => 4561
                                                      },
                                                      {
                                                        'div' => '2.11',
                                                        'score' => '33',
                                                        'eqstart' => 3172,
                                                        'eqend' => 3267,
                                                        'start' => 4468,
                                                        'end' => 4562
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '41',
                                                        'eqstart' => 3977,
                                                        'eqend' => 4059,
                                                        'start' => 4468,
                                                        'end' => 4550
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '1.06',
                                                        'score' => '44',
                                                        'eqstart' => 499,
                                                        'eqend' => 592,
                                                        'start' => 4470,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'hATm-47_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '1.19',
                                                        'score' => '42',
                                                        'eqstart' => 3502,
                                                        'eqend' => 3585,
                                                        'start' => 3384,
                                                        'end' => 3467
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '40',
                                                        'eqstart' => 3506,
                                                        'eqend' => 3585,
                                                        'start' => 3398,
                                                        'end' => 3477
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '44',
                                                        'eqstart' => 3505,
                                                        'eqend' => 3585,
                                                        'start' => 4466,
                                                        'end' => 4546
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '40',
                                                        'eqstart' => 3506,
                                                        'eqend' => 3585,
                                                        'start' => 4483,
                                                        'end' => 4562
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'hAT-80_HM',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '1.09',
                                                        'score' => '44',
                                                        'eqstart' => 801,
                                                        'eqend' => 892,
                                                        'start' => 3382,
                                                        'end' => 3473
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '42',
                                                        'eqstart' => 801,
                                                        'eqend' => 884,
                                                        'start' => 3388,
                                                        'end' => 3471
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '42',
                                                        'eqstart' => 801,
                                                        'eqend' => 884,
                                                        'start' => 4467,
                                                        'end' => 4550
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '42',
                                                        'eqstart' => 801,
                                                        'eqend' => 884,
                                                        'start' => 4479,
                                                        'end' => 4562
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'EnSpm-22_HMa',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '1.02',
                                                        'score' => '53',
                                                        'eqstart' => '2529',
                                                        'eqend' => '2626',
                                                        'start' => '3376',
                                                        'end' => '3473'
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.98',
                                                        'score' => '51',
                                                        'eqstart' => '2059',
                                                        'eqend' => '2160',
                                                        'start' => '3377',
                                                        'end' => '3478'
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.98',
                                                        'score' => '51',
                                                        'eqstart' => '5647',
                                                        'eqend' => '5748',
                                                        'start' => '3377',
                                                        'end' => '3478'
                                                      },
                                                      {
                                                        'div' => '0.98',
                                                        'score' => '51',
                                                        'eqstart' => '2059',
                                                        'eqend' => '2160',
                                                        'start' => '3377',
                                                        'end' => '3478'
                                                      },
                                                      {
                                                        'div' => '0.98',
                                                        'score' => '51',
                                                        'eqstart' => '5647',
                                                        'eqend' => '5748',
                                                        'start' => '3377',
                                                        'end' => '3478'
                                                      },
                                                      {
                                                        'div' => '1.03',
                                                        'score' => '49',
                                                        'eqstart' => '2529',
                                                        'eqend' => '2625',
                                                        'start' => '3378',
                                                        'end' => '3474'
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '53',
                                                        'eqstart' => '5669',
                                                        'eqend' => '5767',
                                                        'start' => '4465',
                                                        'end' => '4563'
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '53',
                                                        'eqstart' => '2056',
                                                        'eqend' => '2154',
                                                        'start' => '4465',
                                                        'end' => '4563'
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => '2059',
                                                        'eqend' => '2155',
                                                        'start' => '4467',
                                                        'end' => '4563'
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '52',
                                                        'eqstart' => '2529',
                                                        'eqend' => '2626',
                                                        'start' => '4467',
                                                        'end' => '4564'
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => '5646',
                                                        'eqend' => '5742',
                                                        'start' => '4467',
                                                        'end' => '4563'
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => '2530',
                                                        'eqend' => '2625',
                                                        'start' => '4468',
                                                        'end' => '4563'
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'hAT-54_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '1.14',
                                                        'score' => '53',
                                                        'eqstart' => 4678,
                                                        'eqend' => 4765,
                                                        'start' => 3374,
                                                        'end' => 3461
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '42',
                                                        'eqstart' => 4681,
                                                        'eqend' => 4765,
                                                        'start' => 3394,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '42',
                                                        'eqstart' => 4681,
                                                        'eqend' => 4765,
                                                        'start' => 4468,
                                                        'end' => 4552
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '46',
                                                        'eqstart' => 4680,
                                                        'eqend' => 4765,
                                                        'start' => 4479,
                                                        'end' => 4564
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Chapaev-20_HM',
                                        'ranges' => [
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.97',
                                                        'score' => '52',
                                                        'eqstart' => 218,
                                                        'eqend' => 320,
                                                        'start' => 3377,
                                                        'end' => 3479
                                                      },
                                                      {
                                                        'div' => '0.98',
                                                        'score' => '51',
                                                        'eqstart' => 219,
                                                        'eqend' => 320,
                                                        'start' => 3377,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 219,
                                                        'eqend' => 315,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 220,
                                                        'eqend' => 316,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'Chapaev-7_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '37',
                                                        'eqstart' => 1760,
                                                        'eqend' => 1833,
                                                        'start' => 3387,
                                                        'end' => 3460
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '37',
                                                        'eqstart' => 1759,
                                                        'eqend' => 1833,
                                                        'start' => 3405,
                                                        'end' => 3479
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '37',
                                                        'eqstart' => 1760,
                                                        'eqend' => 1833,
                                                        'start' => 4468,
                                                        'end' => 4541
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '37',
                                                        'eqstart' => 1760,
                                                        'eqend' => 1833,
                                                        'start' => 4490,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'EnSpm-2_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '1.03',
                                                        'score' => '49',
                                                        'eqstart' => 5073,
                                                        'eqend' => 5169,
                                                        'start' => 3378,
                                                        'end' => 3474
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '50',
                                                        'eqstart' => 5078,
                                                        'eqend' => 5171,
                                                        'start' => 3385,
                                                        'end' => 3478
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 5073,
                                                        'eqend' => 5169,
                                                        'start' => 4467,
                                                        'end' => 4563
                                                      },
                                                      {
                                                        'compl' => 1,
                                                        'div' => '0.00',
                                                        'score' => '48',
                                                        'eqstart' => 5074,
                                                        'eqend' => 5169,
                                                        'start' => 4468,
                                                        'end' => 4563
                                                      }
                                                    ]
                                      },
                                      {
                                        'name' => 'EnSpm-10_HM',
                                        'ranges' => [
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '42',
                                                        'eqstart' => 859,
                                                        'eqend' => 935,
                                                        'start' => 3380,
                                                        'end' => 3456
                                                      },
                                                      {
                                                        'div' => '0.00',
                                                        'score' => '39',
                                                        'eqstart' => 3950,
         